/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategyFactory;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormattingDocumentModelImpl
implements FormattingDocumentModel {
    private final WhiteSpaceFormattingStrategy myWhiteSpaceStrategy;
    @NotNull
    private final Document myDocument;
    private final PsiFile myFile;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.formatter.FormattingDocumentModelImpl");
    private final CodeStyleSettings mySettings;

    public FormattingDocumentModelImpl(@NotNull Document document, PsiFile file) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/formatter/FormattingDocumentModelImpl", "<init>"));
        }
        this.myDocument = document;
        this.myFile = file;
        if (file != null) {
            Language language = file.getLanguage();
            this.myWhiteSpaceStrategy = WhiteSpaceFormattingStrategyFactory.getStrategy(language);
        } else {
            this.myWhiteSpaceStrategy = WhiteSpaceFormattingStrategyFactory.getStrategy();
        }
        this.mySettings = CodeStyleSettingsManager.getSettings((Project)(file != null ? file.getProject() : null));
    }

    public static FormattingDocumentModelImpl createOn(PsiFile file) {
        Document document = FormattingDocumentModelImpl.getDocumentToBeUsedFor(file);
        if (document != null) {
            if (PsiDocumentManager.getInstance((Project)file.getProject()).isUncommited(document)) {
                LOG.error("Document is uncommitted");
            }
            if (file.getTextLength() != document.getTextLength()) {
                LOG.error("Document and psi file texts should be equal: " + file + " file length = " + file.getTextLength() + ", document length = " + document.getTextLength());
            }
            return new FormattingDocumentModelImpl(document, file);
        }
        return new FormattingDocumentModelImpl(new DocumentImpl(file.getViewProvider().getContents()), file);
    }

    @Nullable
    public static Document getDocumentToBeUsedFor(PsiFile file) {
        Project project = file.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            return null;
        }
        if (PsiDocumentManager.getInstance((Project)project).isUncommited(document)) {
            return null;
        }
        PsiToDocumentSynchronizer synchronizer = ((PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)project)).getSynchronizer();
        if (synchronizer.isDocumentAffectedByTransactions(document)) {
            return null;
        }
        return document;
    }

    public int getLineNumber(int offset) {
        if (offset > this.myDocument.getTextLength()) {
            LOG.error(String.format("Invalid offset detected (%d). Document length: %d. Target file: %s", offset, this.myDocument.getTextLength(), this.myFile));
        }
        return this.myDocument.getLineNumber(offset);
    }

    public int getLineStartOffset(int line) {
        return this.myDocument.getLineStartOffset(line);
    }

    public CharSequence getText(TextRange textRange) {
        if (textRange.getStartOffset() < 0 || textRange.getEndOffset() > this.myDocument.getTextLength()) {
            LOG.error(String.format("Please submit a ticket to the tracker and attach current source file to it!%nInvalid processing detected: given text range (%s) targets non-existing regions (the boundaries are [0; %d)). File's language: %s", textRange, this.myDocument.getTextLength(), this.myFile.getLanguage()));
        }
        return this.myDocument.getCharsSequence().subSequence(textRange.getStartOffset(), textRange.getEndOffset());
    }

    public int getTextLength() {
        return this.myDocument.getTextLength();
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/FormattingDocumentModelImpl", "getDocument"));
        }
        return document;
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public boolean containsWhiteSpaceSymbolsOnly(int startOffset, int endOffset) {
        WhiteSpaceFormattingStrategy localStrategy;
        Language injectedLanguage;
        PsiElement injectedElement;
        WhiteSpaceFormattingStrategy strategy = this.myWhiteSpaceStrategy;
        if (strategy.check(this.myDocument.getCharsSequence(), startOffset, endOffset) >= endOffset) {
            return true;
        }
        PsiElement psiElement = injectedElement = this.myFile != null ? InjectedLanguageUtil.findElementAtNoCommit(this.myFile, startOffset) : null;
        if (injectedElement != null && !(injectedLanguage = injectedElement.getLanguage()).equals(this.myFile.getLanguage()) && (localStrategy = WhiteSpaceFormattingStrategyFactory.getStrategy(injectedLanguage)) != null) {
            return localStrategy.check(this.myDocument.getCharsSequence(), startOffset, endOffset) >= endOffset;
        }
        return false;
    }

    @NotNull
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, int startOffset, int endOffset, ASTNode nodeAfter, boolean changedViaPsi) {
        if (whiteSpaceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whiteSpaceText", "com/intellij/psi/formatter/FormattingDocumentModelImpl", "adjustWhiteSpaceIfNecessary"));
        }
        if (!changedViaPsi) {
            CharSequence charSequence = this.myWhiteSpaceStrategy.adjustWhiteSpaceIfNecessary(whiteSpaceText, this.myDocument.getCharsSequence(), startOffset, endOffset, this.mySettings, nodeAfter);
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/FormattingDocumentModelImpl", "adjustWhiteSpaceIfNecessary"));
            }
            return charSequence;
        }
        PsiElement element = this.myFile.findElementAt(startOffset);
        if (element == null) {
            CharSequence charSequence = whiteSpaceText;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/FormattingDocumentModelImpl", "adjustWhiteSpaceIfNecessary"));
            }
            return charSequence;
        }
        CharSequence charSequence = this.myWhiteSpaceStrategy.adjustWhiteSpaceIfNecessary(whiteSpaceText, element, startOffset, endOffset, this.mySettings);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/FormattingDocumentModelImpl", "adjustWhiteSpaceIfNecessary"));
        }
        return charSequence;
    }

    public static boolean canUseDocumentModel(@NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/formatter/FormattingDocumentModelImpl", "canUseDocumentModel"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/formatter/FormattingDocumentModelImpl", "canUseDocumentModel"));
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)file.getProject());
        return !psiDocumentManager.isUncommited(document) && !psiDocumentManager.isDocumentBlockedByPsi(document) && file.getText().equals(document.getText());
    }
}

