/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.extractMethodObject.ExtractMethodObjectProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.duplicates.DuplicatesImpl;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ExtractMethodObjectHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)("#" + ExtractMethodObjectHandler.class.getName()));

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "invoke"));
        }
        ExtractMethodHandler.selectAndPass(project, editor, file, new Pass<PsiElement[]>(){

            public void pass(PsiElement[] selectedValue) {
                ExtractMethodObjectHandler.invokeOnElements(project, editor, file, selectedValue);
            }
        });
    }

    private static void invokeOnElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement[] elements) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "invokeOnElements"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "invokeOnElements"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "invokeOnElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "invokeOnElements"));
        }
        if (elements.length == 0) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.block.should.represent.a.set.of.statements.or.an.expression"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)"Extract Method Object", (String)"refactoring.extractMethodObject");
            return;
        }
        try {
            ExtractMethodObjectHandler.extractMethodObject(project, editor, new ExtractMethodObjectProcessor(project, editor, elements, ""));
        }
        catch (PrepareFailedException e) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)"Extract Method Object", (String)"refactoring.extractMethodObject");
            ExtractMethodHandler.highlightPrepareError(e, file, editor, project);
        }
    }

    static void extractMethodObject(Project project, Editor editor, ExtractMethodObjectProcessor processor) throws PrepareFailedException {
        ExtractMethodObjectProcessor.MyExtractMethodProcessor extractProcessor = processor.getExtractProcessor();
        if (!extractProcessor.prepare()) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)extractProcessor.getTargetClass().getContainingFile())) {
            return;
        }
        if (extractProcessor.showDialog()) {
            ExtractMethodObjectHandler.run(project, editor, processor, extractProcessor);
        }
    }

    public static void run(final @NotNull Project project, final Editor editor, final @NotNull ExtractMethodObjectProcessor processor, final @NotNull ExtractMethodObjectProcessor.MyExtractMethodProcessor extractProcessor) {
        RangeMarker marker;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "run"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "run"));
        }
        if (extractProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractProcessor", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "run"));
        }
        if (editor != null) {
            int offset = editor.getCaretModel().getOffset();
            marker = editor.getDocument().createRangeMarker(new TextRange(offset, offset));
        } else {
            marker = null;
        }
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                PostprocessReformattingAspect.getInstance(project).postponeFormattingInside(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                @Override
                                public void run() {
                                    extractProcessor.doRefactoring();
                                }
                            });
                            processor.run();
                            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                @Override
                                public void run() {
                                    processor.runChangeSignature();
                                }
                            });
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                        if (processor.isCreateInnerClass()) {
                            processor.moveUsedMethodsToInner();
                            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                            if (editor != null) {
                                DuplicatesImpl.processDuplicates(extractProcessor, project, editor);
                            }
                        }
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                if (processor.isCreateInnerClass()) {
                                    processor.changeInstanceAccess(project);
                                }
                                PsiMethod method = processor.getMethod();
                                LOG.assertTrue(method != null);
                                method.delete();
                            }
                        });
                    }
                });
            }
        }, "Extract Method Object", (Object)"Extract Method Object");
        if (editor != null) {
            editor.getCaretModel().moveToOffset(marker.getStartOffset());
            marker.dispose();
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "invoke"));
        }
        throw new UnsupportedOperationException();
    }
}

