/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.makeStatic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.makeStatic.InternalUsageInfo;
import com.intellij.refactoring.makeStatic.MakeMethodOrClassStaticProcessor;
import com.intellij.refactoring.makeStatic.SelfUsageInfo;
import com.intellij.refactoring.makeStatic.Settings;
import com.intellij.refactoring.move.MoveInstanceMembersUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.javadoc.MethodJavaDocHelper;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.List;

public class MakeClassStaticProcessor
extends MakeMethodOrClassStaticProcessor<PsiClass> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.makeMethodStatic.MakeClassStaticProcessor");
    private List<PsiField> myFieldsToSplit = new ArrayList<PsiField>();

    public MakeClassStaticProcessor(Project project, PsiClass aClass, Settings settings) {
        super(project, aClass, settings);
    }

    @Override
    protected void changeSelf(PsiElementFactory factory, UsageInfo[] usages) throws IncorrectOperationException {
        PsiMethod[] constructors;
        PsiClass containingClass = ((PsiClass)this.myMember).getContainingClass();
        if (this.mySettings.isMakeClassParameter()) {
            PsiClassType type = factory.createType(containingClass, PsiSubstitutor.EMPTY);
            String classParameterName = this.mySettings.getClassParameterName();
            String fieldName = this.convertToFieldName(classParameterName);
            ((PsiClass)this.myMember).add((PsiElement)factory.createField(fieldName, (PsiType)type));
        }
        if (this.mySettings.isMakeFieldParameters()) {
            List<Settings.FieldParameter> parameters = this.mySettings.getParameterOrderList();
            for (Settings.FieldParameter fieldParameter : parameters) {
                PsiType type = fieldParameter.type;
                PsiField field = factory.createField(this.convertToFieldName(fieldParameter.name), type);
                ((PsiClass)this.myMember).add((PsiElement)field);
            }
        }
        if ((constructors = ((PsiClass)this.myMember).getConstructors()).length == 0) {
            PsiMethod defConstructor = (PsiMethod)((PsiClass)this.myMember).add((PsiElement)factory.createConstructor());
            constructors = new PsiMethod[]{defConstructor};
        }
        boolean generateFinalParams = CodeStyleSettingsManager.getSettings((Project)this.myProject).GENERATE_FINAL_PARAMETERS;
        for (PsiMethod constructor : constructors) {
            MethodJavaDocHelper javaDocHelper = new MethodJavaDocHelper(constructor);
            PsiParameterList paramList = constructor.getParameterList();
            PsiElement addParameterAfter = null;
            PsiDocTag anchor = null;
            if (this.mySettings.isMakeClassParameter()) {
                PsiClassType parameterType = factory.createType(containingClass, PsiSubstitutor.EMPTY);
                String classParameterName = this.mySettings.getClassParameterName();
                PsiParameter parameter = factory.createParameter(classParameterName, (PsiType)parameterType);
                PsiUtil.setModifierProperty((PsiModifierListOwner)parameter, (String)"final", (this.makeClassParameterFinal(usages) || generateFinalParams ? 1 : 0) != 0);
                addParameterAfter = paramList.addAfter((PsiElement)parameter, null);
                anchor = javaDocHelper.addParameterAfter(classParameterName, anchor);
                this.addAssignmentToField(classParameterName, constructor);
            }
            if (this.mySettings.isMakeFieldParameters()) {
                List<Settings.FieldParameter> parameters = this.mySettings.getParameterOrderList();
                for (Settings.FieldParameter fieldParameter : parameters) {
                    PsiType fieldParameterType = fieldParameter.field.getType();
                    PsiParameter parameter = factory.createParameter(fieldParameter.name, fieldParameterType);
                    PsiUtil.setModifierProperty((PsiModifierListOwner)parameter, (String)"final", (MakeClassStaticProcessor.makeFieldParameterFinal(fieldParameter.field, usages) || generateFinalParams ? 1 : 0) != 0);
                    addParameterAfter = paramList.addAfter((PsiElement)parameter, addParameterAfter);
                    anchor = javaDocHelper.addParameterAfter(fieldParameter.name, anchor);
                    this.addAssignmentToField(fieldParameter.name, constructor);
                }
                for (UsageInfo usage : usages) {
                    PsiField field;
                    if (!(usage instanceof InternalUsageInfo)) continue;
                    PsiElement element = usage.getElement();
                    PsiElement referencedElement = ((InternalUsageInfo)usage).getReferencedElement();
                    if (!(referencedElement instanceof PsiField) || this.mySettings.getNameForField((PsiField)referencedElement) == null || (field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class)) == null) continue;
                    MoveInstanceMembersUtil.moveInitializerToConstructor(factory, constructor, field);
                }
            }
            for (PsiField field : this.myFieldsToSplit) {
                MoveInstanceMembersUtil.moveInitializerToConstructor(factory, constructor, field);
            }
        }
        this.setupTypeParameterList(this.myMember);
        PsiModifierList modifierList = ((PsiClass)this.myMember).getModifierList();
        modifierList.setModifierProperty("static", true);
        modifierList.setModifierProperty("final", false);
    }

    private void addAssignmentToField(String parameterName, PsiMethod constructor) {
        String fieldName = this.convertToFieldName(parameterName);
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        PsiCodeBlock body = constructor.getBody();
        if (body != null) {
            try {
                PsiReferenceExpression refExpr = (PsiReferenceExpression)factory.createExpressionFromText(fieldName, (PsiElement)body);
                if (refExpr.resolve() != null) {
                    fieldName = "this." + fieldName;
                }
                PsiStatement statement = factory.createStatementFromText(fieldName + "=" + parameterName + ";", null);
                statement = (PsiStatement)CodeStyleManager.getInstance((Project)manager.getProject()).reformat((PsiElement)statement);
                body.add((PsiElement)statement);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private String convertToFieldName(String parameterName) {
        JavaCodeStyleManager manager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        String propertyName = manager.variableNameToPropertyName(parameterName, VariableKind.PARAMETER);
        String fieldName = manager.propertyNameToVariableName(propertyName, VariableKind.FIELD);
        return fieldName;
    }

    @Override
    protected void changeSelfUsage(SelfUsageInfo usageInfo) throws IncorrectOperationException {
        PsiElement parent = usageInfo.getElement().getParent();
        LOG.assertTrue(parent instanceof PsiCallExpression);
        PsiCallExpression call = (PsiCallExpression)parent;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)call.getProject()).getElementFactory();
        PsiExpressionList args = call.getArgumentList();
        PsiElement addParameterAfter = null;
        if (this.mySettings.isMakeClassParameter()) {
            PsiExpression arg = factory.createExpressionFromText(this.convertToFieldName(this.mySettings.getClassParameterName()), null);
            addParameterAfter = args.addAfter((PsiElement)arg, null);
        }
        if (this.mySettings.isMakeFieldParameters()) {
            List<Settings.FieldParameter> parameters = this.mySettings.getParameterOrderList();
            for (Settings.FieldParameter fieldParameter : parameters) {
                PsiExpression arg = factory.createExpressionFromText(this.convertToFieldName(fieldParameter.name), null);
                if (addParameterAfter == null) {
                    addParameterAfter = args.addAfter((PsiElement)arg, null);
                    continue;
                }
                addParameterAfter = args.addAfter((PsiElement)arg, addParameterAfter);
            }
        }
    }

    @Override
    protected void changeInternalUsage(InternalUsageInfo usage, PsiElementFactory factory) throws IncorrectOperationException {
        if (!this.mySettings.isChangeSignature()) {
            return;
        }
        PsiElement element = usage.getElement();
        if (element instanceof PsiReferenceExpression) {
            String name;
            PsiElement resolved;
            PsiReferenceExpression newRef = null;
            if (this.mySettings.isMakeFieldParameters() && (resolved = ((PsiReferenceExpression)element).resolve()) instanceof PsiField && (name = this.mySettings.getNameForField((PsiField)resolved)) != null && (name = this.convertToFieldName(name)) != null) {
                newRef = (PsiReferenceExpression)factory.createExpressionFromText(name, null);
            }
            if (newRef == null && this.mySettings.isMakeClassParameter()) {
                newRef = (PsiReferenceExpression)factory.createExpressionFromText(this.convertToFieldName(this.mySettings.getClassParameterName()) + "." + element.getText(), null);
            }
            if (newRef != null) {
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
                newRef = (PsiReferenceExpression)codeStyleManager.reformat(newRef);
                element.replace((PsiElement)newRef);
            }
        } else if (this.mySettings.isMakeClassParameter() && (element instanceof PsiThisExpression || element instanceof PsiSuperExpression)) {
            PsiElement replace = element.replace((PsiElement)factory.createExpressionFromText(this.convertToFieldName(this.mySettings.getClassParameterName()), null));
            PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)replace, PsiField.class);
            if (field != null) {
                this.myFieldsToSplit.add(field);
            }
        } else if (element instanceof PsiNewExpression && this.mySettings.isMakeClassParameter()) {
            PsiNewExpression newExpression = (PsiNewExpression)element;
            LOG.assertTrue(newExpression.getQualifier() == null);
            String newText = this.convertToFieldName(this.mySettings.getClassParameterName()) + "." + newExpression.getText();
            PsiExpression expr = factory.createExpressionFromText(newText, null);
            element.replace((PsiElement)expr);
        }
    }

    @Override
    protected void changeExternalUsage(UsageInfo usage, PsiElementFactory factory) throws IncorrectOperationException {
        int copyingSafetyLevel;
        PsiReferenceExpression newQualifier;
        PsiExpression instanceRef;
        PsiElement element = usage.getElement();
        if (!(element instanceof PsiJavaCodeReferenceElement)) {
            return;
        }
        PsiJavaCodeReferenceElement methodRef = (PsiJavaCodeReferenceElement)element;
        PsiElement parent = methodRef.getParent();
        if (parent instanceof PsiAnonymousClass) {
            parent = parent.getParent();
        }
        LOG.assertTrue(parent instanceof PsiCallExpression, (Object)("call expression expected, found " + parent));
        PsiCallExpression call = (PsiCallExpression)parent;
        PsiExpression psiExpression = instanceRef = call instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)call).getMethodExpression().getQualifierExpression() : ((PsiNewExpression)call).getQualifier();
        if (instanceRef == null || instanceRef instanceof PsiSuperExpression) {
            PsiClass thisClass = RefactoringChangeUtil.getThisClass(element);
            String thisText = thisClass.getManager().areElementsEquivalent((PsiElement)thisClass, (PsiElement)((PsiClass)this.myMember).getContainingClass()) ? "this" : ((PsiClass)this.myMember).getContainingClass().getName() + ".this";
            instanceRef = factory.createExpressionFromText(thisText, null);
            newQualifier = null;
        } else {
            newQualifier = factory.createReferenceExpression(((PsiClass)this.myMember).getContainingClass());
        }
        if (this.mySettings.getNewParametersNumber() > 1 && (copyingSafetyLevel = RefactoringUtil.verifySafeCopyExpression((PsiElement)instanceRef)) == 2) {
            String tempVar = RefactoringUtil.createTempVar(instanceRef, (PsiElement)call, true);
            instanceRef = factory.createExpressionFromText(tempVar, null);
        }
        PsiElement anchor = null;
        PsiExpressionList argList = call.getArgumentList();
        PsiExpression[] exprs = argList.getExpressions();
        if (this.mySettings.isMakeClassParameter()) {
            anchor = exprs.length > 0 ? argList.addBefore((PsiElement)instanceRef, (PsiElement)exprs[0]) : argList.add((PsiElement)instanceRef);
        }
        if (this.mySettings.isMakeFieldParameters()) {
            List<Settings.FieldParameter> parameters = this.mySettings.getParameterOrderList();
            for (Settings.FieldParameter fieldParameter : parameters) {
                PsiReferenceExpression fieldRef;
                String fieldName = fieldParameter.field.getName();
                if (newQualifier != null) {
                    fieldRef = (PsiReferenceExpression)factory.createExpressionFromText("a." + fieldName, null);
                    fieldRef.getQualifierExpression().replace((PsiElement)instanceRef);
                } else {
                    fieldRef = (PsiReferenceExpression)factory.createExpressionFromText(fieldName, null);
                }
                if (anchor != null) {
                    anchor = argList.addAfter((PsiElement)fieldRef, anchor);
                    continue;
                }
                if (exprs.length > 0) {
                    anchor = argList.addBefore((PsiElement)fieldRef, (PsiElement)exprs[0]);
                    continue;
                }
                anchor = argList.add((PsiElement)fieldRef);
            }
        }
        if (newQualifier != null) {
            if (call instanceof PsiMethodCallExpression) {
                instanceRef.replace((PsiElement)newQualifier);
            } else {
                PsiAnonymousClass anonymousClass = ((PsiNewExpression)call).getAnonymousClass();
                if (anonymousClass != null) {
                    ((PsiNewExpression)call).getQualifier().delete();
                    PsiJavaCodeReferenceElement baseClassReference = anonymousClass.getBaseClassReference();
                    baseClassReference.replace((PsiElement)((PsiNewExpression)factory.createExpressionFromText("new " + newQualifier.getText() + "." + baseClassReference.getText() + "()", (PsiElement)baseClassReference)).getClassReference());
                } else {
                    PsiJavaCodeReferenceElement classReference = ((PsiNewExpression)call).getClassReference();
                    LOG.assertTrue(classReference != null);
                    PsiNewExpression newExpr = (PsiNewExpression)factory.createExpressionFromText("new " + newQualifier.getText() + "." + classReference.getText() + "()", (PsiElement)classReference);
                    PsiExpressionList callArgs = call.getArgumentList();
                    if (callArgs != null) {
                        PsiExpressionList argumentList = newExpr.getArgumentList();
                        LOG.assertTrue(argumentList != null);
                        argumentList.replace((PsiElement)callArgs);
                    }
                    call.replace((PsiElement)newExpr);
                }
            }
        }
    }

    @Override
    protected MultiMap<PsiElement, String> getConflictDescriptions(UsageInfo[] usages) {
        String fieldName;
        PsiField existing;
        MultiMap<PsiElement, String> conflicts = super.getConflictDescriptions(usages);
        if (this.mySettings.isMakeClassParameter() && (existing = ((PsiClass)this.myMember).findFieldByName(fieldName = this.convertToFieldName(this.mySettings.getClassParameterName()), false)) != null) {
            String message = RefactoringBundle.message((String)"there.is.already.a.0.in.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)existing, false), RefactoringUIUtil.getDescription((PsiElement)this.myMember, false)});
            conflicts.putValue((Object)existing, (Object)message);
        }
        if (this.mySettings.isMakeFieldParameters()) {
            List<Settings.FieldParameter> parameterOrderList = this.mySettings.getParameterOrderList();
            for (Settings.FieldParameter parameter : parameterOrderList) {
                String fieldName2 = this.convertToFieldName(parameter.name);
                PsiField existing2 = ((PsiClass)this.myMember).findFieldByName(fieldName2, false);
                if (existing2 == null) continue;
                String message = RefactoringBundle.message((String)"there.is.already.a.0.in.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)existing2, false), RefactoringUIUtil.getDescription((PsiElement)this.myMember, false)});
                conflicts.putValue((Object)existing2, (Object)message);
            }
        }
        return conflicts;
    }

    @Override
    protected void findExternalUsages(ArrayList<UsageInfo> result) {
        PsiMethod[] constructors = ((PsiClass)this.myMember).getConstructors();
        if (constructors.length > 0) {
            for (PsiMethod constructor : constructors) {
                this.findExternalReferences(constructor, result);
            }
        } else {
            this.findDefaultConstructorReferences(result);
        }
    }

    private void findDefaultConstructorReferences(ArrayList<UsageInfo> result) {
        for (PsiReference ref : ReferencesSearch.search((PsiElement)this.myMember)) {
            PsiElement element = ref.getElement();
            if (!(element.getParent() instanceof PsiNewExpression)) continue;
            PsiNewExpression newExpression = (PsiNewExpression)element.getParent();
            PsiExpression qualifier = newExpression.getQualifier();
            if (qualifier instanceof PsiThisExpression) {
                qualifier = null;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)this.myMember, (PsiElement)element, (boolean)true) || qualifier != null) {
                result.add(new UsageInfo(element));
                continue;
            }
            result.add(new InternalUsageInfo(element, (PsiElement)this.myMember));
        }
    }
}

