/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeTooltip;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.impl.ShadowBorderPainter;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindow;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.impl.IdeGlassPaneEx;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentWithMnemonics;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.Alarm;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.AwtVisitor;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BalloonImpl
implements Balloon,
IdeTooltip.Ui {
    public static final int DIALOG_ARC = 6;
    public static final int ARC = 3;
    public static final int DIALOG_TOPBOTTOM_POINTER_WIDTH = 24;
    public static final int DIALOG_POINTER_WIDTH = 17;
    public static final int TOPBOTTOM_POINTER_WIDTH = 14;
    public static final int POINTER_WIDTH = 11;
    public static final int DIALOG_TOPBOTTOM_POINTER_LENGTH = 16;
    public static final int DIALOG_POINTER_LENGTH = 14;
    public static final int TOPBOTTOM_POINTER_LENGTH = 10;
    public static final int POINTER_LENGTH = 8;
    private final Alarm myFadeoutAlarm;
    private long myFadeoutRequestMillis;
    private int myFadeoutRequestDelay;
    private MyComponent myComp;
    private JLayeredPane myLayeredPane;
    private AbstractPosition myPosition;
    private Point myTargetPoint;
    private final boolean myHideOnFrameResize;
    private final boolean myHideOnLinkClick;
    private final Color myBorderColor;
    private final Insets myBorderInsets;
    private final Color myFillColor;
    private final Insets myContainerInsets;
    private boolean myLastMoveWasInsideBalloon;
    private Rectangle myForcedBounds;
    private CloseButton myCloseRec;
    private final AWTEventListener myAwtActivityListener;
    private final long myFadeoutTime;
    private Dimension myDefaultPrefSize;
    private final ActionListener myClickHandler;
    private final boolean myCloseOnClick;
    private int myShadowSize;
    private final CopyOnWriteArraySet<JBPopupListener> myListeners;
    private boolean myVisible;
    private PositionTracker<Balloon> myTracker;
    private int myAnimationCycle;
    private boolean myFadedIn;
    private boolean myFadedOut;
    private final int myCalloutShift;
    private final int myPositionChangeXShift;
    private final int myPositionChangeYShift;
    private boolean myDialogMode;
    private IdeFocusManager myFocusManager;
    private final String myTitle;
    private JLabel myTitleLabel;
    private boolean myAnimationEnabled;
    private boolean myShadow;
    private final Balloon.Layer myLayer;
    private final boolean myBlockClicks;
    private RelativePoint myPrevMousePoint;
    private final ComponentAdapter myComponentListener;
    private Animator myAnimator;
    private boolean myShowPointer;
    private boolean myDisposed;
    private final JComponent myContent;
    private boolean myHideOnMouse;
    private final boolean myHideOnKey;
    private final boolean myHideOnAction;
    private final boolean myEnableCloseButton;
    public static final AbstractPosition BELOW = new Below();
    public static final AbstractPosition ABOVE = new Above();
    public static final AbstractPosition AT_RIGHT = new AtRight();
    public static final AbstractPosition AT_LEFT = new AtLeft();

    private static boolean hasModalDialog(MouseEvent e) {
        Component c = e.getComponent();
        DialogWrapper dialog = DialogWrapper.findInstance((Component)c);
        return dialog != null && dialog.isModal();
    }

    public boolean isInsideBalloon(MouseEvent me) {
        return this.isInside(new RelativePoint(me));
    }

    @Override
    public boolean isInside(@NotNull RelativePoint target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/ui/BalloonImpl", "isInside"));
        }
        if (this.myComp == null) {
            return false;
        }
        Component cmp = target.getOriginalComponent();
        if (!cmp.isShowing()) {
            return true;
        }
        if (cmp == this.myCloseRec) {
            return true;
        }
        if (UIUtil.isDescendingFrom((Component)cmp, (Component)this.myComp)) {
            return true;
        }
        if (this.myComp == null || !this.myComp.isShowing()) {
            return false;
        }
        return this.myComp.contains(target.getScreenPoint().x, target.getScreenPoint().y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMovingForward(RelativePoint target) {
        try {
            if (this.myComp == null || !this.myComp.isShowing()) {
                boolean bl = false;
                return bl;
            }
            if (this.myPrevMousePoint == null) {
                boolean bl = true;
                return bl;
            }
            if (this.myPrevMousePoint.getComponent() != target.getComponent()) {
                boolean bl = false;
                return bl;
            }
            Rectangle rectangleOnScreen = new Rectangle(this.myComp.getLocationOnScreen(), this.myComp.getSize());
            boolean bl = ScreenUtil.isMovementTowards((Point)this.myPrevMousePoint.getScreenPoint(), (Point)target.getScreenPoint(), (Rectangle)rectangleOnScreen);
            return bl;
        }
        finally {
            this.myPrevMousePoint = target;
        }
    }

    /*
     * WARNING - void declaration
     */
    public BalloonImpl(@NotNull JComponent content, @NotNull Color borderColor, Insets borderInsets, @NotNull Color fillColor, boolean hideOnMouse, boolean hideOnKey, boolean hideOnAction, boolean showPointer, boolean enableCloseButton, long fadeoutTime, boolean hideOnFrameResize, boolean hideOnLinkClick, ActionListener clickHandler, boolean closeOnClick, int animationCycle, int calloutShift, int positionChangeXShift, int positionChangeYShift, boolean dialogMode, String title, Insets contentInsets, boolean shadow, boolean smallVariant, boolean blockClicks, Balloon.Layer layer) {
        void layer2;
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/BalloonImpl", "<init>"));
        }
        if (borderColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "borderColor", "com/intellij/ui/BalloonImpl", "<init>"));
        }
        if (fillColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fillColor", "com/intellij/ui/BalloonImpl", "<init>"));
        }
        this.myFadeoutAlarm = new Alarm((Disposable)this);
        this.myFadeoutRequestMillis = 0L;
        this.myFadeoutRequestDelay = 0;
        this.myAwtActivityListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent e) {
                KeyEvent ke;
                int id = e.getID();
                if (e instanceof MouseEvent) {
                    MouseEvent me = (MouseEvent)e;
                    boolean insideBalloon = BalloonImpl.this.isInsideBalloon(me);
                    if (BalloonImpl.this.myHideOnMouse && id == 501) {
                        if (!insideBalloon && !BalloonImpl.hasModalDialog(me)) {
                            BalloonImpl.this.hide();
                        }
                        return;
                    }
                    if (BalloonImpl.this.myClickHandler != null && id == 500 && !(me.getComponent() instanceof CloseButton) && insideBalloon) {
                        BalloonImpl.this.myClickHandler.actionPerformed(new ActionEvent(BalloonImpl.this, 1001, "click", me.getModifiersEx()));
                        if (BalloonImpl.this.myCloseOnClick) {
                            BalloonImpl.this.hide();
                            return;
                        }
                    }
                    if (BalloonImpl.this.myEnableCloseButton && id == 503) {
                        boolean moveChanged = insideBalloon != BalloonImpl.this.myLastMoveWasInsideBalloon;
                        BalloonImpl.this.myLastMoveWasInsideBalloon = insideBalloon;
                        if (moveChanged) {
                            if (insideBalloon && BalloonImpl.this.myFadeoutAlarm.getActiveRequestCount() > 0) {
                                BalloonImpl.this.myFadeoutAlarm.cancelAllRequests();
                                BalloonImpl.this.myFadeoutRequestDelay = (int)((long)BalloonImpl.this.myFadeoutRequestDelay - (System.currentTimeMillis() - BalloonImpl.this.myFadeoutRequestMillis));
                            }
                            if (!insideBalloon && BalloonImpl.this.myFadeoutRequestDelay > 0) {
                                BalloonImpl.this.startFadeoutTimer(BalloonImpl.this.myFadeoutRequestDelay);
                            }
                            BalloonImpl.this.myComp.repaintButton();
                        }
                    }
                    if (UIUtil.isCloseClick((MouseEvent)me)) {
                        if (BalloonImpl.this.isInsideBalloon(me)) {
                            BalloonImpl.this.hide();
                            me.consume();
                        }
                        return;
                    }
                }
                if (BalloonImpl.this.myHideOnKey && e instanceof KeyEvent && id == 401 && (ke = (KeyEvent)e).getKeyCode() != 16 && ke.getKeyCode() != 17 && ke.getKeyCode() != 18 && ke.getKeyCode() != 157) {
                    if (SwingUtilities.isDescendingFrom(ke.getComponent(), BalloonImpl.this.myComp) || ke.getComponent() == BalloonImpl.this.myComp) {
                        return;
                    }
                    BalloonImpl.this.hide();
                }
            }
        };
        this.myShadowSize = Registry.intValue((String)"ide.balloon.shadow.size");
        this.myListeners = new CopyOnWriteArraySet();
        this.myAnimationCycle = 500;
        this.myAnimationEnabled = true;
        this.myShadow = false;
        this.myPrevMousePoint = null;
        this.myComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (BalloonImpl.this.myHideOnFrameResize) {
                    BalloonImpl.this.hide();
                }
            }
        };
        this.myBorderColor = borderColor;
        this.myBorderInsets = borderInsets != null ? borderInsets : new Insets(3, 3, 3, 3);
        this.myFillColor = fillColor;
        this.myContent = content;
        this.myHideOnMouse = hideOnMouse;
        this.myHideOnKey = hideOnKey;
        this.myHideOnAction = hideOnAction;
        this.myShowPointer = showPointer;
        this.myEnableCloseButton = enableCloseButton;
        this.myHideOnFrameResize = hideOnFrameResize;
        this.myHideOnLinkClick = hideOnLinkClick;
        this.myClickHandler = clickHandler;
        this.myCloseOnClick = closeOnClick;
        this.myCalloutShift = calloutShift;
        this.myPositionChangeXShift = positionChangeXShift;
        this.myPositionChangeYShift = positionChangeYShift;
        this.myDialogMode = dialogMode;
        this.myTitle = title;
        this.myLayer = layer2 != null ? layer2 : Balloon.Layer.normal;
        this.myBlockClicks = blockClicks;
        if (!this.myDialogMode) {
            new AwtVisitor(content){

                public boolean visit(Component component) {
                    JCheckBox checkBox;
                    if (component instanceof JLabel) {
                        JLabel label = (JLabel)component;
                        if (label.getDisplayedMnemonic() != 0 || label.getDisplayedMnemonicIndex() >= 0) {
                            BalloonImpl.this.myDialogMode = true;
                            return true;
                        }
                    } else if (component instanceof JCheckBox && ((checkBox = (JCheckBox)component).getMnemonic() >= 0 || checkBox.getDisplayedMnemonicIndex() >= 0)) {
                        BalloonImpl.this.myDialogMode = true;
                        return true;
                    }
                    return false;
                }
            };
        }
        this.myShadow = shadow;
        this.myShadowSize = Registry.intValue((String)"ide.balloon.shadow.size");
        this.myContainerInsets = contentInsets;
        this.myFadeoutTime = fadeoutTime;
        this.myAnimationCycle = animationCycle;
        if (smallVariant) {
            new AwtVisitor(this.myContent){

                public boolean visit(Component component) {
                    UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)component);
                    return false;
                }
            };
        }
    }

    public void show(RelativePoint target, Balloon.Position position) {
        AbstractPosition pos = BalloonImpl.getAbstractPositionFor(position);
        this.show(target, pos);
    }

    public int getLayer() {
        Integer result = JLayeredPane.DEFAULT_LAYER;
        switch (this.myLayer) {
            case normal: {
                result = JLayeredPane.POPUP_LAYER;
                break;
            }
            case top: {
                result = JLayeredPane.DRAG_LAYER;
            }
        }
        return result;
    }

    private static AbstractPosition getAbstractPositionFor(Balloon.Position position) {
        AbstractPosition pos = BELOW;
        switch (position) {
            case atLeft: {
                pos = AT_LEFT;
                break;
            }
            case atRight: {
                pos = AT_RIGHT;
                break;
            }
            case below: {
                pos = BELOW;
                break;
            }
            case above: {
                pos = ABOVE;
            }
        }
        return pos;
    }

    public void show(PositionTracker<Balloon> tracker, Balloon.Position position) {
        AbstractPosition pos = BELOW;
        switch (position) {
            case atLeft: {
                pos = AT_LEFT;
                break;
            }
            case atRight: {
                pos = AT_RIGHT;
                break;
            }
            case below: {
                pos = BELOW;
                break;
            }
            case above: {
                pos = ABOVE;
            }
        }
        this.show(tracker, pos);
    }

    private Insets getInsetsCopy() {
        return new Insets(this.myBorderInsets.top, this.myBorderInsets.left, this.myBorderInsets.bottom, this.myBorderInsets.right);
    }

    private void show(RelativePoint target, AbstractPosition position) {
        this.show((PositionTracker<Balloon>)new PositionTracker.Static(target), position);
    }

    private void show(PositionTracker<Balloon> tracker, AbstractPosition position) {
        Rectangle rec;
        boolean mnemonicsFix;
        assert (!this.myDisposed) : "Balloon is already disposed";
        if (this.isVisible()) {
            return;
        }
        Component comp = tracker.getComponent();
        if (!comp.isShowing()) {
            return;
        }
        this.myTracker = tracker;
        this.myTracker.init((PositionTracker.Client)this);
        JRootPane root = null;
        JDialog dialog = IJSwingUtilities.findParentOfType(comp, JDialog.class);
        if (dialog != null) {
            root = dialog.getRootPane();
        } else {
            JWindow jwindow = IJSwingUtilities.findParentOfType(comp, JWindow.class);
            if (jwindow != null) {
                root = jwindow.getRootPane();
            } else {
                JFrame frame = IJSwingUtilities.findParentOfType(comp, JFrame.class);
                if (frame != null) {
                    root = frame.getRootPane();
                } else assert (false);
            }
        }
        this.myVisible = true;
        this.myLayeredPane = root.getLayeredPane();
        this.myPosition = position;
        UIUtil.setFutureRootPane((JComponent)this.myContent, (JRootPane)root);
        this.myFocusManager = IdeFocusManager.findInstanceByComponent((Component)this.myLayeredPane);
        final Ref originalFocusOwner = new Ref();
        final Ref focusRequestor = new Ref();
        final Ref proxyFocusRequest = new Ref((Object)new ActionCallback.Done());
        boolean bl = mnemonicsFix = this.myDialogMode && SystemInfo.isMac && Registry.is((String)"ide.mac.inplaceDialogMnemonicsFix");
        if (mnemonicsFix) {
            final IdeGlassPaneEx glassPane = (IdeGlassPaneEx)IdeGlassPaneUtil.find((Component)this.myLayeredPane);
            assert (glassPane != null);
            proxyFocusRequest.set((Object)new ActionCallback());
            this.myFocusManager.doWhenFocusSettlesDown(new ExpirableRunnable(){

                public boolean isExpired() {
                    return BalloonImpl.this.isDisposed();
                }

                public void run() {
                    IdeEventQueue.getInstance().disableInputMethods((Disposable)BalloonImpl.this);
                    originalFocusOwner.set((Object)BalloonImpl.this.myFocusManager.getFocusOwner());
                    BalloonImpl.this.myFocusManager.requestFocus((Component)glassPane.getProxyComponent(), true).notify((ActionCallback)proxyFocusRequest.get());
                    focusRequestor.set((Object)BalloonImpl.this.myFocusManager.getFurtherRequestor());
                }
            });
        }
        this.myLayeredPane.addComponentListener(this.myComponentListener);
        this.myTargetPoint = this.myPosition.getShiftedPoint(this.myTracker.recalculateLocation((Object)this).getPoint((Component)this.myLayeredPane), this.myCalloutShift);
        int positionChangeFix = 0;
        if (this.myShowPointer && !this.myPosition.isOkToHavePointer(this.myTargetPoint, rec = this.getRecForPosition(this.myPosition, true), this.getPointerLength(this.myPosition), this.getPointerWidth(this.myPosition), this.getArc())) {
            rec = this.getRecForPosition(this.myPosition, false);
            Rectangle lp = new Rectangle(new Point(this.myContainerInsets.left, this.myContainerInsets.top), this.myLayeredPane.getSize());
            lp.width -= this.myContainerInsets.right;
            lp.height -= this.myContainerInsets.bottom;
            if (!lp.contains(rec)) {
                Rectangle2D currentSquare = lp.createIntersection(rec);
                double maxSquare = currentSquare.getWidth() * currentSquare.getHeight();
                AbstractPosition targetPosition = this.myPosition;
                for (AbstractPosition eachPosition : this.myPosition.getOtherPositions()) {
                    Rectangle2D eachIntersection = lp.createIntersection(this.getRecForPosition(eachPosition, false));
                    double eachSquare = eachIntersection.getWidth() * eachIntersection.getHeight();
                    if (!(maxSquare < eachSquare)) continue;
                    maxSquare = eachSquare;
                    targetPosition = eachPosition;
                }
                this.myPosition = targetPosition;
                positionChangeFix = this.myPosition.getChangeShift(position, this.myPositionChangeXShift, this.myPositionChangeYShift);
            }
        }
        if (this.myPosition != position) {
            this.myTargetPoint = this.myPosition.getShiftedPoint(this.myTracker.recalculateLocation((Object)this).getPoint((Component)this.myLayeredPane), this.myCalloutShift > 0 ? this.myCalloutShift + positionChangeFix : positionChangeFix);
        }
        this.createComponent();
        this.myComp.validate();
        rec = this.myComp.getContentBounds();
        if (this.myShowPointer && !this.myPosition.isOkToHavePointer(this.myTargetPoint, rec, this.getPointerLength(this.myPosition), this.getPointerWidth(this.myPosition), this.getArc())) {
            this.myShowPointer = false;
            this.myComp.removeAll();
            this.myLayeredPane.remove(this.myComp);
            this.createComponent();
            if (!new Rectangle(this.myLayeredPane.getSize()).contains(new Rectangle(this.myComp.getSize()))) {
                this.myComp.removeAll();
                this.myLayeredPane.remove(this.myComp);
                this.myLayeredPane = null;
                this.hide();
                return;
            }
        }
        for (JBPopupListener each : this.myListeners) {
            each.beforeShown(new LightweightWindowEvent((LightweightWindow)this));
        }
        this.runAnimation(true, this.myLayeredPane, null);
        this.myLayeredPane.revalidate();
        this.myLayeredPane.repaint();
        if (mnemonicsFix) {
            ((ActionCallback)proxyFocusRequest.get()).doWhenDone(new Runnable(){

                @Override
                public void run() {
                    BalloonImpl.this.myFocusManager.requestFocus((Component)originalFocusOwner.get(), true);
                }
            });
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this.myAwtActivityListener, 56L);
        if (ApplicationManager.getApplication() != null) {
            ActionManager.getInstance().addAnActionListener((AnActionListener)new AnActionListener.Adapter(){

                public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                    if (BalloonImpl.this.myHideOnAction) {
                        BalloonImpl.this.hide();
                    }
                }
            }, (Disposable)this);
        }
        if (this.myHideOnLinkClick) {
            final Ref ref = Ref.create(null);
            new AwtVisitor(this.myContent){

                public boolean visit(Component component) {
                    if (component instanceof JEditorPane) {
                        ref.set((Object)((JEditorPane)component));
                        return true;
                    }
                    return false;
                }
            };
            if (!ref.isNull()) {
                ((JEditorPane)ref.get()).addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                    protected void hyperlinkActivated(HyperlinkEvent e) {
                        BalloonImpl.this.hide();
                    }
                });
            }
        }
    }

    private Rectangle getRecForPosition(AbstractPosition position, boolean adjust) {
        Dimension size = this.getContentSizeFor(position);
        Rectangle rec = new Rectangle(new Point(0, 0), size);
        position.setRecToRelativePosition(rec, this.myTargetPoint);
        if (adjust) {
            rec = this.myPosition.getUpdatedBounds(this.myLayeredPane.getSize(), this.myForcedBounds, rec.getSize(), this.myShowPointer, this.myTargetPoint, this.myContainerInsets);
        }
        return rec;
    }

    private Dimension getContentSizeFor(AbstractPosition position) {
        Insets insets = position.createBorder(this).getBorderInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        Dimension size = this.myContent.getPreferredSize();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    private void disposeCloseButton(CloseButton closeButton) {
        if (closeButton != null && closeButton.getParent() != null) {
            Container parent = closeButton.getParent();
            parent.remove((Component)((Object)closeButton));
            ((JComponent)parent).revalidate();
            parent.repaint();
        }
    }

    private void createComponent() {
        this.myComp = new MyComponent(this.myContent, this, this.myShowPointer ? this.myPosition.createBorder(this) : this.getPointlessBorder());
        this.myCloseRec = new CloseButton();
        this.myComp.clear();
        this.myComp.myAlpha = this.myAnimationEnabled ? 0.0f : -1.0f;
        int borderSize = this.getShadowBorderSize();
        this.myComp.setBorder(new EmptyBorder(borderSize, borderSize, borderSize, borderSize));
        this.myLayeredPane.add(this.myComp);
        this.myLayeredPane.setLayer(this.myComp, this.getLayer(), 0);
        this.myPosition.updateBounds(this);
        if (this.myBlockClicks) {
            this.myComp.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    e.consume();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    e.consume();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    e.consume();
                }
            });
        }
    }

    @NotNull
    private EmptyBorder getPointlessBorder() {
        EmptyBorder emptyBorder = new EmptyBorder(this.myBorderInsets);
        if (emptyBorder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/BalloonImpl", "getPointlessBorder"));
        }
        return emptyBorder;
    }

    public void revalidate() {
        this.revalidate(this.myTracker);
    }

    public void revalidate(@NotNull PositionTracker<Balloon> tracker) {
        if (tracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/ui/BalloonImpl", "revalidate"));
        }
        RelativePoint newPosition = tracker.recalculateLocation((Object)this);
        if (newPosition != null) {
            this.myTargetPoint = this.myPosition.getShiftedPoint(newPosition.getPoint((Component)this.myLayeredPane), this.myCalloutShift);
            this.myPosition.updateBounds(this);
        }
    }

    public int getShadowBorderSize() {
        return this.hasShadow() ? this.myShadowSize : 0;
    }

    public boolean hasShadow() {
        return this.myShadow && Registry.is((String)"ide.balloon.shadowEnabled");
    }

    public void show(JLayeredPane pane) {
        this.show(pane, null);
    }

    public void showInCenterOf(JComponent component) {
        Dimension size = component.getSize();
        this.show(new RelativePoint((Component)component, new Point(size.width / 2, size.height / 2)), Balloon.Position.above);
    }

    public void show(JLayeredPane pane, @Nullable Rectangle bounds) {
        if (bounds != null) {
            this.myForcedBounds = bounds;
        }
        this.show(new RelativePoint((Component)pane, new Point(0, 0)), Balloon.Position.above);
    }

    private void runAnimation(boolean forward, final JLayeredPane layeredPane, final @Nullable Runnable onDone) {
        if (this.myAnimator != null) {
            Disposer.dispose((Disposable)this.myAnimator);
        }
        this.myAnimator = new Animator("Balloon", 8, this.myAnimationEnabled ? this.myAnimationCycle : 0, false, forward){

            public void paintNow(int frame, int totalFrames, int cycle) {
                if (BalloonImpl.this.myComp == null || BalloonImpl.this.myComp.getParent() == null || !BalloonImpl.this.myAnimationEnabled) {
                    return;
                }
                BalloonImpl.this.myComp.setAlpha((float)frame / (float)totalFrames);
            }

            protected void paintCycleEnd() {
                if (BalloonImpl.this.myComp == null || BalloonImpl.this.myComp.getParent() == null) {
                    return;
                }
                if (this.isForward()) {
                    BalloonImpl.this.myComp.clear();
                    BalloonImpl.this.myComp.repaint();
                    BalloonImpl.this.myFadedIn = true;
                    BalloonImpl.this.startFadeoutTimer((int)BalloonImpl.this.myFadeoutTime);
                } else {
                    layeredPane.remove(BalloonImpl.this.myComp);
                    layeredPane.revalidate();
                    layeredPane.repaint();
                }
                Disposer.dispose((Disposable)this);
            }

            public void dispose() {
                super.dispose();
                BalloonImpl.this.myAnimator = null;
                if (onDone != null) {
                    onDone.run();
                }
            }
        };
        this.myAnimator.resume();
    }

    public void startFadeoutTimer(int fadeoutDelay) {
        if (fadeoutDelay > 0) {
            this.myFadeoutAlarm.cancelAllRequests();
            this.myFadeoutRequestMillis = System.currentTimeMillis();
            this.myFadeoutRequestDelay = fadeoutDelay;
            this.myFadeoutAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    BalloonImpl.this.hide();
                }
            }, fadeoutDelay, null);
        }
    }

    int getArc() {
        return this.myDialogMode ? 6 : 3;
    }

    int getPointerWidth(AbstractPosition position) {
        if (this.myDialogMode) {
            return position.isTopBottomPointer() ? 24 : 17;
        }
        return position.isTopBottomPointer() ? 14 : 11;
    }

    public static int getNormalInset() {
        return 3;
    }

    int getPointerLength(AbstractPosition position) {
        return BalloonImpl.getPointerLength(position, this.myDialogMode);
    }

    static int getPointerLength(AbstractPosition position, boolean dialogMode) {
        if (dialogMode) {
            return position.isTopBottomPointer() ? 16 : 14;
        }
        return position.isTopBottomPointer() ? 10 : 8;
    }

    public static int getPointerLength(Balloon.Position position, boolean dialogMode) {
        return BalloonImpl.getPointerLength(BalloonImpl.getAbstractPositionFor(position), dialogMode);
    }

    public void hide() {
        this.hide(false);
    }

    public void hide(boolean ok) {
        this.hideAndDispose(ok);
    }

    public void dispose() {
        this.hideAndDispose(false);
    }

    private void hideAndDispose(final boolean ok) {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        this.hideComboBoxPopups();
        final Runnable disposeRunnable = new Runnable(){

            @Override
            public void run() {
                BalloonImpl.this.myFadedOut = true;
                for (JBPopupListener each : BalloonImpl.this.myListeners) {
                    each.onClosed(new LightweightWindowEvent((LightweightWindow)BalloonImpl.this, ok));
                }
                Disposer.dispose((Disposable)BalloonImpl.this);
                BalloonImpl.this.onDisposed();
            }
        };
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.myAwtActivityListener);
        if (this.myLayeredPane != null) {
            this.myLayeredPane.removeComponentListener(this.myComponentListener);
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this);
            this.runAnimation(false, this.myLayeredPane, new Runnable(){

                @Override
                public void run() {
                    disposeRunnable.run();
                }
            });
        } else {
            disposeRunnable.run();
        }
        this.myVisible = false;
        this.myTracker = null;
    }

    private void hideComboBoxPopups() {
        List comboBoxes = UIUtil.findComponentsOfType((JComponent)this.myComp, JComboBox.class);
        for (JComboBox box : comboBoxes) {
            box.hidePopup();
        }
    }

    protected void onDisposed() {
    }

    public void addListener(@NotNull JBPopupListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/BalloonImpl", "addListener"));
        }
        this.myListeners.add(listener);
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void setHideOnClickOutside(boolean hideOnMouse) {
        this.myHideOnMouse = hideOnMouse;
    }

    public void setShowPointer(boolean show) {
        this.myShowPointer = show;
    }

    public Icon getCloseButton() {
        return AllIcons.General.BalloonClose;
    }

    public void setBounds(Rectangle bounds) {
        this.myForcedBounds = bounds;
        if (this.myPosition != null) {
            this.myPosition.updateBounds(this);
        }
    }

    public void setShadowSize(int shadowSize) {
        this.myShadowSize = shadowSize;
    }

    public Dimension getPreferredSize() {
        if (this.myComp != null) {
            return this.myComp.getPreferredSize();
        }
        if (this.myDefaultPrefSize == null) {
            EmptyBorder border = this.getPointlessBorder();
            MyComponent c = new MyComponent(this.myContent, this, border);
            this.myDefaultPrefSize = c.getPreferredSize();
        }
        return this.myDefaultPrefSize;
    }

    public boolean wasFadedIn() {
        return this.myFadedIn;
    }

    public boolean wasFadedOut() {
        return this.myFadedOut;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void setTitle(String title) {
        this.myTitleLabel.setText(title);
    }

    @Override
    public RelativePoint getShowingPoint() {
        Point p = this.myPosition.getShiftedPoint(this.myTargetPoint, this.myCalloutShift * -1);
        return new RelativePoint((Component)this.myLayeredPane, p);
    }

    public void setAnimationEnabled(boolean enabled) {
        this.myAnimationEnabled = enabled;
    }

    public boolean isAnimationEnabled() {
        return this.myAnimationEnabled;
    }

    public boolean isBlockClicks() {
        return this.myBlockClicks;
    }

    private static class Shaper {
        private final GeneralPath myPath = new GeneralPath();
        Rectangle myBounds;
        @JdkConstants.TabPlacement
        private final int myTargetSide;
        private final BalloonImpl myBalloon;

        public Shaper(BalloonImpl balloon, Rectangle bounds, Point targetPoint, @JdkConstants.TabPlacement int targetSide) {
            this.myBalloon = balloon;
            this.myBounds = bounds;
            this.myTargetSide = targetSide;
            this.start(targetPoint);
        }

        private void start(Point start) {
            this.myPath.moveTo(start.x, start.y);
        }

        public Shaper roundUpRight() {
            this.myPath.quadTo(this.getCurrent().x, this.getCurrent().y - this.myBalloon.getArc(), this.getCurrent().x + this.myBalloon.getArc(), this.getCurrent().y - this.myBalloon.getArc());
            return this;
        }

        public Shaper roundRightDown() {
            this.myPath.quadTo(this.getCurrent().x + this.myBalloon.getArc(), this.getCurrent().y, this.getCurrent().x + this.myBalloon.getArc(), this.getCurrent().y + this.myBalloon.getArc());
            return this;
        }

        public Shaper roundLeftUp() {
            this.myPath.quadTo(this.getCurrent().x - this.myBalloon.getArc(), this.getCurrent().y, this.getCurrent().x - this.myBalloon.getArc(), this.getCurrent().y - this.myBalloon.getArc());
            return this;
        }

        public Shaper roundLeftDown() {
            this.myPath.quadTo(this.getCurrent().x, this.getCurrent().y + this.myBalloon.getArc(), this.getCurrent().x - this.myBalloon.getArc(), this.getCurrent().y + this.myBalloon.getArc());
            return this;
        }

        public Point getCurrent() {
            return new Point((int)this.myPath.getCurrentPoint().getX(), (int)this.myPath.getCurrentPoint().getY());
        }

        public Shaper line(int deltaX, int deltaY) {
            this.myPath.lineTo(this.getCurrent().x + deltaX, this.getCurrent().y + deltaY);
            return this;
        }

        public Shaper lineTo(int x, int y) {
            this.myPath.lineTo(x, y);
            return this;
        }

        private int getTargetDelta(@JdkConstants.TabPlacement int effectiveSide) {
            return effectiveSide == this.myTargetSide ? this.myBalloon.getPointerLength(this.myBalloon.myPosition) : 0;
        }

        public Shaper toRightCurve() {
            this.myPath.lineTo((int)this.myBounds.getMaxX() - this.myBalloon.getArc() - this.getTargetDelta(4) - 1, this.getCurrent().y);
            return this;
        }

        public Shaper toBottomCurve() {
            this.myPath.lineTo(this.getCurrent().x, (int)this.myBounds.getMaxY() - this.myBalloon.getArc() - this.getTargetDelta(3) - 1);
            return this;
        }

        public Shaper toLeftCurve() {
            this.myPath.lineTo((int)this.myBounds.getX() + this.myBalloon.getArc() + this.getTargetDelta(2), this.getCurrent().y);
            return this;
        }

        public Shaper toTopCurve() {
            this.myPath.lineTo(this.getCurrent().x, (int)this.myBounds.getY() + this.myBalloon.getArc() + this.getTargetDelta(1));
            return this;
        }

        public void close() {
            this.myPath.closePath();
        }

        public Shape getShape() {
            return this.myPath;
        }
    }

    private class MyComponent
    extends JPanel
    implements ComponentWithMnemonics {
        private BufferedImage myImage;
        private float myAlpha;
        private final BalloonImpl myBalloon;
        private final JComponent myContent;
        private ShadowBorderPainter.Shadow myShadow;

        private MyComponent(JComponent content, BalloonImpl balloon, EmptyBorder shapeBorder) {
            this.setOpaque(false);
            this.setLayout(null);
            this.myBalloon = balloon;
            this.setFocusCycleRoot(true);
            this.putClientProperty("Balloon.property", BalloonImpl.this);
            this.myContent = new JPanel(new BorderLayout(2, 2));
            Wrapper contentWrapper = new Wrapper(content);
            if (BalloonImpl.this.myTitle != null) {
                BalloonImpl.this.myTitleLabel = new JLabel(BalloonImpl.this.myTitle, 0);
                BalloonImpl.this.myTitleLabel.setForeground(UIManager.getColor("List.background"));
                BalloonImpl.this.myTitleLabel.setBorder(new EmptyBorder(0, 4, 0, 4));
                this.myContent.add((Component)BalloonImpl.this.myTitleLabel, "North");
                contentWrapper.setBorder((Border)new EmptyBorder(1, 1, 1, 1));
            }
            this.myContent.add((Component)contentWrapper, "Center");
            this.myContent.setBorder(shapeBorder);
            this.myContent.setOpaque(false);
            this.add(this.myContent);
        }

        public Rectangle getContentBounds() {
            Rectangle bounds = super.getBounds();
            int shadow = this.myBalloon.getShadowBorderSize();
            bounds.x += shadow;
            bounds.width -= shadow * 2;
            bounds.y += shadow;
            bounds.height -= shadow * 2;
            return bounds;
        }

        public void clear() {
            this.myImage = null;
            this.myAlpha = -1.0f;
        }

        @Override
        public void doLayout() {
            Insets insets = this.getInsets();
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            this.myContent.setBounds(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.addInsets(this.myContent.getPreferredSize());
        }

        @Override
        public Dimension getMinimumSize() {
            return this.addInsets(this.myContent.getMinimumSize());
        }

        private Dimension addInsets(Dimension size) {
            Insets insets = this.getInsets();
            if (insets != null) {
                size.width += insets.left + insets.right;
                size.height += insets.top + insets.bottom;
            }
            return size;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            Point pointTarget = SwingUtilities.convertPoint(BalloonImpl.this.myLayeredPane, this.myBalloon.myTargetPoint, this);
            Rectangle shapeBounds = this.myContent.getBounds();
            int shadowSize = this.myBalloon.getShadowBorderSize();
            if (shadowSize > 0 && this.myShadow == null) {
                this.initComponentImage(pointTarget, shapeBounds);
                this.myShadow = ShadowBorderPainter.createShadow(this.myImage, 0, 0, false, shadowSize / 2);
            }
            if (this.myImage == null && this.myAlpha != -1.0f) {
                this.initComponentImage(pointTarget, shapeBounds);
            }
            if (this.myImage != null && this.myAlpha != -1.0f) {
                g2d.setComposite(AlphaComposite.getInstance(3, this.myAlpha));
                UIUtil.drawImage((Graphics)g2d, (Image)this.myImage, (int)0, (int)0, null);
            } else {
                if (this.myShadow != null) {
                    UIUtil.drawImage((Graphics)g, (Image)this.myShadow.getImage(), (int)this.myShadow.getX(), (int)this.myShadow.getY(), null);
                }
                this.myBalloon.myPosition.paintComponent(this.myBalloon, shapeBounds, (Graphics2D)g, pointTarget);
            }
        }

        @Override
        public boolean contains(int x, int y) {
            Point pointTarget = SwingUtilities.convertPoint(BalloonImpl.this.myLayeredPane, this.myBalloon.myTargetPoint, this);
            Rectangle bounds = this.myContent.getBounds();
            Shape shape = BalloonImpl.this.myShowPointer ? this.myBalloon.myPosition.getPointingShape(bounds, pointTarget, this.myBalloon) : new RoundRectangle2D.Double(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, this.myBalloon.getArc(), this.myBalloon.getArc());
            return shape.contains(x, y);
        }

        private void initComponentImage(Point pointTarget, Rectangle shapeBounds) {
            if (this.myImage != null) {
                return;
            }
            this.myImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            this.myBalloon.myPosition.paintComponent(this.myBalloon, shapeBounds, (Graphics2D)this.myImage.getGraphics(), pointTarget);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            if (!ScreenUtil.isStandardAddRemoveNotify((Component)this)) {
                return;
            }
            final CloseButton closeButton = BalloonImpl.this.myCloseRec;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BalloonImpl.this.disposeCloseButton(closeButton);
                }
            });
        }

        public void setAlpha(float alpha) {
            this.myAlpha = alpha;
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        }

        public void _setBounds(Rectangle bounds) {
            Rectangle currentBounds = this.getBounds();
            if (currentBounds.width != bounds.width || currentBounds.height != bounds.height) {
                this.invalidateShadowImage();
            }
            super.setBounds(bounds);
            if (BalloonImpl.this.myCloseRec.getParent() == null && this.getParent() != null) {
                BalloonImpl.this.myLayeredPane.add((Component)((Object)BalloonImpl.this.myCloseRec));
                BalloonImpl.this.myLayeredPane.setLayer((Component)((Object)BalloonImpl.this.myCloseRec), JLayeredPane.DRAG_LAYER);
            }
            if (this.isVisible() && BalloonImpl.this.myCloseRec.isVisible()) {
                Rectangle lpBounds = SwingUtilities.convertRectangle(this.getParent(), bounds, BalloonImpl.this.myLayeredPane);
                lpBounds = BalloonImpl.this.myPosition.getPointlessContentRec(lpBounds, this.myBalloon.getPointerLength(BalloonImpl.this.myPosition));
                int iconWidth = AllIcons.General.BalloonClose.getIconWidth();
                int iconHeight = AllIcons.General.BalloonClose.getIconHeight();
                Rectangle r = new Rectangle(lpBounds.x + lpBounds.width - iconWidth + (int)((double)iconWidth * 0.3), lpBounds.y - (int)((double)iconHeight * 0.3), iconWidth, iconHeight);
                r.y -= BalloonImpl.this.getShadowBorderSize();
                r.x -= BalloonImpl.this.getShadowBorderSize();
                BalloonImpl.this.myCloseRec.setBounds(r);
            }
            if (this.isVisible()) {
                this.revalidate();
                this.repaint();
            }
        }

        private void invalidateShadowImage() {
            this.myImage = null;
            this.myShadow = null;
        }

        public void repaintButton() {
            BalloonImpl.this.myCloseRec.repaint();
        }
    }

    private class CloseButton
    extends NonOpaquePanel {
        private final BaseButtonBehavior myButton;

        private CloseButton() {
            this.myButton = new BaseButtonBehavior((JComponent)((Object)this), TimedDeadzone.NULL){

                protected void execute(MouseEvent e) {
                    if (!BalloonImpl.this.myEnableCloseButton) {
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BalloonImpl.this.hide();
                        }
                    });
                }
            };
            if (!BalloonImpl.this.myEnableCloseButton) {
                this.setVisible(false);
            }
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!BalloonImpl.this.myEnableCloseButton) {
                return;
            }
            if (this.getWidth() > 0 && BalloonImpl.this.myLastMoveWasInsideBalloon) {
                boolean pressed = this.myButton.isPressedByMouse();
                BalloonImpl.this.getCloseButton().paintIcon((Component)((Object)this), g, pressed ? 1 : 0, pressed ? 1 : 0);
            }
        }
    }

    private static class AtLeft
    extends AbstractPosition {
        private AtLeft() {
        }

        @Override
        public Point getShiftedPoint(Point targetPoint, int shift) {
            return new Point(targetPoint.x - shift, targetPoint.y);
        }

        @Override
        int getChangeShift(AbstractPosition original, int xShift, int yShift) {
            return original == AT_RIGHT ? -xShift : 0;
        }

        @Override
        protected int getDistanceToTarget(Rectangle rectangle, Point targetPoint) {
            return targetPoint.x - (int)rectangle.getMaxX();
        }

        @Override
        protected Rectangle getPointlessContentRec(Rectangle bounds, int pointerLength) {
            return new Rectangle(bounds.x, bounds.y, bounds.width - pointerLength, bounds.height);
        }

        @Override
        EmptyBorder createBorder(BalloonImpl balloon) {
            Insets insets = balloon.getInsetsCopy();
            insets.right += balloon.getPointerLength(this);
            return new EmptyBorder(insets);
        }

        @Override
        void setRecToRelativePosition(Rectangle rec, Point targetPoint) {
            rec.setLocation(targetPoint.x - rec.width, targetPoint.y - rec.height / 2);
        }

        @Override
        Point getLocation(Dimension containerSize, Point targetPoint, Dimension balloonSize) {
            Point center = UIUtil.getCenterPoint((Rectangle)new Rectangle(targetPoint, (Dimension)JBUI.emptySize()), (Dimension)balloonSize);
            return new Point(targetPoint.x - balloonSize.width, center.y);
        }

        @Override
        protected Insets getTitleInsets(int normalInset, int pointerLength) {
            return new Insets(normalInset, pointerLength, normalInset, normalInset);
        }

        @Override
        protected Shape getPointingShape(Rectangle bounds, Point pointTarget, BalloonImpl balloon) {
            Shaper shaper = new Shaper(balloon, bounds, pointTarget, 4);
            shaper.lineTo((int)bounds.getMaxX() - shaper.getTargetDelta(4) - 1, pointTarget.y + balloon.getPointerWidth(this) / 2);
            shaper.toBottomCurve().roundLeftDown().toLeftCurve().roundLeftUp().toTopCurve().roundUpRight().toRightCurve().roundRightDown().lineTo(shaper.getCurrent().x, pointTarget.y - balloon.getPointerWidth(this) / 2).lineTo(pointTarget.x, pointTarget.y).close();
            return shaper.getShape();
        }
    }

    private static class AtRight
    extends AbstractPosition {
        private AtRight() {
        }

        @Override
        public Point getShiftedPoint(Point targetPoint, int shift) {
            return new Point(targetPoint.x + shift, targetPoint.y);
        }

        @Override
        int getChangeShift(AbstractPosition original, int xShift, int yShift) {
            return original == AT_LEFT ? xShift : 0;
        }

        @Override
        protected int getDistanceToTarget(Rectangle rectangle, Point targetPoint) {
            return rectangle.x - targetPoint.x;
        }

        @Override
        protected Rectangle getPointlessContentRec(Rectangle bounds, int pointerLength) {
            return new Rectangle(bounds.x + pointerLength, bounds.y, bounds.width - pointerLength, bounds.height);
        }

        @Override
        EmptyBorder createBorder(BalloonImpl balloon) {
            Insets insets = balloon.getInsetsCopy();
            insets.left += balloon.getPointerLength(this);
            return new EmptyBorder(insets);
        }

        @Override
        void setRecToRelativePosition(Rectangle rec, Point targetPoint) {
            rec.setLocation(targetPoint.x, targetPoint.y - rec.height / 2);
        }

        @Override
        Point getLocation(Dimension containerSize, Point targetPoint, Dimension balloonSize) {
            Point center = UIUtil.getCenterPoint((Rectangle)new Rectangle(targetPoint, (Dimension)JBUI.emptySize()), (Dimension)balloonSize);
            return new Point(targetPoint.x, center.y);
        }

        @Override
        protected Insets getTitleInsets(int normalInset, int pointerLength) {
            return new Insets(normalInset, pointerLength, normalInset, normalInset);
        }

        @Override
        protected Shape getPointingShape(Rectangle bounds, Point pointTarget, BalloonImpl balloon) {
            Shaper shaper = new Shaper(balloon, bounds, pointTarget, 2);
            shaper.line(balloon.getPointerLength(this), -balloon.getPointerWidth(this) / 2).toTopCurve().roundUpRight().toRightCurve().roundRightDown().toBottomCurve().roundLeftDown().toLeftCurve().roundLeftUp().lineTo(shaper.getCurrent().x, pointTarget.y + balloon.getPointerWidth(this) / 2).lineTo(pointTarget.x, pointTarget.y).close();
            return shaper.getShape();
        }
    }

    private static class Above
    extends AbstractPosition {
        private Above() {
        }

        @Override
        public Point getShiftedPoint(Point targetPoint, int shift) {
            return new Point(targetPoint.x, targetPoint.y - shift);
        }

        @Override
        int getChangeShift(AbstractPosition original, int xShift, int yShift) {
            return original == BELOW ? -yShift : 0;
        }

        @Override
        protected int getDistanceToTarget(Rectangle rectangle, Point targetPoint) {
            return targetPoint.y - (int)rectangle.getMaxY();
        }

        @Override
        protected Rectangle getPointlessContentRec(Rectangle bounds, int pointerLength) {
            return new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height - pointerLength);
        }

        @Override
        EmptyBorder createBorder(BalloonImpl balloon) {
            Insets insets = balloon.getInsetsCopy();
            insets.bottom = balloon.getPointerLength(this);
            return new EmptyBorder(insets);
        }

        @Override
        void setRecToRelativePosition(Rectangle rec, Point targetPoint) {
            rec.setLocation(targetPoint.x - rec.width / 2, targetPoint.y - rec.height);
        }

        @Override
        Point getLocation(Dimension containerSize, Point targetPoint, Dimension balloonSize) {
            Point center = UIUtil.getCenterPoint((Rectangle)new Rectangle(targetPoint, (Dimension)JBUI.emptySize()), (Dimension)balloonSize);
            return new Point(center.x, targetPoint.y - balloonSize.height);
        }

        @Override
        protected Insets getTitleInsets(int normalInset, int pointerLength) {
            return new Insets(normalInset, normalInset, normalInset, normalInset);
        }

        @Override
        protected Shape getPointingShape(Rectangle bounds, Point pointTarget, BalloonImpl balloon) {
            Shaper shaper = new Shaper(balloon, bounds, pointTarget, 3);
            shaper.line(-balloon.getPointerWidth(this) / 2, -balloon.getPointerLength(this) + 1);
            shaper.toLeftCurve().roundLeftUp().toTopCurve().roundUpRight().toRightCurve().roundRightDown().toBottomCurve().line(0, 2).roundLeftDown().lineTo(pointTarget.x + balloon.getPointerWidth(this) / 2, shaper.getCurrent().y).lineTo(pointTarget.x, pointTarget.y).close();
            return shaper.getShape();
        }
    }

    private static class Below
    extends AbstractPosition {
        private Below() {
        }

        @Override
        public Point getShiftedPoint(Point targetPoint, int shift) {
            return new Point(targetPoint.x, targetPoint.y + shift);
        }

        @Override
        int getChangeShift(AbstractPosition original, int xShift, int yShift) {
            return original == ABOVE ? yShift : 0;
        }

        @Override
        protected int getDistanceToTarget(Rectangle rectangle, Point targetPoint) {
            return rectangle.y - targetPoint.y;
        }

        @Override
        protected Rectangle getPointlessContentRec(Rectangle bounds, int pointerLength) {
            return new Rectangle(bounds.x, bounds.y + pointerLength, bounds.width, bounds.height - pointerLength);
        }

        @Override
        EmptyBorder createBorder(BalloonImpl balloon) {
            Insets insets = balloon.getInsetsCopy();
            insets.top += balloon.getPointerLength(this);
            return new EmptyBorder(insets);
        }

        @Override
        void setRecToRelativePosition(Rectangle rec, Point targetPoint) {
            rec.setLocation(new Point(targetPoint.x - rec.width / 2, targetPoint.y));
        }

        @Override
        Point getLocation(Dimension containerSize, Point targetPoint, Dimension balloonSize) {
            Point center = UIUtil.getCenterPoint((Rectangle)new Rectangle(targetPoint, (Dimension)JBUI.emptySize()), (Dimension)balloonSize);
            return new Point(center.x, targetPoint.y);
        }

        @Override
        protected Insets getTitleInsets(int normalInset, int pointerLength) {
            return new Insets(pointerLength, normalInset, normalInset, normalInset);
        }

        @Override
        protected Shape getPointingShape(Rectangle bounds, Point pointTarget, BalloonImpl balloon) {
            Shaper shaper = new Shaper(balloon, bounds, pointTarget, 1);
            shaper.line(balloon.getPointerWidth(this) / 2, balloon.getPointerLength(this)).toRightCurve().roundRightDown().toBottomCurve().roundLeftDown().toLeftCurve().roundLeftUp().toTopCurve().roundUpRight().lineTo(pointTarget.x - balloon.getPointerWidth(this) / 2, shaper.getCurrent().y).lineTo(pointTarget.x, pointTarget.y);
            shaper.close();
            return shaper.getShape();
        }
    }

    private static abstract class AbstractPosition {
        private AbstractPosition() {
        }

        abstract EmptyBorder createBorder(BalloonImpl var1);

        abstract void setRecToRelativePosition(Rectangle var1, Point var2);

        abstract int getChangeShift(AbstractPosition var1, int var2, int var3);

        public void updateBounds(BalloonImpl balloon) {
            if (balloon.myLayeredPane == null || balloon.myComp == null) {
                return;
            }
            Rectangle bounds = this.getUpdatedBounds(balloon.myLayeredPane.getSize(), balloon.myForcedBounds, balloon.myComp.getPreferredSize(), balloon.myShowPointer, balloon.myTargetPoint, balloon.myContainerInsets);
            Point point = this.getShiftedPoint(bounds.getLocation(), -balloon.getShadowBorderSize());
            bounds.setLocation(point);
            balloon.myComp._setBounds(bounds);
        }

        public Rectangle getUpdatedBounds(Dimension layeredPaneSize, Rectangle forcedBounds, Dimension preferredSize, boolean showPointer, Point point, Insets containerInsets) {
            Rectangle bounds = forcedBounds;
            if (bounds == null) {
                Point location = showPointer ? this.getLocation(layeredPaneSize, point, preferredSize) : new Point(point.x - preferredSize.width / 2, point.y - preferredSize.height / 2);
                bounds = new Rectangle(location.x, location.y, preferredSize.width, preferredSize.height);
                ScreenUtil.moveToFit((Rectangle)bounds, (Rectangle)new Rectangle(0, 0, layeredPaneSize.width, layeredPaneSize.height), (Insets)containerInsets);
            }
            return bounds;
        }

        abstract Point getLocation(Dimension var1, Point var2, Dimension var3);

        void paintComponent(BalloonImpl balloon, Rectangle bounds, Graphics2D g, Point pointTarget) {
            GraphicsConfig cfg = new GraphicsConfig((Graphics)g);
            cfg.setAntialiasing(true);
            Shape shape = balloon.myShowPointer ? this.getPointingShape(bounds, pointTarget, balloon) : new RoundRectangle2D.Double(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, balloon.getArc(), balloon.getArc());
            g.setColor(balloon.myFillColor);
            g.fill(shape);
            g.setColor(balloon.myBorderColor);
            if (balloon.myTitleLabel != null) {
                Rectangle titleBounds = balloon.myTitleLabel.getBounds();
                int shadow = balloon.getShadowBorderSize();
                Insets inset = this.getTitleInsets(BalloonImpl.getNormalInset() - 1 + shadow, balloon.getPointerLength(this) + 50 + shadow);
                titleBounds.x -= inset.left + 1;
                titleBounds.width += inset.left + inset.right + 50;
                titleBounds.y -= inset.top + 1;
                titleBounds.height += inset.top + inset.bottom + 1;
                Area area = new Area(shape);
                area.intersect(new Area(titleBounds));
                Color fgColor = UIManager.getColor("Label.foreground");
                fgColor = ColorUtil.toAlpha((Color)fgColor, (int)140);
                g.setColor(fgColor);
                g.fill(area);
                g.setColor(balloon.myBorderColor);
                g.draw(area);
            }
            g.draw(shape);
            cfg.restore();
        }

        protected abstract Insets getTitleInsets(int var1, int var2);

        protected abstract Shape getPointingShape(Rectangle var1, Point var2, BalloonImpl var3);

        public boolean isOkToHavePointer(Point targetPoint, Rectangle bounds, int pointerLength, int pointerWidth, int arc) {
            UnfairTextRange pointerRange;
            UnfairTextRange balloonRange;
            if (bounds.x < targetPoint.x && bounds.x + bounds.width > targetPoint.x && bounds.y < targetPoint.y && bounds.y + bounds.height < targetPoint.y) {
                return false;
            }
            Rectangle pointless = this.getPointlessContentRec(bounds, pointerLength);
            int size = this.getDistanceToTarget(pointless, targetPoint);
            if (size < pointerLength - 1) {
                return false;
            }
            if (this.isTopBottomPointer()) {
                balloonRange = new UnfairTextRange(bounds.x + arc, bounds.x + bounds.width - arc * 2);
                pointerRange = new UnfairTextRange(targetPoint.x - pointerWidth / 2, targetPoint.x + pointerWidth / 2);
            } else {
                balloonRange = new UnfairTextRange(bounds.y + arc, bounds.y + bounds.height - arc * 2);
                pointerRange = new UnfairTextRange(targetPoint.y - pointerWidth / 2, targetPoint.y + pointerWidth / 2);
            }
            return balloonRange.contains((TextRange)pointerRange);
        }

        protected abstract int getDistanceToTarget(Rectangle var1, Point var2);

        protected boolean isTopBottomPointer() {
            return this instanceof Below || this instanceof Above;
        }

        protected abstract Rectangle getPointlessContentRec(Rectangle var1, int var2);

        public Set<AbstractPosition> getOtherPositions() {
            HashSet all = new HashSet();
            all.add((Object)BELOW);
            all.add((Object)ABOVE);
            all.add((Object)AT_RIGHT);
            all.add((Object)AT_LEFT);
            all.remove((Object)this);
            return all;
        }

        public abstract Point getShiftedPoint(Point var1, int var2);
    }
}

