/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.ui.ComponentWithBrowseButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class CellEditorComponentWithBrowseButton<Comp extends JComponent>
extends JPanel {
    private final ComponentWithBrowseButton<Comp> myComponent;
    private final TableCellEditor myEditor;
    private final CellEditorListener myCellEditorListener = new CellEditorListener(){

        @Override
        public void editingCanceled(ChangeEvent e) {
            CellEditorComponentWithBrowseButton.this.onEditingFinished();
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            CellEditorComponentWithBrowseButton.this.onEditingFinished();
        }
    };
    private boolean myEditingFinished = false;
    private KeyEvent myCurrentEvent = null;

    public CellEditorComponentWithBrowseButton(ComponentWithBrowseButton<Comp> component, TableCellEditor editor) {
        super(new BorderLayout());
        this.myComponent = component;
        this.myEditor = editor;
        this.add((Component)this.myComponent, "Center");
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CellEditorComponentWithBrowseButton.this.myEditor.stopCellEditing();
            }
        }, KeyStroke.getKeyStroke(10, 0), 1);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CellEditorComponentWithBrowseButton.this.myEditor.cancelCellEditing();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    public ComponentWithBrowseButton<Comp> getComponentWithButton() {
        return this.myComponent;
    }

    public Comp getChildComponent() {
        return (Comp)this.getComponentWithButton().getChildComponent();
    }

    @Override
    public void requestFocus() {
        this.myComponent.requestFocus();
    }

    @Override
    public void setNextFocusableComponent(Component aComponent) {
        this.myComponent.setNextFocusableComponent(aComponent);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.myEditingFinished = false;
        this.myEditor.addCellEditorListener(this.myCellEditorListener);
    }

    @Override
    public void removeNotify() {
        if (!this.myEditingFinished) {
            this.myEditor.stopCellEditing();
            this.myEditingFinished = true;
        }
        super.removeNotify();
    }

    private void onEditingFinished() {
        this.myEditor.removeCellEditorListener(this.myCellEditorListener);
        this.myEditingFinished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (condition == 0 && this.myCurrentEvent != e) {
            try {
                this.myCurrentEvent = e;
                this.myComponent.getChildComponent().dispatchEvent(e);
            }
            finally {
                this.myCurrentEvent = null;
            }
        }
        if (e.isConsumed()) {
            return true;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }
}

