/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsUserImpl;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.MultipleValueFilterPopupComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UserFilterPopupComponent
extends MultipleValueFilterPopupComponent<VcsLogUserFilter> {
    private static final String ME = "me";
    @NotNull
    private final VcsLogDataHolder myDataHolder;
    @NotNull
    private final VcsLogUiProperties myUiProperties;

    UserFilterPopupComponent(@NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogDataHolder dataHolder, @NotNull FilterModel<VcsLogUserFilter> filterModel) {
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "<init>"));
        }
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "<init>"));
        }
        if (filterModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterModel", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "<init>"));
        }
        super("User", uiProperties, filterModel);
        this.myDataHolder = dataHolder;
        this.myUiProperties = uiProperties;
    }

    @Override
    @NotNull
    protected String getText(@NotNull VcsLogUserFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "getText"));
        }
        String string = UserFilterPopupComponent.displayableText(this.getValues(filter));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "getText"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String getToolTip(@NotNull VcsLogUserFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "getToolTip"));
        }
        return UserFilterPopupComponent.tooltip(this.getValues(filter));
    }

    @Override
    protected ActionGroup createActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(this.createAllAction());
        group.add(this.createSelectMultipleValuesAction());
        if (!this.myDataHolder.getCurrentUser().isEmpty()) {
            group.add(this.createPredefinedValueAction(Collections.singleton(ME)));
        }
        group.addAll(this.createRecentItemsActionGroup());
        return group;
    }

    @Override
    @NotNull
    protected Collection<String> getValues(@Nullable VcsLogUserFilter filter) {
        if (filter == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "getValues"));
            }
            return set;
        }
        HashSet hashSet = ContainerUtil.newHashSet(((VcsLogUserFilterImpl)filter).getUserNamesForPresentation());
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "getValues"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    protected List<List<String>> getRecentValuesFromSettings() {
        List<List<String>> list = this.myUiProperties.getRecentlyFilteredUserGroups();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "getRecentValuesFromSettings"));
        }
        return list;
    }

    @Override
    protected void rememberValuesInSettings(@NotNull Collection<String> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "rememberValuesInSettings"));
        }
        this.myUiProperties.addRecentlyFilteredUserGroup(new ArrayList<String>(values));
    }

    @Override
    @NotNull
    protected List<String> getAllValues() {
        List list = ContainerUtil.map(this.myDataHolder.getAllUsers(), (Function)new Function<VcsUser, String>(){

            public String fun(VcsUser user) {
                return user.getName();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "getAllValues"));
        }
        return list;
    }

    @Override
    @NotNull
    protected VcsLogUserFilter createFilter(@NotNull Collection<String> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "createFilter"));
        }
        VcsLogUserFilterImpl vcsLogUserFilterImpl = new VcsLogUserFilterImpl(values, this.myDataHolder.getCurrentUser(), this.myDataHolder.getAllUsers());
        if (vcsLogUserFilterImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "createFilter"));
        }
        return vcsLogUserFilterImpl;
    }

    private static class VcsLogUserFilterImpl
    implements VcsLogUserFilter {
        @NotNull
        private final Collection<String> myUsers;
        @NotNull
        private final Map<VirtualFile, VcsUser> myData;
        @NotNull
        private final Collection<String> myAllUserNames;

        public VcsLogUserFilterImpl(@NotNull Collection<String> users, @NotNull Map<VirtualFile, VcsUser> meData, @NotNull Set<VcsUser> allUsers) {
            if (users == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "users", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent$VcsLogUserFilterImpl", "<init>"));
            }
            if (meData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meData", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent$VcsLogUserFilterImpl", "<init>"));
            }
            if (allUsers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allUsers", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent$VcsLogUserFilterImpl", "<init>"));
            }
            this.myUsers = users;
            this.myData = meData;
            this.myAllUserNames = ContainerUtil.mapNotNull(allUsers, (Function)new Function<VcsUser, String>(){

                public String fun(VcsUser vcsUser) {
                    String name = vcsUser.getName();
                    if (!name.isEmpty()) {
                        return name.toLowerCase();
                    }
                    String email = vcsUser.getEmail();
                    int at = email.indexOf(64);
                    if (at > 0) {
                        return email.substring(0, at).toLowerCase();
                    }
                    return null;
                }
            });
        }

        @NotNull
        public Collection<String> getUserNames(@NotNull VirtualFile root) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent$VcsLogUserFilterImpl", "getUserNames"));
            }
            HashSet result = ContainerUtil.newHashSet();
            for (String user : this.myUsers) {
                if (UserFilterPopupComponent.ME.equals(user)) {
                    VcsUser vcsUser = this.myData.get(root);
                    if (vcsUser == null) continue;
                    result.addAll(this.getVariants(vcsUser.getName()));
                    continue;
                }
                result.addAll(this.getVariants(user));
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent$VcsLogUserFilterImpl", "getUserNames"));
            }
            return hashSet;
        }

        @NotNull
        public Collection<String> getUserNamesForPresentation() {
            Collection<String> collection = this.myUsers;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent$VcsLogUserFilterImpl", "getUserNamesForPresentation"));
            }
            return collection;
        }

        public boolean matches(final @NotNull VcsCommitMetadata commit) {
            if (commit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent$VcsLogUserFilterImpl", "matches"));
            }
            return ContainerUtil.exists(this.getUserNames(commit.getRoot()), (Condition)new Condition<String>(){

                public boolean value(String user) {
                    String lowerUser = user.toLowerCase();
                    return commit.getAuthor().getName().toLowerCase().equals(lowerUser) || commit.getAuthor().getEmail().toLowerCase().startsWith(lowerUser + "@");
                }
            });
        }

        @NotNull
        public Set<String> getVariants(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent$VcsLogUserFilterImpl", "getVariants"));
            }
            HashSet result = ContainerUtil.newHashSet((Object[])new String[]{name});
            Pair<String, String> firstAndLastName = VcsUserImpl.getFirstAndLastName(name);
            if (firstAndLastName != null) {
                result.addAll(ContainerUtil.filter(Arrays.asList((String)firstAndLastName.first + " " + (String)firstAndLastName.second, (String)firstAndLastName.first + "." + (String)firstAndLastName.second, (String)firstAndLastName.first + (String)firstAndLastName.second), (Condition)new Condition<String>(){

                    public boolean value(String s) {
                        return VcsLogUserFilterImpl.this.myAllUserNames.contains(s.toLowerCase());
                    }
                }));
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent$VcsLogUserFilterImpl", "getVariants"));
            }
            return hashSet;
        }
    }
}

