/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.config.PasswordSafeSettings;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.AuthenticationPanel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthDialog
extends DialogWrapper {
    private final AuthenticationPanel authPanel;

    public AuthDialog(@NotNull Project project, @NotNull String title, @Nullable String description, @Nullable String login, @Nullable String password, boolean rememberByDefault) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcsUtil/AuthDialog", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/vcsUtil/AuthDialog", "<init>"));
        }
        super(project, false);
        this.setTitle(title);
        Boolean rememberPassword = AuthDialog.decideOnShowRememberPasswordOption(password, rememberByDefault);
        this.authPanel = new AuthenticationPanel(description, login, password, rememberPassword);
        this.init();
    }

    @Nullable
    private static Boolean decideOnShowRememberPasswordOption(@Nullable String password, boolean rememberByDefault) {
        PasswordSafeImpl passwordSafe = (PasswordSafeImpl)PasswordSafe.getInstance();
        if (passwordSafe.getSettings().getProviderType().equals((Object)PasswordSafeSettings.ProviderType.DO_NOT_STORE)) {
            return null;
        }
        if (!StringUtil.isEmptyOrSpaces((String)password)) {
            return true;
        }
        return rememberByDefault;
    }

    protected JComponent createCenterPanel() {
        return this.authPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.authPanel.getPreferredFocusedComponent();
    }

    public String getUsername() {
        return this.authPanel.getLogin();
    }

    public String getPassword() {
        return String.valueOf(this.authPanel.getPassword());
    }

    public boolean isRememberPassword() {
        return this.authPanel.isRememberPassword();
    }
}

