/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.integer;

import com.intellij.psi.PsiType;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.integer.ConvertNumberIntentionBase;
import com.siyeh.ipp.integer.ConvertToPlainPredicate;
import java.math.BigDecimal;
import org.jetbrains.annotations.NotNull;

public class ConvertToPlainIntention
extends ConvertNumberIntentionBase {
    @Override
    protected String convertValue(Number value, PsiType type, boolean negated) {
        String text = new BigDecimal(value.toString()).toPlainString();
        if (negated) {
            text = "-" + text;
        }
        if (PsiType.FLOAT.equals((Object)type)) {
            text = text + "f";
        }
        return text;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ConvertToPlainPredicate convertToPlainPredicate = new ConvertToPlainPredicate();
        if (convertToPlainPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/integer/ConvertToPlainIntention", "getElementPredicate"));
        }
        return convertToPlainPredicate;
    }
}

