/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import org.intellij.lang.regexp.RegExpElementTypes;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;

public class RegExpGroupImpl
extends RegExpElementImpl
implements RegExpGroup {
    public RegExpGroupImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpGroup(this);
    }

    @Override
    public boolean isCapturing() {
        ASTNode node = this.getNode().getFirstChildNode();
        if (node == null) {
            return false;
        }
        IElementType type = node.getElementType();
        return type == RegExpTT.GROUP_BEGIN || type == RegExpTT.RUBY_NAMED_GROUP || type == RegExpTT.RUBY_QUOTED_NAMED_GROUP || type == RegExpTT.PYTHON_NAMED_GROUP;
    }

    @Override
    public boolean isSimple() {
        ASTNode node = this.getNode().getFirstChildNode();
        return node != null && (node.getElementType() == RegExpTT.GROUP_BEGIN || node.getElementType() == RegExpTT.NON_CAPT_GROUP);
    }

    @Override
    public RegExpPattern getPattern() {
        ASTNode node = this.getNode().findChildByType(RegExpElementTypes.PATTERN);
        return node != null ? (RegExpPattern)node.getPsi() : null;
    }

    @Override
    public boolean isPythonNamedGroup() {
        return this.getNode().findChildByType(RegExpTT.PYTHON_NAMED_GROUP) != null;
    }

    @Override
    public boolean isRubyNamedGroup() {
        return this.getNode().findChildByType(RegExpTT.RUBY_NAMED_GROUP) != null || this.getNode().findChildByType(RegExpTT.RUBY_QUOTED_NAMED_GROUP) != null;
    }

    @Override
    public boolean isNamedGroup() {
        return this.getNode().findChildByType(RegExpTT.RUBY_NAMED_GROUP) != null;
    }

    @Override
    public String getGroupName() {
        if (!this.isPythonNamedGroup() && !this.isRubyNamedGroup()) {
            return null;
        }
        ASTNode nameNode = this.getNode().findChildByType(RegExpTT.NAME);
        return nameNode != null ? nameNode.getText() : null;
    }
}

