/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jsonProtocol;

import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.vfs.CharsetToolkit;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntProcedure;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtf8Writer;
import io.netty.buffer.ByteBufUtilEx;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonUtil;
import org.jetbrains.jsonProtocol.JsonWriters;

public abstract class OutMessage {
    private final ByteBuf buffer = ByteBufAllocator.DEFAULT.heapBuffer();
    public final JsonWriter writer = new JsonWriter((Writer)new ByteBufUtf8Writer(this.buffer));
    private boolean finalized;

    protected OutMessage() {
        try {
            this.writer.beginObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void beginArguments() throws IOException {
    }

    protected final void writeEnum(String name, Enum<?> value) {
        try {
            this.beginArguments();
            this.writer.name(name).value(value.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void writeMap(String name, Map<String, String> value) {
        try {
            this.beginArguments();
            this.writer.name(name);
            this.writer.beginObject();
            for (Map.Entry<String, String> entry : value.entrySet()) {
                this.writer.name(entry.getKey()).value(entry.getValue());
            }
            this.writer.endObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final void writeInt(String name, int value) {
        try {
            this.beginArguments();
            this.writer.name(name).value((long)value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void writeLongArray(String name, long[] value) {
        try {
            this.beginArguments();
            this.writer.name(name);
            this.writer.beginArray();
            for (long v : value) {
                this.writer.value(v);
            }
            this.writer.endArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void writeDoubleArray(String name, double[] value) {
        try {
            this.beginArguments();
            this.writer.name(name);
            this.writer.beginArray();
            for (double v : value) {
                this.writer.value(v);
            }
            this.writer.endArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void writeIntArray(@NotNull String name, @NotNull int[] value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jsonProtocol/OutMessage", "writeIntArray"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jsonProtocol/OutMessage", "writeIntArray"));
        }
        try {
            this.beginArguments();
            this.writer.name(name);
            this.writer.beginArray();
            for (int v : value) {
                this.writer.value((long)v);
            }
            this.writer.endArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void writeIntSet(@NotNull String name, @NotNull TIntHashSet value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jsonProtocol/OutMessage", "writeIntSet"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jsonProtocol/OutMessage", "writeIntSet"));
        }
        try {
            this.beginArguments();
            this.writer.name(name);
            this.writer.beginArray();
            value.forEach(new TIntProcedure(){

                public boolean execute(int value) {
                    try {
                        OutMessage.this.writer.value((long)value);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return true;
                }
            });
            this.writer.endArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void writeIntList(@NotNull String name, @NotNull TIntArrayList value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jsonProtocol/OutMessage", "writeIntList"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jsonProtocol/OutMessage", "writeIntList"));
        }
        try {
            this.beginArguments();
            this.writer.name(name);
            this.writer.beginArray();
            for (int i = 0; i < value.size(); ++i) {
                this.writer.value((long)value.getQuick(i));
            }
            this.writer.endArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void writeSingletonIntArray(@NotNull String name, int value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jsonProtocol/OutMessage", "writeSingletonIntArray"));
        }
        try {
            this.beginArguments();
            this.writer.name(name);
            this.writer.beginArray();
            this.writer.value((long)value);
            this.writer.endArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final <E extends OutMessage> void writeList(String name, List<E> value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        try {
            this.beginArguments();
            this.writer.name(name);
            this.writer.beginArray();
            boolean isNotFirst = false;
            for (OutMessage item : value) {
                if (isNotFirst) {
                    this.buffer.writeByte(44).writeByte(32);
                } else {
                    isNotFirst = true;
                }
                if (!item.finalized) {
                    item.finalized = true;
                    try {
                        item.writer.endObject();
                    }
                    catch (IllegalStateException e) {
                        if ("Nesting problem.".equals(e.getMessage())) {
                            throw new RuntimeException(item.buffer.toString(CharsetToolkit.UTF8_CHARSET) + "\nparent:\n" + this.buffer.toString(CharsetToolkit.UTF8_CHARSET), e);
                        }
                        throw e;
                    }
                }
                this.buffer.writeBytes(item.buffer);
            }
            this.writer.endArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void writeStringList(@NotNull String name, @NotNull Collection<String> value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jsonProtocol/OutMessage", "writeStringList"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jsonProtocol/OutMessage", "writeStringList"));
        }
        try {
            this.beginArguments();
            JsonWriters.writeStringList(this.writer, name, value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void prepareWriteRaw(@NotNull OutMessage message, @NotNull String name) throws IOException {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/jsonProtocol/OutMessage", "prepareWriteRaw"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jsonProtocol/OutMessage", "prepareWriteRaw"));
        }
        message.writer.name(name).nullValue();
        ByteBuf itemBuffer = message.buffer;
        itemBuffer.writerIndex(itemBuffer.writerIndex() - "null".length());
    }

    public static void doWriteRaw(@NotNull OutMessage message, @NotNull String rawValue) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/jsonProtocol/OutMessage", "doWriteRaw"));
        }
        if (rawValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawValue", "org/jetbrains/jsonProtocol/OutMessage", "doWriteRaw"));
        }
        ByteBufUtilEx.writeUtf8(message.buffer, rawValue);
    }

    protected final void writeMessage(@NotNull String name, @NotNull OutMessage value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jsonProtocol/OutMessage", "writeMessage"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jsonProtocol/OutMessage", "writeMessage"));
        }
        try {
            this.beginArguments();
            OutMessage.prepareWriteRaw(this, name);
            if (!value.finalized) {
                value.close();
            }
            this.buffer.writeBytes(value.buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
        assert (!this.finalized);
        this.finalized = true;
        this.writer.endObject();
        this.writer.close();
    }

    protected final void writeLong(String name, long value) {
        try {
            this.beginArguments();
            this.writer.name(name).value(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void writeDouble(String name, double value) {
        try {
            this.beginArguments();
            this.writer.name(name).value(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final void writeBoolean(String name, boolean value) {
        try {
            this.beginArguments();
            this.writer.name(name).value(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final void writeString(@NotNull String name, @Nullable String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jsonProtocol/OutMessage", "writeString"));
        }
        if (value != null) {
            this.writeNullableString(name, value);
        }
    }

    protected final void writeString(@NotNull String name, CharSequence value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jsonProtocol/OutMessage", "writeString"));
        }
        if (value != null) {
            try {
                OutMessage.prepareWriteRaw(this, name);
                JsonUtil.escape(value, this.buffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected final void writeNullableString(@NotNull String name, @Nullable String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jsonProtocol/OutMessage", "writeNullableString"));
        }
        try {
            this.beginArguments();
            this.writer.name(name).value(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public final ByteBuf getBuffer() {
        ByteBuf byteBuf = this.buffer;
        if (byteBuf == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jsonProtocol/OutMessage", "getBuffer"));
        }
        return byteBuf;
    }
}

