/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PatternConditionPlus;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.TokenType;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class PsiElementPattern<T extends PsiElement, Self extends PsiElementPattern<T, Self>>
extends TreeElementPattern<PsiElement, T, Self> {
    protected PsiElementPattern(Class<T> aClass) {
        super(aClass);
    }

    protected PsiElementPattern(@NotNull InitialPatternCondition<T> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/patterns/PsiElementPattern", "<init>"));
        }
        super(condition);
    }

    protected PsiElement[] getChildren(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/patterns/PsiElementPattern", "getChildren"));
        }
        return element.getChildren();
    }

    @Override
    protected PsiElement getParent(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/patterns/PsiElementPattern", "getParent"));
        }
        return element.getContext();
    }

    public Self withElementType(IElementType type) {
        return this.withElementType((ElementPattern<IElementType>)PlatformPatterns.elementType().equalTo(type));
    }

    public Self withElementType(TokenSet type) {
        return this.withElementType(PlatformPatterns.elementType().tokenSet(type));
    }

    public Self afterLeaf(String ... withText) {
        if (withText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "withText", "com/intellij/patterns/PsiElementPattern", "afterLeaf"));
        }
        return this.afterLeaf((ElementPattern<? extends PsiElement>)PlatformPatterns.psiElement().withText(StandardPatterns.string().oneOf(withText)));
    }

    public Self afterLeaf(@NotNull ElementPattern<? extends PsiElement> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/PsiElementPattern", "afterLeaf"));
        }
        return this.afterLeafSkipping((ElementPattern)PlatformPatterns.psiElement().whitespaceCommentEmptyOrError(), pattern);
    }

    public Self beforeLeaf(@NotNull ElementPattern<? extends PsiElement> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/PsiElementPattern", "beforeLeaf"));
        }
        return this.beforeLeafSkipping((ElementPattern)PlatformPatterns.psiElement().whitespaceCommentEmptyOrError(), pattern);
    }

    public Self whitespace() {
        return this.withElementType(TokenType.WHITE_SPACE);
    }

    public Self whitespaceCommentOrError() {
        return (Self)((PsiElementPattern)this.andOr(new ElementPattern[]{PlatformPatterns.psiElement().whitespace(), PlatformPatterns.psiElement(PsiComment.class), PlatformPatterns.psiElement(PsiErrorElement.class)}));
    }

    public Self whitespaceCommentEmptyOrError() {
        return (Self)((PsiElementPattern)this.andOr(new ElementPattern[]{PlatformPatterns.psiElement().whitespace(), PlatformPatterns.psiElement(PsiComment.class), PlatformPatterns.psiElement(PsiErrorElement.class), PlatformPatterns.psiElement().withText("")}));
    }

    public Self withFirstNonWhitespaceChild(@NotNull ElementPattern<? extends PsiElement> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/PsiElementPattern", "withFirstNonWhitespaceChild"));
        }
        return (Self)((PsiElementPattern)this.withChildren(StandardPatterns.collection(PsiElement.class).filter(StandardPatterns.not(PlatformPatterns.psiElement().whitespace()), StandardPatterns.collection(PsiElement.class).first(pattern))));
    }

    public Self withReference(final Class<? extends PsiReference> referenceClass) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("withReference"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$1", "accepts"));
                }
                for (PsiReference reference : t.getReferences()) {
                    if (!referenceClass.isInstance(reference)) continue;
                    return true;
                }
                return false;
            }
        }));
    }

    public Self inFile(final @NotNull ElementPattern<? extends PsiFile> filePattern) {
        if (filePattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePattern", "com/intellij/patterns/PsiElementPattern", "inFile"));
        }
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("inFile"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$2", "accepts"));
                }
                return filePattern.accepts(t.getContainingFile(), context);
            }
        }));
    }

    public Self inVirtualFile(final @NotNull ElementPattern<? extends VirtualFile> filePattern) {
        if (filePattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePattern", "com/intellij/patterns/PsiElementPattern", "inVirtualFile"));
        }
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("inVirtualFile"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$3", "accepts"));
                }
                return filePattern.accepts(t.getContainingFile().getViewProvider().getVirtualFile(), context);
            }
        }));
    }

    @Override
    public Self equalTo(@NotNull T o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/patterns/PsiElementPattern", "equalTo"));
        }
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("equalTo", (PsiElement)o){
            final /* synthetic */ PsiElement val$o;
            {
                this.val$o = psiElement;
                super(x0);
            }

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$4", "accepts"));
                }
                return t.getManager().areElementsEquivalent((PsiElement)t, this.val$o);
            }
        }));
    }

    public Self withElementType(final ElementPattern<IElementType> pattern) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("withElementType"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$5", "accepts"));
                }
                ASTNode node = t.getNode();
                return node != null && pattern.accepts(node.getElementType());
            }
        }));
    }

    public Self withText(@NotNull @NonNls String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/patterns/PsiElementPattern", "withText"));
        }
        return this.withText((ElementPattern)StandardPatterns.string().equalTo(text));
    }

    public Self withoutText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/patterns/PsiElementPattern", "withoutText"));
        }
        return this.withoutText((ElementPattern)StandardPatterns.string().equalTo(text));
    }

    public Self withName(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/patterns/PsiElementPattern", "withName"));
        }
        return this.withName((ElementPattern<String>)StandardPatterns.string().equalTo(name));
    }

    public Self withName(String ... names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/patterns/PsiElementPattern", "withName"));
        }
        return this.withName(StandardPatterns.string().oneOf(names));
    }

    public Self withName(@NotNull ElementPattern<String> name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/patterns/PsiElementPattern", "withName"));
        }
        return (Self)((PsiElementPattern)this.with(new PsiNamePatternCondition("withName", name)));
    }

    public Self afterLeafSkipping(final @NotNull ElementPattern skip, final @NotNull ElementPattern pattern) {
        if (skip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skip", "com/intellij/patterns/PsiElementPattern", "afterLeafSkipping"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/PsiElementPattern", "afterLeafSkipping"));
        }
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("afterLeafSkipping"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$6", "accepts"));
                }
                Object element = t;
                while ((element = PsiTreeUtil.prevLeaf(element)) != null && element.getTextLength() == 0 || skip.accepts(element, context)) {
                }
                return pattern.accepts(element, context);
            }
        }));
    }

    public Self beforeLeafSkipping(final @NotNull ElementPattern skip, final @NotNull ElementPattern pattern) {
        if (skip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skip", "com/intellij/patterns/PsiElementPattern", "beforeLeafSkipping"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/PsiElementPattern", "beforeLeafSkipping"));
        }
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("beforeLeafSkipping"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$7", "accepts"));
                }
                Object element = t;
                while ((element = PsiTreeUtil.nextLeaf(element)) != null && element.getTextLength() == 0 || skip.accepts(element, context)) {
                }
                return pattern.accepts(element, context);
            }
        }));
    }

    public Self atStartOf(final @NotNull ElementPattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/PsiElementPattern", "atStartOf"));
        }
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("atStartOf"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$8", "accepts"));
                }
                for (Object element = t; element != null; element = element.getContext()) {
                    if (!pattern.accepts(element, context)) continue;
                    return element.getTextRange().getStartOffset() == t.getTextRange().getStartOffset();
                }
                return false;
            }
        }));
    }

    public Self withTextLength(@NotNull ElementPattern lengthPattern) {
        if (lengthPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lengthPattern", "com/intellij/patterns/PsiElementPattern", "withTextLength"));
        }
        return (Self)((PsiElementPattern)this.with(new PatternConditionPlus<T, Integer>("withTextLength", lengthPattern){

            @Override
            public boolean processValues(T t, ProcessingContext context, PairProcessor<Integer, ProcessingContext> integerProcessingContextPairProcessor) {
                return integerProcessingContextPairProcessor.process((Object)t.getTextLength(), (Object)context);
            }
        }));
    }

    public Self notEmpty() {
        return this.withTextLengthLongerThan(0);
    }

    public Self withTextLengthLongerThan(final int minLength) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("withTextLengthLongerThan"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$10", "accepts"));
                }
                return t.getTextLength() > minLength;
            }
        }));
    }

    public Self withText(@NotNull ElementPattern text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/patterns/PsiElementPattern", "withText"));
        }
        return (Self)((PsiElementPattern)this.with(this._withText(text)));
    }

    private PatternCondition<T> _withText(ElementPattern pattern) {
        return new PatternConditionPlus<T, String>("_withText", pattern){

            @Override
            public boolean processValues(T t, ProcessingContext context, PairProcessor<String, ProcessingContext> processor) {
                return processor.process((Object)t.getText(), (Object)context);
            }
        };
    }

    public Self withoutText(@NotNull ElementPattern text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/patterns/PsiElementPattern", "withoutText"));
        }
        return (Self)((PsiElementPattern)this.without(this._withText(text)));
    }

    public Self withLanguage(final @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/patterns/PsiElementPattern", "withLanguage"));
        }
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("withLanguage"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$12", "accepts"));
                }
                return ((Object)((Object)t.getLanguage())).equals((Object)language);
            }
        }));
    }

    public Self withMetaData(final ElementPattern<? extends PsiMetaData> metaDataPattern) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("withMetaData"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$13", "accepts"));
                }
                return t instanceof PsiMetaOwner && metaDataPattern.accepts(((PsiMetaOwner)t).getMetaData(), context);
            }
        }));
    }

    public Self referencing(final ElementPattern<? extends PsiElement> targetPattern) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("referencing"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                PsiReference[] references;
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$14", "accepts"));
                }
                for (PsiReference reference : references = t.getReferences()) {
                    if (targetPattern.accepts(reference.resolve(), context)) {
                        return true;
                    }
                    if (!(reference instanceof PsiPolyVariantReference)) continue;
                    for (ResolveResult result : ((PsiPolyVariantReference)reference).multiResolve(true)) {
                        if (!targetPattern.accepts(result.getElement(), context)) continue;
                        return true;
                    }
                }
                return false;
            }
        }));
    }

    public Self compiled() {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("compiled"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$15", "accepts"));
                }
                return t instanceof PsiCompiledElement;
            }
        }));
    }

    public Self withTreeParent(final ElementPattern<? extends PsiElement> ancestor) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("withTreeParent"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$16", "accepts"));
                }
                return ancestor.accepts(t.getParent(), context);
            }
        }));
    }

    public Self insideStarting(final ElementPattern<? extends PsiElement> ancestor) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<PsiElement>("insideStarting"){

            @Override
            public boolean accepts(@NotNull PsiElement start, ProcessingContext context) {
                if (start == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/patterns/PsiElementPattern$17", "accepts"));
                }
                PsiElement element = PsiElementPattern.this.getParent(start);
                TextRange range = start.getTextRange();
                if (range == null) {
                    return false;
                }
                int startOffset = range.getStartOffset();
                while (element != null && element.getTextRange() != null && element.getTextRange().getStartOffset() == startOffset) {
                    if (ancestor.accepts(element, context)) {
                        return true;
                    }
                    element = PsiElementPattern.this.getParent(element);
                }
                return false;
            }
        }));
    }

    public static class Capture<T extends PsiElement>
    extends PsiElementPattern<T, Capture<T>> {
        protected Capture(Class<T> aClass) {
            super(aClass);
        }

        protected Capture(@NotNull InitialPatternCondition<T> condition) {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/patterns/PsiElementPattern$Capture", "<init>"));
            }
            super(condition);
        }
    }
}

