/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.designer;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.designer.MarginType;
import com.android.tools.idea.designer.ResizeContext;
import com.android.tools.idea.designer.ResizePolicy;
import com.android.tools.idea.designer.Segment;
import com.android.tools.idea.designer.SegmentType;
import com.android.tools.idea.rendering.RenderService;
import com.intellij.android.designer.AndroidDesignerUtils;
import com.intellij.android.designer.designSurface.feedbacks.TextFeedback;
import com.intellij.android.designer.designSurface.graphics.DirectionResizePoint;
import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import com.intellij.android.designer.designSurface.graphics.RectangleFeedback;
import com.intellij.android.designer.designSurface.graphics.ResizeSelectionDecorator;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.feedbacks.LineMarginBorder;
import com.intellij.designer.designSurface.selection.ResizePoint;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.xml.XmlTag;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResizeOperation
implements EditOperation {
    public static final String TYPE = "resize_children";
    private static final String LABEL_CHANGE_BOTH = "Change layout:width x layout:height";
    private static final String LABEL_CHANGE_WIDTH = "Change layout:width";
    private static final String LABEL_CHANGE_HEIGHT = "Change layout:height";
    protected ResizeContext myResizeContext;
    protected final OperationContext myContext;
    protected RadViewComponent myComponent;
    protected TextFeedback myTextFeedback;
    private RectangleFeedback myWrapFeedback;
    private RectangleFeedback myFillFeedback;
    private RectangleFeedback myFeedback;

    public ResizeOperation(OperationContext context) {
        this.myContext = context;
    }

    private Rectangle getResizedBounds() {
        Rectangle b = this.myComponent.getBounds();
        Dimension sizeDelta = this.myContext.getSizeDelta();
        FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
        sizeDelta = this.myComponent.toModel((Component)layer, sizeDelta);
        int direction = this.myContext.getResizeDirection();
        int x = b.x;
        int y = b.y;
        int w = b.width;
        int h = b.height;
        int newW = b.width + sizeDelta.width;
        int newH = b.height + sizeDelta.height;
        ResizePolicy resizePolicy = ResizePolicy.getResizePolicy(this.myComponent);
        if (resizePolicy.isAspectPreserving() && w != 0 && h != 0 && (this.myResizeContext.modifierMask & 1) == 0) {
            double aspectRatio = (double)w / (double)h;
            double newAspectRatio = (double)newW / (double)newH;
            if (newH == 0 || newAspectRatio > aspectRatio) {
                newH = (int)((double)newW / aspectRatio);
            } else {
                newW = (int)((double)newH * aspectRatio);
            }
            switch (direction) {
                case 2: {
                    direction = 10;
                    this.myResizeContext.verticalEdgeType = SegmentType.RIGHT;
                    break;
                }
                case 1: {
                    direction = 9;
                    this.myResizeContext.verticalEdgeType = SegmentType.RIGHT;
                    break;
                }
                case 8: {
                    direction = 10;
                    this.myResizeContext.horizontalEdgeType = SegmentType.BOTTOM;
                    break;
                }
                case 4: {
                    direction = 6;
                    this.myResizeContext.horizontalEdgeType = SegmentType.BOTTOM;
                }
            }
        }
        if (ResizeOperation.isLeft(direction)) {
            int x2 = b.x + b.width;
            w = newW;
            x = x2 - newW;
        } else if (ResizeOperation.isRight(direction)) {
            w = newW;
        } else assert (direction == 2 || direction == 1) : direction;
        if (ResizeOperation.isTop(direction)) {
            int y2 = b.y + b.height;
            h = newH;
            y = y2 - newH;
        } else if (ResizeOperation.isBottom(direction)) {
            h = newH;
        } else assert (direction == 4 || direction == 8) : direction;
        return new Rectangle(x, y, Math.max(w, 0), Math.max(h, 0));
    }

    public void setComponents(List<RadComponent> components) {
    }

    public void setComponent(RadComponent component) {
        this.myComponent = (RadViewComponent)component;
        this.init();
    }

    private void init() {
        XmlTag tag;
        ViewInfo viewInfo;
        assert (this.myComponent != null);
        RadViewComponent layout = (RadViewComponent)this.myComponent.getParent();
        int direction1 = this.myContext.getResizeDirection();
        Object layoutView = layout.getViewInfo() != null ? layout.getViewInfo().getViewObject() : null;
        this.myResizeContext = this.createResizeContext(layout, layoutView, this.myComponent);
        this.myResizeContext.bounds = this.myComponent.getBounds();
        this.myResizeContext.horizontalEdgeType = SegmentType.getHorizontalResizeEdge(direction1);
        this.myResizeContext.verticalEdgeType = SegmentType.getVerticalResizeEdge(direction1);
        FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
        Rectangle bounds = this.myComponent.getBounds((Component)layer);
        Dimension fillSize = this.myComponent.fromModel((Component)layer, this.myResizeContext.fillSize);
        Dimension wrapSize = this.myComponent.fromModel((Component)layer, this.myResizeContext.wrapSize);
        int direction = this.myContext.getResizeDirection();
        int wrapX = bounds.x;
        int wrapY = bounds.y;
        int fillWidth = fillSize.width;
        int fillHeight = fillSize.height;
        if (ResizeOperation.isLeft(direction)) {
            wrapX = bounds.x + bounds.width - wrapSize.width;
        } else if (ResizeOperation.isRight(direction)) {
            wrapX = bounds.x;
        } else {
            assert (direction == 2 || direction == 1) : direction;
            fillWidth = bounds.width;
        }
        if (ResizeOperation.isTop(direction)) {
            wrapY = bounds.y + bounds.height - wrapSize.height;
        } else if (ResizeOperation.isBottom(direction)) {
            wrapY = bounds.y;
        } else {
            assert (direction == 4 || direction == 8) : direction;
            fillHeight = bounds.height;
        }
        Rectangle wrapBounds = new Rectangle(wrapX, wrapY, wrapSize.width, wrapSize.height);
        Rectangle fillBounds = new Rectangle(bounds.x, bounds.y, fillWidth, fillHeight);
        RenderService service = AndroidDesignerUtils.getRenderService(this.myContext.getArea());
        if (service != null && (viewInfo = service.measureChild(tag = this.myComponent.getTag(), new RenderService.AttributeFilter(){

            @Override
            public String getAttribute(@NotNull XmlTag n, @Nullable String namespace, @NotNull String name) {
                if (n == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n", "com/android/tools/idea/designer/ResizeOperation$1", "getAttribute"));
                }
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/designer/ResizeOperation$1", "getAttribute"));
                }
                if (n == tag && ("layout_width".equals(name) || "layout_height".equals(name)) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                    return "fill_parent";
                }
                return null;
            }
        })) != null) {
            int left = viewInfo.getLeft();
            int top = viewInfo.getTop();
            fillBounds = new Rectangle(left, top, viewInfo.getRight() - left, viewInfo.getBottom() - top);
            fillBounds = this.myComponent.fromModel((Component)layer, fillBounds);
        }
        this.myWrapFeedback = new RectangleFeedback(DrawingStyle.RESIZE_WRAP);
        this.myWrapFeedback.setBounds(wrapBounds);
        this.myFillFeedback = new RectangleFeedback(DrawingStyle.GUIDELINE_DASHED);
        this.myFillFeedback.setBounds(fillBounds);
    }

    private void createFeedback() {
        if (this.myFeedback == null) {
            FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
            this.myFeedback = new RectangleFeedback(DrawingStyle.RESIZE_PREVIEW);
            layer.add((Component)((Object)this.myFeedback));
            this.myTextFeedback = new TextFeedback();
            this.myTextFeedback.setBorder((Border)new LineMarginBorder(0, 5, 3, 0));
            layer.add((Component)((Object)this.myTextFeedback));
            layer.add((Component)((Object)this.myWrapFeedback));
            layer.add((Component)((Object)this.myFillFeedback));
            layer.repaint();
            this.onResizeBegin();
        }
    }

    private static boolean isLeft(int direction) {
        return direction == 5 || direction == 4 || direction == 6;
    }

    private static boolean isRight(int direction) {
        return direction == 9 || direction == 8 || direction == 10;
    }

    private static boolean isTop(int direction) {
        return direction == 5 || direction == 1 || direction == 9;
    }

    private static boolean isBottom(int direction) {
        return direction == 6 || direction == 2 || direction == 10;
    }

    protected ResizeContext createResizeContext(RadViewComponent layout, @Nullable Object layoutView, RadViewComponent node) {
        return new ResizeContext(this.myContext.getArea(), layout, layoutView, node);
    }

    protected void setNewSizeBounds(ResizeContext resizeContext, RadViewComponent node, RadViewComponent layout, Rectangle oldBounds, Rectangle newBounds, SegmentType horizontalEdge, SegmentType verticalEdge) {
        if (verticalEdge != null && (newBounds.width != oldBounds.width || resizeContext.wrapWidth || resizeContext.fillWidth)) {
            node.setAttribute("layout_width", "http://schemas.android.com/apk/res/android", resizeContext.getWidthAttribute());
        }
        if (horizontalEdge != null && (newBounds.height != oldBounds.height || resizeContext.wrapHeight || resizeContext.fillHeight)) {
            node.setAttribute("layout_height", "http://schemas.android.com/apk/res/android", resizeContext.getHeightAttribute());
        }
    }

    protected String getResizeUpdateMessage(ResizeContext resizeContext, RadViewComponent child, RadViewComponent parent, Rectangle newBounds, SegmentType horizontalEdge, SegmentType verticalEdge) {
        String width = resizeContext.getWidthAttribute();
        String height = resizeContext.getHeightAttribute();
        if (horizontalEdge == null) {
            return width;
        }
        if (verticalEdge == null) {
            return height;
        }
        return String.format("%s \u00d7 %s", width, height);
    }

    public void onResizeBegin() {
    }

    public void onResizeUpdate(@NotNull RadViewComponent parent, @NotNull Rectangle newBounds, int modifierMask) {
        Rectangle parentBounds;
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/designer/ResizeOperation", "onResizeUpdate"));
        }
        if (newBounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newBounds", "com/android/tools/idea/designer/ResizeOperation", "onResizeUpdate"));
        }
        this.myResizeContext.bounds = newBounds;
        this.myResizeContext.modifierMask = modifierMask;
        this.myResizeContext.wrapHeight = false;
        this.myResizeContext.wrapWidth = false;
        if (this.myResizeContext.wrapSize != null) {
            Dimension b = this.myResizeContext.wrapSize;
            if (this.myResizeContext.horizontalEdgeType != null && Math.abs(newBounds.height - b.height) < 20) {
                this.myResizeContext.wrapHeight = true;
                if (this.myResizeContext.horizontalEdgeType == SegmentType.TOP) {
                    newBounds.y += newBounds.height - b.height;
                }
                newBounds.height = b.height;
            }
            if (this.myResizeContext.verticalEdgeType != null && Math.abs(newBounds.width - b.width) < 20) {
                this.myResizeContext.wrapWidth = true;
                if (this.myResizeContext.verticalEdgeType == SegmentType.LEFT) {
                    newBounds.x += newBounds.width - b.width;
                }
                newBounds.width = b.width;
            }
        }
        this.myResizeContext.horizontalFillSegment = null;
        this.myResizeContext.fillHeight = false;
        if (this.myResizeContext.horizontalEdgeType == SegmentType.BOTTOM && !this.myResizeContext.wrapHeight) {
            parentBounds = parent.getBounds();
            this.myResizeContext.horizontalFillSegment = new Segment(parentBounds.y + parentBounds.height, newBounds.x, newBounds.x + newBounds.width, null, null, SegmentType.BOTTOM, MarginType.NO_MARGIN);
            if (Math.abs(newBounds.y + newBounds.height - (parentBounds.y + parentBounds.height)) < 20) {
                this.myResizeContext.fillHeight = true;
                newBounds.height = parentBounds.y + parentBounds.height - newBounds.y;
            }
        }
        this.myResizeContext.verticalFillSegment = null;
        this.myResizeContext.fillWidth = false;
        if (this.myResizeContext.verticalEdgeType == SegmentType.RIGHT && !this.myResizeContext.wrapWidth) {
            parentBounds = parent.getBounds();
            this.myResizeContext.verticalFillSegment = new Segment(parentBounds.x + parentBounds.width, newBounds.y, newBounds.y + newBounds.height, null, null, SegmentType.RIGHT, MarginType.NO_MARGIN);
            if (Math.abs(newBounds.x + newBounds.width - (parentBounds.x + parentBounds.width)) < 20) {
                this.myResizeContext.fillWidth = true;
                newBounds.width = parentBounds.x + parentBounds.width - newBounds.x;
            }
        }
    }

    protected void updateResizeMessage() {
        RadViewComponent layout = (RadViewComponent)this.myComponent.getParent();
        String message = this.getResizeUpdateMessage(this.myResizeContext, this.myComponent, layout, this.myResizeContext.bounds, this.myResizeContext.horizontalEdgeType, this.myResizeContext.verticalEdgeType);
        this.myTextFeedback.append(message);
        this.myTextFeedback.setSize(this.myTextFeedback.getPreferredSize());
        this.myTextFeedback.locationTo(this.myContext.getLocation(), 15);
    }

    public void showFeedback() {
        this.createFeedback();
        FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
        Rectangle modelBounds = this.getResizedBounds();
        RadViewComponent layout = (RadViewComponent)this.myComponent.getParent();
        this.onResizeUpdate(layout, modelBounds, this.myContext.getModifiers());
        Rectangle viewBounds = this.myComponent.fromModel((Component)layer, this.myResizeContext.bounds);
        this.myFeedback.setBounds(viewBounds);
        this.myTextFeedback.clear();
        this.updateResizeMessage();
    }

    public void eraseFeedback() {
        if (this.myFeedback != null) {
            FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
            layer.remove((Component)((Object)this.myFeedback));
            layer.remove((Component)((Object)this.myTextFeedback));
            layer.remove((Component)((Object)this.myWrapFeedback));
            layer.remove((Component)((Object)this.myFillFeedback));
            layer.repaint();
            this.myFeedback = null;
            this.myTextFeedback = null;
            this.myWrapFeedback = null;
            this.myFillFeedback = null;
        }
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() throws Exception {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                RadViewComponent layout = (RadViewComponent)ResizeOperation.this.myComponent.getParent();
                Rectangle oldBounds = ResizeOperation.this.myComponent.getBounds();
                Rectangle newBounds = ResizeOperation.this.getResizedBounds();
                ResizeOperation.this.setNewSizeBounds(ResizeOperation.this.myResizeContext, ResizeOperation.this.myComponent, layout, oldBounds, newBounds, ResizeOperation.this.myResizeContext.horizontalEdgeType, ResizeOperation.this.myResizeContext.verticalEdgeType);
            }
        });
    }

    public static void addResizePoints(ResizeSelectionDecorator decorator) {
        ResizeOperation.addResizePoints(decorator, ResizePolicy.full());
    }

    public static void addResizePoints(ResizeSelectionDecorator decorator, @NotNull RadViewComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/designer/ResizeOperation", "addResizePoints"));
        }
        ResizeOperation.addResizePoints(decorator, ResizePolicy.getResizePolicy(component));
    }

    public static void addResizePoints(ResizeSelectionDecorator decorator, @NotNull ResizePolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/android/tools/idea/designer/ResizeOperation", "addResizePoints"));
        }
        if (policy.leftAllowed()) {
            decorator.addPoint((ResizePoint)new DirectionResizePoint(DrawingStyle.SELECTION, 4, TYPE, LABEL_CHANGE_WIDTH));
            if (policy.topAllowed()) {
                decorator.addPoint((ResizePoint)new DirectionResizePoint(DrawingStyle.SELECTION, 5, TYPE, LABEL_CHANGE_BOTH));
            }
            if (policy.bottomAllowed()) {
                decorator.addPoint((ResizePoint)new DirectionResizePoint(DrawingStyle.SELECTION, 6, TYPE, LABEL_CHANGE_BOTH));
            }
        }
        if (policy.rightAllowed()) {
            decorator.addPoint((ResizePoint)new DirectionResizePoint(DrawingStyle.SELECTION, 8, TYPE, LABEL_CHANGE_WIDTH));
            if (policy.topAllowed()) {
                decorator.addPoint((ResizePoint)new DirectionResizePoint(DrawingStyle.SELECTION, 9, TYPE, LABEL_CHANGE_BOTH));
            }
            if (policy.bottomAllowed()) {
                decorator.addPoint((ResizePoint)new DirectionResizePoint(DrawingStyle.SELECTION, 10, TYPE, LABEL_CHANGE_BOTH));
            }
        }
        if (policy.topAllowed()) {
            decorator.addPoint((ResizePoint)new DirectionResizePoint(DrawingStyle.SELECTION, 1, TYPE, LABEL_CHANGE_HEIGHT));
        }
        if (policy.bottomAllowed()) {
            decorator.addPoint((ResizePoint)new DirectionResizePoint(DrawingStyle.SELECTION, 2, TYPE, LABEL_CHANGE_HEIGHT));
        }
    }
}

