/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.editors.navigation.macros.Analyser;
import com.android.tools.idea.rendering.RenderedView;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HierarchyUtils {
    HierarchyUtils() {
    }

    @Nullable
    static String getViewId(@Nullable RenderedView leaf) {
        XmlTag tag;
        if (leaf != null && (tag = leaf.tag) != null) {
            String attributeValue = tag.getAttributeValue("android:id");
            int prefixLength = Analyser.getPrefix(attributeValue).length();
            if (attributeValue != null && prefixLength != 0) {
                return attributeValue.substring(prefixLength);
            }
        }
        return null;
    }

    @Nullable
    static String getViewId(@Nullable ViewInfo leaf) {
        Object cookie;
        if (leaf != null && (cookie = leaf.getCookie()) instanceof XmlTag) {
            XmlTag tag = (XmlTag)cookie;
            String attributeValue = tag.getAttributeValue("android:id");
            int prefixLength = Analyser.getPrefix(attributeValue).length();
            if (attributeValue != null && prefixLength != 0) {
                return attributeValue.substring(prefixLength);
            }
        }
        return null;
    }

    @NotNull
    static RenderedView getRoot(@NotNull RenderedView view) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/editors/navigation/HierarchyUtils", "getRoot"));
        }
        while (true) {
            RenderedView parent;
            if ((parent = view.getParent()) == null) {
                RenderedView renderedView = view;
                if (renderedView == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/navigation/HierarchyUtils", "getRoot"));
                }
                return renderedView;
            }
            view = parent;
        }
    }

    @Nullable
    static RenderedView getNamedParent(@Nullable RenderedView view) {
        while (view != null && HierarchyUtils.getViewId(view) == null) {
            view = view.getParent();
        }
        return view;
    }

    private static String getTagName(@Nullable RenderedView leaf) {
        if (leaf != null && leaf.tag != null) {
            return leaf.tag.getName();
        }
        return "null";
    }

    private static String getTagName(@Nullable ViewInfo leaf) {
        Object cookie;
        if (leaf != null && (cookie = leaf.getCookie()) instanceof XmlTag) {
            XmlTag tag = (XmlTag)cookie;
            return tag.getName();
        }
        return "null";
    }

    private static String getClassName(@Nullable ViewInfo leaf) {
        if (leaf != null) {
            return leaf.getViewObject().getClass().getSimpleName();
        }
        return "null";
    }

    private static String getClassName(@Nullable RenderedView leaf) {
        if (leaf != null) {
            return HierarchyUtils.getClassName(leaf.view);
        }
        return "null";
    }

    static String toString(@Nullable RenderedView root) {
        if (root == null) {
            return "";
        }
        final StringBuilder buffer = new StringBuilder();
        new Object(){

            public void display(RenderedView view, String indent) {
                buffer.append(indent + HierarchyUtils.getClassName(view) + " " + HierarchyUtils.getTagName(view) + " " + HierarchyUtils.getViewId(view) + "\n");
                for (RenderedView c : view.getChildren()) {
                    this.display(c, "  " + indent);
                }
            }
        }.display(root, "");
        return buffer.toString();
    }

    static String toString(@Nullable ViewInfo root) {
        if (root == null) {
            return "";
        }
        final StringBuilder buffer = new StringBuilder();
        new Object(){

            public void display(ViewInfo view, String indent) {
                buffer.append(indent + HierarchyUtils.getClassName(view) + " " + HierarchyUtils.getTagName(view) + " " + HierarchyUtils.getViewId(view) + "\n");
                for (ViewInfo c : view.getChildren()) {
                    this.display(c, ".." + indent);
                }
            }
        }.display(root, "");
        return buffer.toString();
    }
}

