/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.preview;

import com.intellij.codeInsight.preview.ElementPreviewProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakHashMap;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageOrColorPreviewManager
implements Disposable,
EditorMouseMotionListener {
    private static final Logger LOG = Logger.getInstance(ImageOrColorPreviewManager.class);
    private static final Key<KeyListener> EDITOR_LISTENER_ADDED = Key.create((String)"previewManagerListenerAdded");
    private final Alarm alarm = new Alarm();
    @Nullable
    private Collection<PsiElement> myElements;

    public ImageOrColorPreviewManager(EditorFactory editorFactory) {
        editorFactory.addEditorFactoryListener(new EditorFactoryListener(){

            public void editorCreated(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/preview/ImageOrColorPreviewManager$1", "editorCreated"));
                }
                ImageOrColorPreviewManager.this.registerListeners(event.getEditor());
            }

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/preview/ImageOrColorPreviewManager$1", "editorReleased"));
                }
                Editor editor = event.getEditor();
                if (editor.isOneLineMode()) {
                    return;
                }
                KeyListener keyListener = (KeyListener)EDITOR_LISTENER_ADDED.get((UserDataHolder)editor);
                if (keyListener != null) {
                    EDITOR_LISTENER_ADDED.set((UserDataHolder)editor, null);
                    editor.getContentComponent().removeKeyListener(keyListener);
                    editor.removeEditorMouseMotionListener((EditorMouseMotionListener)ImageOrColorPreviewManager.this);
                }
            }
        }, (Disposable)this);
    }

    private void registerListeners(final Editor editor) {
        if (editor.isOneLineMode()) {
            return;
        }
        Project project = editor.getProject();
        if (project == null || project.isDisposed()) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (psiFile == null || psiFile instanceof PsiCompiledElement || !ImageOrColorPreviewManager.isSupportedFile(psiFile)) {
            return;
        }
        editor.addEditorMouseMotionListener((EditorMouseMotionListener)this);
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PointerInfo pointerInfo;
                if (e.getKeyCode() == 16 && !editor.isOneLineMode() && (pointerInfo = MouseInfo.getPointerInfo()) != null) {
                    Point location = pointerInfo.getLocation();
                    SwingUtilities.convertPointFromScreen(location, editor.getContentComponent());
                    ImageOrColorPreviewManager.this.alarm.cancelAllRequests();
                    ImageOrColorPreviewManager.this.alarm.addRequest((Runnable)new PreviewRequest(location, editor, true), 100);
                }
            }
        };
        editor.getContentComponent().addKeyListener(keyListener);
        EDITOR_LISTENER_ADDED.set((UserDataHolder)editor, (Object)keyListener);
    }

    private static boolean isSupportedFile(PsiFile psiFile) {
        for (PsiFile file : psiFile.getViewProvider().getAllFiles()) {
            for (ElementPreviewProvider provider : (ElementPreviewProvider[])Extensions.getExtensions((ExtensionPointName)ElementPreviewProvider.EP_NAME)) {
                if (!provider.isSupportedFile(file)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static Collection<PsiElement> getPsiElementsAt(Point point, Editor editor) {
        Document document;
        if (editor.isDisposed()) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/preview/ImageOrColorPreviewManager", "getPsiElementsAt"));
            }
            return set;
        }
        Project project = editor.getProject();
        if (project == null || project.isDisposed()) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/preview/ImageOrColorPreviewManager", "getPsiElementsAt"));
            }
            return set;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        PsiFile psiFile = documentManager.getPsiFile(document = editor.getDocument());
        if (psiFile == null || psiFile instanceof PsiCompiledElement || !psiFile.isValid()) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/preview/ImageOrColorPreviewManager", "getPsiElementsAt"));
            }
            return set;
        }
        Set<PsiElement> elements = Collections.newSetFromMap(new WeakHashMap());
        int offset = editor.logicalPositionToOffset(editor.xyToLogicalPosition(point));
        if (documentManager.isCommitted(document)) {
            ContainerUtil.addIfNotNull(elements, (Object)InjectedLanguageUtil.findElementAtNoCommit(psiFile, offset));
        }
        for (PsiFile file : psiFile.getViewProvider().getAllFiles()) {
            ContainerUtil.addIfNotNull(elements, (Object)file.findElementAt(offset));
        }
        Set<PsiElement> set = elements;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/preview/ImageOrColorPreviewManager", "getPsiElementsAt"));
        }
        return set;
    }

    public void dispose() {
        this.alarm.cancelAllRequests();
        this.myElements = null;
    }

    public void mouseMoved(@NotNull EditorMouseEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/preview/ImageOrColorPreviewManager", "mouseMoved"));
        }
        Editor editor = event.getEditor();
        if (editor.isOneLineMode()) {
            return;
        }
        this.alarm.cancelAllRequests();
        Point point = event.getMouseEvent().getPoint();
        if (this.myElements == null && event.getMouseEvent().isShiftDown()) {
            this.alarm.addRequest((Runnable)new PreviewRequest(point, editor, false), 100);
        } else {
            Collection<PsiElement> elements = this.myElements;
            if (!((Object)ImageOrColorPreviewManager.getPsiElementsAt(point, editor)).equals(elements)) {
                this.myElements = null;
                for (ElementPreviewProvider provider : (ElementPreviewProvider[])Extensions.getExtensions((ExtensionPointName)ElementPreviewProvider.EP_NAME)) {
                    try {
                        if (elements != null) {
                            for (PsiElement element : elements) {
                                provider.hide(element, editor);
                            }
                            continue;
                        }
                        provider.hide(null, editor);
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        }
    }

    public void mouseDragged(EditorMouseEvent e) {
    }

    private final class PreviewRequest
    implements Runnable {
        private final Point point;
        private final Editor editor;
        private final boolean keyTriggered;

        public PreviewRequest(Point point, Editor editor, boolean keyTriggered) {
            this.point = point;
            this.editor = editor;
            this.keyTriggered = keyTriggered;
        }

        @Override
        public void run() {
            Collection elements = ImageOrColorPreviewManager.getPsiElementsAt(this.point, this.editor);
            if (((Object)elements).equals(ImageOrColorPreviewManager.this.myElements)) {
                return;
            }
            for (PsiElement element : elements) {
                if (element == null || !element.isValid()) {
                    return;
                }
                if (PsiDocumentManager.getInstance((Project)element.getProject()).isUncommited(this.editor.getDocument()) || DumbService.getInstance((Project)element.getProject()).isDumb()) {
                    return;
                }
                for (ElementPreviewProvider provider : (ElementPreviewProvider[])ElementPreviewProvider.EP_NAME.getExtensions()) {
                    if (!provider.isSupportedFile(element.getContainingFile())) continue;
                    try {
                        provider.show(element, this.editor, this.point, this.keyTriggered);
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
            ImageOrColorPreviewManager.this.myElements = elements;
        }
    }
}

