/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.unwrap.Unwrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class AbstractUnwrapper<C extends AbstractContext>
implements Unwrapper {
    private final String myDescription;

    public AbstractUnwrapper(String description) {
        this.myDescription = description;
    }

    @Override
    public abstract boolean isApplicableTo(PsiElement var1);

    @Override
    public void collectElementsToIgnore(PsiElement element, Set<PsiElement> result) {
    }

    @Override
    public String getDescription(PsiElement e) {
        return this.myDescription;
    }

    @Override
    public PsiElement collectAffectedElements(PsiElement e, List<PsiElement> toExtract) {
        try {
            C c = this.createContext();
            this.doUnwrap(e, c);
            toExtract.addAll(((AbstractContext)c).myElementsToExtract);
            return e;
        }
        catch (IncorrectOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public List<PsiElement> unwrap(Editor editor, PsiElement element) throws IncorrectOperationException {
        C c = this.createContext();
        ((AbstractContext)c).myIsEffective = true;
        this.doUnwrap(element, c);
        return ((AbstractContext)c).myElementsToExtract;
    }

    protected abstract void doUnwrap(PsiElement var1, C var2) throws IncorrectOperationException;

    protected abstract C createContext();

    public static abstract class AbstractContext {
        protected final List<PsiElement> myElementsToExtract = new ArrayList<PsiElement>();
        protected boolean myIsEffective;

        public void addElementToExtract(PsiElement e) {
            this.myElementsToExtract.add(e);
        }

        public void extractElement(PsiElement element, PsiElement from) throws IncorrectOperationException {
            this.extract(element, element, from);
        }

        protected abstract boolean isWhiteSpace(PsiElement var1);

        protected void extract(PsiElement first, PsiElement last, PsiElement from) throws IncorrectOperationException {
            while (first != last && this.isWhiteSpace(first)) {
                first = first.getNextSibling();
            }
            while (last != first && this.isWhiteSpace(last)) {
                last = last.getPrevSibling();
            }
            if (first == null || last == null || first == last && this.isWhiteSpace(last)) {
                return;
            }
            PsiElement toExtract = first;
            if (this.myIsEffective) {
                toExtract = from.getParent().addRangeBefore(first, last, from);
            }
            do {
                if (toExtract == null) continue;
                this.addElementToExtract(toExtract);
                toExtract = toExtract.getNextSibling();
            } while ((first = first.getNextSibling()) != null && first.getPrevSibling() != last);
        }

        public void delete(PsiElement e) throws IncorrectOperationException {
            if (this.myIsEffective) {
                e.delete();
            }
        }

        public void deleteExactly(PsiElement e) throws IncorrectOperationException {
            if (this.myIsEffective) {
                e.getParent().deleteChildRange(e, e);
            }
        }
    }
}

