/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.impl.ui.TextViewer;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.actions.XFetchValueActionBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ViewTextAction
extends XFetchValueActionBase {
    @Override
    protected void handle(Project project, String value, XDebuggerTree tree) {
    }

    @Override
    @NotNull
    protected XFetchValueActionBase.ValueCollector createCollector(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/actions/ViewTextAction", "createCollector"));
        }
        XFetchValueActionBase.ValueCollector valueCollector = new XFetchValueActionBase.ValueCollector(XDebuggerTree.getTree(e.getDataContext())){
            MyDialog dialog;
            {
                this.dialog = null;
            }

            @Override
            public void handleInCollector(Project project, String value, XDebuggerTree tree) {
                if (this.dialog == null) {
                    this.dialog = new MyDialog(project);
                    this.dialog.setTitle("View Text");
                    this.dialog.show();
                }
                this.dialog.setText(StringUtil.unquoteString((String)value));
            }
        };
        if (valueCollector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/ViewTextAction", "createCollector"));
        }
        return valueCollector;
    }

    private static class MyDialog
    extends DialogWrapper {
        private final EditorTextField myTextViewer;

        private MyDialog(Project project) {
            super(project, false);
            this.setModal(false);
            this.setCancelButtonText("Close");
            this.setCrossClosesWindow(true);
            this.myTextViewer = new TextViewer(project, true, true);
            this.init();
        }

        public void setText(String text) {
            this.myTextViewer.setText(text);
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{this.getCancelAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/ViewTextAction$MyDialog", "createActions"));
            }
            return actionArray;
        }

        protected String getDimensionServiceKey() {
            return "#com.intellij.debugger.actions.ViewTextAction";
        }

        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)((Object)this.myTextViewer), "Center");
            panel.setPreferredSize((Dimension)JBUI.size((int)300, (int)200));
            return panel;
        }
    }
}

