/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.NamedMethodFilter;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicStepMethodFilter
implements NamedMethodFilter {
    @NotNull
    protected final JVMName myDeclaringClassName;
    @NotNull
    private final String myTargetMethodName;
    @Nullable
    protected final JVMName myTargetMethodSignature;
    private final Range<Integer> myCallingExpressionLines;

    public BasicStepMethodFilter(PsiMethod psiMethod, Range<Integer> callingExpressionLines) {
        this.myDeclaringClassName = JVMNameUtil.getJVMQualifiedName(psiMethod.getContainingClass());
        this.myTargetMethodName = psiMethod.isConstructor() ? "<init>" : psiMethod.getName();
        this.myTargetMethodSignature = JVMNameUtil.getJVMSignature(psiMethod);
        this.myCallingExpressionLines = callingExpressionLines;
    }

    @Override
    @NotNull
    public String getMethodName() {
        String string = this.myTargetMethodName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/BasicStepMethodFilter", "getMethodName"));
        }
        return string;
    }

    @Override
    public boolean locationMatches(DebugProcessImpl process, Location location) throws EvaluateException {
        Method method = location.method();
        if (!this.myTargetMethodName.equals(method.name())) {
            return false;
        }
        if (this.myTargetMethodSignature != null && !BasicStepMethodFilter.signatureMatches(method, this.myTargetMethodSignature.getName(process))) {
            return false;
        }
        return DebuggerUtilsEx.isAssignableFrom(this.myDeclaringClassName.getName(process), location.declaringType());
    }

    private static boolean signatureMatches(Method method, String expectedSignature) throws EvaluateException {
        if (expectedSignature.equals(method.signature())) {
            return true;
        }
        for (Method candidate : method.declaringType().methodsByName(method.name())) {
            if (candidate == method || !candidate.isBridge() || !expectedSignature.equals(candidate.signature())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return this.myCallingExpressionLines;
    }
}

