/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.List;

class LocalVariableEvaluator
implements Evaluator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.LocalVariableEvaluator");
    private final String myLocalVariableName;
    private EvaluationContextImpl myContext;
    private LocalVariableProxyImpl myEvaluatedVariable;
    private final boolean myIsJspSpecial;
    private int myParameterIndex = -1;

    public LocalVariableEvaluator(String localVariableName, boolean isJspSpecial) {
        this.myLocalVariableName = localVariableName;
        this.myIsJspSpecial = isJspSpecial;
    }

    public void setParameterIndex(int parameterIndex) {
        this.myParameterIndex = parameterIndex;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        StackFrameProxyImpl frameProxy = context.getFrameProxy();
        if (frameProxy == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.no.stackframe", (Object[])new Object[0]));
        }
        try {
            ThreadReferenceProxyImpl threadProxy = null;
            int lastFrameIndex = -1;
            while (true) {
                int currentFrameIndex;
                try {
                    LocalVariableProxyImpl local = frameProxy.visibleVariableByName(this.myLocalVariableName);
                    if (local != null) {
                        this.myEvaluatedVariable = local;
                        this.myContext = context;
                        return frameProxy.getValue(local);
                    }
                }
                catch (EvaluateException e) {
                    if (!(e.getCause() instanceof AbsentInformationException)) {
                        throw e;
                    }
                    if (this.myParameterIndex < 0) {
                        throw e;
                    }
                    List<Value> values = frameProxy.getArgumentValues();
                    if (values.isEmpty() || this.myParameterIndex >= values.size()) {
                        throw e;
                    }
                    return values.get(this.myParameterIndex);
                }
                if (!this.myIsJspSpecial) break;
                if (threadProxy == null) {
                    threadProxy = frameProxy.threadProxy();
                    lastFrameIndex = threadProxy.frameCount() - 1;
                }
                if ((currentFrameIndex = frameProxy.getFrameIndex()) >= lastFrameIndex) break;
                frameProxy = threadProxy.frame(currentFrameIndex + 1);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.local.variable.missing", (Object[])new Object[]{this.myLocalVariableName}));
        }
        catch (EvaluateException e) {
            this.myEvaluatedVariable = null;
            this.myContext = null;
            throw e;
        }
    }

    @Override
    public Modifier getModifier() {
        Modifier modifier = null;
        if (this.myEvaluatedVariable != null && this.myContext != null) {
            modifier = new Modifier(){

                public boolean canInspect() {
                    return true;
                }

                public boolean canSetValue() {
                    return true;
                }

                public void setValue(Value value) throws ClassNotLoadedException, InvalidTypeException {
                    StackFrameProxyImpl frameProxy = LocalVariableEvaluator.this.myContext.getFrameProxy();
                    try {
                        assert (frameProxy != null);
                        frameProxy.setValue(LocalVariableEvaluator.this.myEvaluatedVariable, value);
                    }
                    catch (EvaluateException e) {
                        LOG.error((Throwable)e);
                    }
                }

                public Type getExpectedType() throws ClassNotLoadedException {
                    try {
                        return LocalVariableEvaluator.this.myEvaluatedVariable.getType();
                    }
                    catch (EvaluateException e) {
                        LOG.error((Throwable)e);
                        return null;
                    }
                }

                public NodeDescriptorImpl getInspectItem(Project project) {
                    return new LocalVariableDescriptorImpl(project, LocalVariableEvaluator.this.myEvaluatedVariable);
                }
            };
        }
        return modifier;
    }

    public String toString() {
        return this.myLocalVariableName;
    }
}

