/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsCommitAdditionalComponent
implements RefreshableOnComponent {
    private static final Logger log = Logger.getInstance(DvcsCommitAdditionalComponent.class);
    protected final JPanel myPanel;
    protected final JCheckBox myAmend;
    @Nullable
    private String myPreviousMessage;
    @Nullable
    private String myAmendedMessage;
    @NotNull
    protected final CheckinProjectPanel myCheckinPanel;
    @Nullable
    private Map<VirtualFile, String> myMessagesForRoots;

    public DvcsCommitAdditionalComponent(final @NotNull Project project, @NotNull CheckinProjectPanel panel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsCommitAdditionalComponent", "<init>"));
        }
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/dvcs/DvcsCommitAdditionalComponent", "<init>"));
        }
        this.myCheckinPanel = panel;
        this.myPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.anchor = 10;
        c.insets = insets;
        c.weightx = 1.0;
        c.fill = 2;
        this.myAmend = new NonFocusableCheckBox(DvcsBundle.message("commit.amend", new Object[0]));
        this.myAmend.setMnemonic('m');
        this.myAmend.setToolTipText(DvcsBundle.message("commit.amend.tooltip", new Object[0]));
        this.myPreviousMessage = this.myCheckinPanel.getCommitMessage();
        this.myAmend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DvcsCommitAdditionalComponent.this.myAmend.isSelected()) {
                    if (DvcsCommitAdditionalComponent.this.myPreviousMessage.equals(DvcsCommitAdditionalComponent.this.myCheckinPanel.getCommitMessage())) {
                        String message;
                        if (DvcsCommitAdditionalComponent.this.myMessagesForRoots == null) {
                            DvcsCommitAdditionalComponent.this.loadMessagesInModalTask(project);
                        }
                        if (!StringUtil.isEmptyOrSpaces((String)(message = DvcsCommitAdditionalComponent.this.constructAmendedMessage()))) {
                            DvcsCommitAdditionalComponent.this.myAmendedMessage = message;
                            DvcsCommitAdditionalComponent.this.substituteCommitMessage(DvcsCommitAdditionalComponent.this.myAmendedMessage);
                        }
                    }
                } else if (DvcsCommitAdditionalComponent.this.myCheckinPanel.getCommitMessage().equals(DvcsCommitAdditionalComponent.this.myAmendedMessage)) {
                    DvcsCommitAdditionalComponent.this.myCheckinPanel.setCommitMessage(DvcsCommitAdditionalComponent.this.myPreviousMessage);
                }
            }
        });
        this.myPanel.add((Component)this.myAmend, c);
    }

    private String constructAmendedMessage() {
        Set<VirtualFile> selectedRoots = this.getVcsRoots(this.getSelectedFilePaths());
        LinkedHashSet messages = ContainerUtil.newLinkedHashSet();
        if (this.myMessagesForRoots != null) {
            for (VirtualFile root : selectedRoots) {
                String message = this.myMessagesForRoots.get(root);
                if (message == null) continue;
                messages.add(message);
            }
        }
        return DvcsUtil.joinMessagesOrNull(messages);
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void refresh() {
        this.myAmend.setSelected(false);
    }

    private void loadMessagesInModalTask(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsCommitAdditionalComponent", "loadMessagesInModalTask"));
        }
        try {
            this.myMessagesForRoots = (Map)ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<Map<VirtualFile, String>, VcsException>(){

                public Map<VirtualFile, String> compute() throws VcsException {
                    return DvcsCommitAdditionalComponent.this.getLastCommitMessages();
                }
            }, "Reading commit message...", false, project);
        }
        catch (VcsException e) {
            Messages.showErrorDialog((Component)this.getComponent(), (String)("Couldn't load commit message of the commit to amend.\n" + e.getMessage()), (String)"Commit Message not Loaded");
            log.info((Throwable)e);
        }
    }

    private void substituteCommitMessage(@NotNull String newMessage) {
        if (newMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newMessage", "com/intellij/dvcs/DvcsCommitAdditionalComponent", "substituteCommitMessage"));
        }
        this.myPreviousMessage = this.myCheckinPanel.getCommitMessage();
        if (!this.myPreviousMessage.trim().equals(newMessage.trim())) {
            this.myCheckinPanel.setCommitMessage(newMessage);
        }
    }

    @Nullable
    private Map<VirtualFile, String> getLastCommitMessages() throws VcsException {
        HashMap<VirtualFile, String> messagesForRoots = new HashMap<VirtualFile, String>();
        Collection roots = this.myCheckinPanel.getRoots();
        Ref exception = Ref.create();
        for (VirtualFile root : roots) {
            String message = this.getLastCommitMessage(root);
            messagesForRoots.put(root, message);
        }
        if (!exception.isNull()) {
            throw (VcsException)((Object)exception.get());
        }
        return messagesForRoots;
    }

    @NotNull
    private List<FilePath> getSelectedFilePaths() {
        List list = ContainerUtil.map((Collection)this.myCheckinPanel.getFiles(), (Function)new Function<File, FilePath>(){

            public FilePath fun(File file) {
                return new FilePathImpl(file, file.isDirectory());
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsCommitAdditionalComponent", "getSelectedFilePaths"));
        }
        return list;
    }

    @NotNull
    protected abstract Set<VirtualFile> getVcsRoots(@NotNull Collection<FilePath> var1);

    @Nullable
    protected abstract String getLastCommitMessage(@NotNull VirtualFile var1) throws VcsException;

    public boolean isAmend() {
        return this.myAmend.isSelected();
    }
}

