/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.testframework.AbstractTestProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class Filter<T extends AbstractTestProxy> {
    public static final Filter NO_FILTER = new Filter(){

        public boolean shouldAccept(AbstractTestProxy test) {
            return true;
        }
    };
    public static final Filter DEFECT = new Filter(){

        public boolean shouldAccept(AbstractTestProxy test) {
            return test.isDefect();
        }
    };
    public static final Filter IGNORED = new Filter(){

        public boolean shouldAccept(AbstractTestProxy test) {
            return test.isIgnored();
        }
    };
    public static final Filter NOT_PASSED = new Filter(){

        public boolean shouldAccept(AbstractTestProxy test) {
            return !test.isPassed();
        }
    };
    public static final Filter PASSED = new Filter(){

        public boolean shouldAccept(AbstractTestProxy test) {
            return test.isPassed();
        }
    };
    public static final Filter FAILED_OR_INTERRUPTED = new Filter(){

        public boolean shouldAccept(AbstractTestProxy test) {
            return test.isInterrupted() || test.isDefect();
        }
    };
    public static final Filter LEAF = new Filter(){

        public boolean shouldAccept(AbstractTestProxy test) {
            return test.isLeaf();
        }
    };
    public static final Filter DEFECTIVE_LEAF = DEFECT.and(new Filter(){

        public boolean shouldAccept(AbstractTestProxy test) {
            if (test.isLeaf()) {
                return true;
            }
            for (AbstractTestProxy abstractTestProxy : test.getChildren()) {
                if (!abstractTestProxy.isDefect()) continue;
                return false;
            }
            return true;
        }
    });

    protected Filter() {
    }

    public abstract boolean shouldAccept(T var1);

    public List<T> select(List<? extends T> tests) {
        ArrayList<AbstractTestProxy> result = new ArrayList<AbstractTestProxy>();
        for (AbstractTestProxy test : tests) {
            if (!this.shouldAccept(test)) continue;
            result.add(test);
        }
        return result;
    }

    @Nullable
    public T detectIn(Collection<? extends T> collection) {
        for (AbstractTestProxy test : collection) {
            if (!this.shouldAccept(test)) continue;
            return (T)test;
        }
        return null;
    }

    public Filter not() {
        return new NotFilter(this);
    }

    public Filter and(Filter filter) {
        return new AndFilter(this, filter);
    }

    public Filter or(Filter filter) {
        return new OrFilter(this, filter);
    }

    private static class OrFilter
    extends Filter {
        private final Filter myFilter1;
        private final Filter myFilter2;

        public OrFilter(Filter filter1, Filter filter2) {
            this.myFilter1 = filter1;
            this.myFilter2 = filter2;
        }

        public boolean shouldAccept(AbstractTestProxy test) {
            return this.myFilter1.shouldAccept(test) || this.myFilter2.shouldAccept(test);
        }
    }

    private static class NotFilter
    extends Filter {
        private final Filter myFilter;

        public NotFilter(Filter filter) {
            this.myFilter = filter;
        }

        public boolean shouldAccept(AbstractTestProxy test) {
            return !this.myFilter.shouldAccept(test);
        }
    }

    private static class AndFilter
    extends Filter {
        private final Filter myFilter1;
        private final Filter myFilter2;

        public AndFilter(Filter filter1, Filter filter2) {
            this.myFilter1 = filter1;
            this.myFilter2 = filter2;
        }

        public boolean shouldAccept(AbstractTestProxy test) {
            return this.myFilter1.shouldAccept(test) && this.myFilter2.shouldAccept(test);
        }
    }
}

