/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OrderedSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class SmartEnterProcessorWithFixers
extends SmartEnterProcessor {
    protected static final Logger LOG = Logger.getInstance(SmartEnterProcessorWithFixers.class);
    protected static final int MAX_ATTEMPTS = 20;
    protected static final Key<Long> SMART_ENTER_TIMESTAMP = Key.create((String)"smartEnterOriginalTimestamp");
    protected int myFirstErrorOffset = Integer.MAX_VALUE;
    private final List<Fixer<? extends SmartEnterProcessorWithFixers>> myFixers = new ArrayList<Fixer<? extends SmartEnterProcessorWithFixers>>();
    private final List<FixEnterProcessor> myEnterProcessors = new ArrayList<FixEnterProcessor>();

    protected static void plainEnter(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/SmartEnterProcessorWithFixers", "plainEnter"));
        }
        SmartEnterProcessorWithFixers.getEnterHandler().execute(editor, ((EditorEx)editor).getDataContext());
    }

    protected static EditorActionHandler getEnterHandler() {
        return EditorActionManager.getInstance().getActionHandler("EditorStartNewLine");
    }

    protected static boolean isModified(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/SmartEnterProcessorWithFixers", "isModified"));
        }
        Long timestamp = (Long)editor.getUserData(SMART_ENTER_TIMESTAMP);
        assert (timestamp != null);
        return editor.getDocument().getModificationStamp() != timestamp.longValue();
    }

    public boolean doNotStepInto(PsiElement element) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/SmartEnterProcessorWithFixers", "process"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/SmartEnterProcessorWithFixers", "process"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/SmartEnterProcessorWithFixers", "process"));
        }
        Document document = editor.getDocument();
        String textForRollback = document.getText();
        try {
            editor.putUserData(SMART_ENTER_TIMESTAMP, (Object)editor.getDocument().getModificationStamp());
            this.myFirstErrorOffset = Integer.MAX_VALUE;
            this.process(project, editor, psiFile, 0);
        }
        catch (TooManyAttemptsException e) {
            document.replaceString(0, document.getTextLength(), (CharSequence)textForRollback);
        }
        finally {
            editor.putUserData(SMART_ENTER_TIMESTAMP, null);
        }
        return true;
    }

    protected void process(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, int attempt) throws TooManyAttemptsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/SmartEnterProcessorWithFixers", "process"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/SmartEnterProcessorWithFixers", "process"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/SmartEnterProcessorWithFixers", "process"));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.complete.statement");
        if (attempt > 20) {
            throw new TooManyAttemptsException();
        }
        try {
            this.commit(editor);
            if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
                editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            }
            this.myFirstErrorOffset = Integer.MAX_VALUE;
            PsiElement atCaret = this.getStatementAtCaret(editor, file);
            if (atCaret == null) {
                return;
            }
            OrderedSet queue = new OrderedSet();
            this.collectAllElements(atCaret, (OrderedSet<PsiElement>)queue, true);
            queue.add((Object)atCaret);
            for (PsiElement psiElement : queue) {
                for (Fixer<? extends SmartEnterProcessorWithFixers> fixer : this.myFixers) {
                    fixer.apply(editor, this, psiElement);
                    if (LookupManager.getInstance(project).getActiveLookup() != null) {
                        return;
                    }
                    if (!SmartEnterProcessorWithFixers.isUncommited((Project)project) && psiElement.isValid()) continue;
                    this.moveCaretInsideBracesIfAny(editor, file);
                    this.process(project, editor, file, attempt + 1);
                    return;
                }
            }
            this.doEnter(atCaret, file, editor);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    protected void collectAllElements(@NotNull PsiElement element, @NotNull OrderedSet<PsiElement> result, boolean recursive) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/SmartEnterProcessorWithFixers", "collectAllElements"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/SmartEnterProcessorWithFixers", "collectAllElements"));
        }
        result.add(0, (Object)element);
        if (this.doNotStepInto(element)) {
            if (!recursive) {
                return;
            }
            recursive = false;
        }
        this.collectAdditionalElements(element, (List<PsiElement>)result);
        for (PsiElement child : element.getChildren()) {
            this.collectAllElements(child, result, recursive);
        }
    }

    protected void doEnter(@NotNull PsiElement atCaret, @NotNull PsiFile file, @NotNull Editor editor) throws IncorrectOperationException {
        if (atCaret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "atCaret", "com/intellij/lang/SmartEnterProcessorWithFixers", "doEnter"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/SmartEnterProcessorWithFixers", "doEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/SmartEnterProcessorWithFixers", "doEnter"));
        }
        if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
            editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            this.reformat(atCaret);
            return;
        }
        this.reformat(atCaret);
        this.commit(editor);
        for (FixEnterProcessor enterProcessor : this.myEnterProcessors) {
            if (!enterProcessor.doEnter(atCaret, file, editor, SmartEnterProcessorWithFixers.isModified(editor))) continue;
            return;
        }
        if (!SmartEnterProcessorWithFixers.isModified(editor)) {
            SmartEnterProcessorWithFixers.plainEnter(editor);
        } else if (this.myFirstErrorOffset == Integer.MAX_VALUE) {
            editor.getCaretModel().moveToOffset(atCaret.getTextRange().getEndOffset());
        } else {
            editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
        }
    }

    protected void addEnterProcessors(FixEnterProcessor ... processors) {
        ContainerUtil.addAllNotNull(this.myEnterProcessors, (Object[])processors);
    }

    protected void addFixers(Fixer<? extends SmartEnterProcessorWithFixers> ... fixers) {
        ContainerUtil.addAllNotNull(this.myFixers, (Object[])fixers);
    }

    protected void collectAdditionalElements(@NotNull PsiElement element, @NotNull List<PsiElement> result) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/SmartEnterProcessorWithFixers", "collectAdditionalElements"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/SmartEnterProcessorWithFixers", "collectAdditionalElements"));
        }
    }

    protected void moveCaretInsideBracesIfAny(@NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/SmartEnterProcessorWithFixers", "moveCaretInsideBracesIfAny"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/SmartEnterProcessorWithFixers", "moveCaretInsideBracesIfAny"));
        }
    }

    public void commit(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/SmartEnterProcessorWithFixers", "commit"));
        }
        super.commit(editor);
    }

    public static abstract class FixEnterProcessor {
        public abstract boolean doEnter(PsiElement var1, PsiFile var2, @NotNull Editor var3, boolean var4);

        protected void plainEnter(@NotNull Editor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/SmartEnterProcessorWithFixers$FixEnterProcessor", "plainEnter"));
            }
            SmartEnterProcessorWithFixers.plainEnter(editor);
        }
    }

    public static abstract class Fixer<P extends SmartEnterProcessorWithFixers> {
        public abstract void apply(@NotNull Editor var1, @NotNull P var2, @NotNull PsiElement var3) throws IncorrectOperationException;
    }

    public static class TooManyAttemptsException
    extends Exception {
    }
}

