/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.ComponentStoreImpl;
import com.intellij.openapi.components.impl.stores.IApplicationStore;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StateStorageManagerImpl;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NamedJDOMExternalizable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBus;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

class ApplicationStoreImpl
extends ComponentStoreImpl
implements IApplicationStore {
    private static final Logger LOG = Logger.getInstance(ApplicationStoreImpl.class);
    private static final String DEFAULT_STORAGE_SPEC = "$APP_CONFIG$/other.xml";
    private static final String ROOT_ELEMENT_NAME = "application";
    private final ApplicationImpl myApplication;
    private final StateStorageManager myStateStorageManager;
    private String myConfigPath;

    public ApplicationStoreImpl(final ApplicationImpl application, PathMacroManager pathMacroManager) {
        this.myApplication = application;
        this.myStateStorageManager = new StateStorageManagerImpl(pathMacroManager.createTrackingSubstitutor(), ROOT_ELEMENT_NAME, (Disposable)application, (PicoContainer)application.getPicoContainer()){
            private boolean myConfigDirectoryRefreshed;

            @Override
            protected StorageData createStorageData(@NotNull String fileSpec, @NotNull String filePath) {
                if (fileSpec == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/ApplicationStoreImpl$1", "createStorageData"));
                }
                if (filePath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/components/impl/stores/ApplicationStoreImpl$1", "createStorageData"));
                }
                return new StorageData(ApplicationStoreImpl.ROOT_ELEMENT_NAME);
            }

            @Override
            @Nullable
            protected String getOldStorageSpec(@NotNull Object component, @NotNull String componentName, @NotNull StateStorageOperation operation) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/ApplicationStoreImpl$1", "getOldStorageSpec"));
                }
                if (componentName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/ApplicationStoreImpl$1", "getOldStorageSpec"));
                }
                if (operation == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/openapi/components/impl/stores/ApplicationStoreImpl$1", "getOldStorageSpec"));
                }
                if (component instanceof NamedJDOMExternalizable) {
                    return "$APP_CONFIG$/" + ((NamedJDOMExternalizable)component).getExternalFileName() + ".xml";
                }
                return ApplicationStoreImpl.DEFAULT_STORAGE_SPEC;
            }

            @Override
            protected TrackingPathMacroSubstitutor getMacroSubstitutor(@NotNull String fileSpec) {
                if (fileSpec == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/ApplicationStoreImpl$1", "getMacroSubstitutor"));
                }
                if (fileSpec.equals("$APP_CONFIG$/path.macros.xml")) {
                    return null;
                }
                return super.getMacroSubstitutor(fileSpec);
            }

            @Override
            protected boolean isUseXmlProlog() {
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void beforeFileBasedStorageCreate() {
                if (!this.myConfigDirectoryRefreshed && (application.isUnitTestMode() || application.isDispatchThread())) {
                    try {
                        VirtualFile configDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(ApplicationStoreImpl.this.getConfigPath());
                        if (configDir != null) {
                            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{configDir});
                        }
                    }
                    finally {
                        this.myConfigDirectoryRefreshed = true;
                    }
                }
            }
        };
    }

    @Override
    public void load() throws IOException {
        long t = System.currentTimeMillis();
        this.myApplication.init();
        t = System.currentTimeMillis() - t;
        LOG.info(this.myApplication.getComponentConfigurations().length + " application components initialized in " + t + " ms");
    }

    @Override
    public void setOptionsPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/components/impl/stores/ApplicationStoreImpl", "setOptionsPath"));
        }
        this.myStateStorageManager.addMacro("$APP_CONFIG$", path);
    }

    @Override
    public void setConfigPath(@NotNull String configPath) {
        if (configPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPath", "com/intellij/openapi/components/impl/stores/ApplicationStoreImpl", "setConfigPath"));
        }
        this.myStateStorageManager.addMacro("$ROOT_CONFIG$", configPath);
        this.myConfigPath = configPath;
    }

    @Override
    @NotNull
    public String getConfigPath() {
        String configPath = this.myConfigPath;
        if (configPath == null) {
            configPath = PathManager.getConfigPath();
        }
        String string = configPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ApplicationStoreImpl", "getConfigPath"));
        }
        return string;
    }

    @Override
    @NotNull
    protected MessageBus getMessageBus() {
        MessageBus messageBus = this.myApplication.getMessageBus();
        if (messageBus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ApplicationStoreImpl", "getMessageBus"));
        }
        return messageBus;
    }

    @Override
    @NotNull
    public StateStorageManager getStateStorageManager() {
        StateStorageManager stateStorageManager = this.myStateStorageManager;
        if (stateStorageManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ApplicationStoreImpl", "getStateStorageManager"));
        }
        return stateStorageManager;
    }

    @Override
    @Nullable
    protected PathMacroManager getPathMacroManagerForDefaults() {
        return null;
    }
}

