/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.DirectoryInfoImpl;
import com.intellij.openapi.roots.impl.NonProjectDirectoryInfo;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.CollectionQuery;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class RootIndex {
    public static final Comparator<OrderEntry> BY_OWNER_MODULE = new Comparator<OrderEntry>(){

        @Override
        public int compare(OrderEntry o1, OrderEntry o2) {
            String name1 = o1.getOwnerModule().getName();
            String name2 = o2.getOwnerModule().getName();
            return name1.compareTo(name2);
        }
    };
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.RootIndex");
    private final MultiMap<String, VirtualFile> myPackagePrefixRoots;
    private final Map<String, List<VirtualFile>> myDirectoriesByPackageNameCache;
    private final Set<String> myNonExistentPackages;
    private final InfoCache myInfoCache;
    private final List<JpsModuleSourceRootType<?>> myRootTypes;
    private final TObjectIntHashMap<JpsModuleSourceRootType<?>> myRootTypeId;
    @NotNull
    private final Project myProject;
    private volatile Map<VirtualFile, OrderEntry[]> myOrderEntries;
    private final LowMemoryWatcher myLowMemoryWatcher;

    public RootIndex(@NotNull Project project, @NotNull InfoCache cache) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/impl/RootIndex", "<init>"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/openapi/roots/impl/RootIndex", "<init>"));
        }
        this.myPackagePrefixRoots = new MultiMap<String, VirtualFile>(){

            @NotNull
            protected Collection<VirtualFile> createCollection() {
                LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet();
                if (linkedHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex$2", "createCollection"));
                }
                return linkedHashSet;
            }
        };
        this.myDirectoriesByPackageNameCache = ContainerUtil.newConcurrentMap();
        this.myNonExistentPackages = ContainerUtil.newConcurrentSet();
        this.myRootTypes = ContainerUtil.newArrayList();
        this.myRootTypeId = new TObjectIntHashMap();
        this.myLowMemoryWatcher = LowMemoryWatcher.register((Runnable)new Runnable(){

            @Override
            public void run() {
                RootIndex.this.myNonExistentPackages.clear();
            }
        });
        this.myProject = project;
        this.myInfoCache = cache;
        RootInfo info = this.buildRootInfo(project);
        Set<VirtualFile> allRoots = info.getAllRoots();
        for (VirtualFile root : allRoots) {
            Pair<DirectoryInfo, String> pair;
            List<VirtualFile> hierarchy = RootIndex.getHierarchy(root, allRoots, info);
            if (hierarchy != null) {
                pair = RootIndex.calcDirectoryInfo(root, hierarchy, info);
            } else {
                Pair<DirectoryInfo, String> pair2;
                pair = pair2;
                super((Object)NonProjectDirectoryInfo.IGNORED, null);
            }
            Pair<DirectoryInfo, String> pair3 = pair;
            this.cacheInfos(root, root, (DirectoryInfo)pair3.first);
            this.myPackagePrefixRoots.putValue(pair3.second, (Object)root);
        }
    }

    @NotNull
    private RootInfo buildRootInfo(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/impl/RootIndex", "buildRootInfo"));
        }
        RootInfo info = new RootInfo();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            for (VirtualFile virtualFile : moduleRootManager.getContentRoots()) {
                if (info.contentRootOf.containsKey(virtualFile)) continue;
                info.contentRootOf.put(virtualFile, module);
            }
            for (VirtualFile virtualFile : moduleRootManager.getContentEntries()) {
                if (!(virtualFile instanceof ContentEntryImpl) || !((ContentEntryImpl)virtualFile).isDisposed()) {
                    for (VirtualFile virtualFile2 : virtualFile.getExcludeFolderFiles()) {
                        info.excludedFromModule.put(virtualFile2, module);
                    }
                }
                for (VirtualFile virtualFile3 : virtualFile.getSourceFolders()) {
                    VirtualFile sourceFolderRoot = virtualFile3.getFile();
                    if (sourceFolderRoot == null) continue;
                    info.rootTypeId.put((Object)sourceFolderRoot, this.getRootTypeId(virtualFile3.getRootType()));
                    info.classAndSourceRoots.add(sourceFolderRoot);
                    info.sourceRootOf.putValue((Object)sourceFolderRoot, (Object)module);
                    info.packagePrefix.put(sourceFolderRoot, virtualFile3.getPackagePrefix());
                }
            }
            for (VirtualFile virtualFile : moduleRootManager.getOrderEntries()) {
                Library library;
                if (!(virtualFile instanceof LibraryOrSdkOrderEntry)) continue;
                LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)virtualFile;
                VirtualFile[] sourceRoots = entry.getRootFiles(OrderRootType.SOURCES);
                VirtualFile[] classRoots = entry.getRootFiles(OrderRootType.CLASSES);
                for (VirtualFile sourceRoot : sourceRoots) {
                    info.classAndSourceRoots.add(sourceRoot);
                    info.libraryOrSdkSources.add(sourceRoot);
                    info.packagePrefix.put(sourceRoot, "");
                }
                for (VirtualFile classRoot : classRoots) {
                    info.classAndSourceRoots.add(classRoot);
                    info.libraryOrSdkClasses.add(classRoot);
                    info.packagePrefix.put(classRoot, "");
                }
                if (!(virtualFile instanceof LibraryOrderEntry) || (library = ((LibraryOrderEntry)virtualFile).getLibrary()) == null) continue;
                for (VirtualFile root : ((LibraryEx)library).getExcludedRoots()) {
                    info.excludedFromLibraries.putValue((Object)root, (Object)library);
                }
                for (VirtualFile root : sourceRoots) {
                    info.sourceOfLibraries.putValue((Object)root, (Object)library);
                }
                for (VirtualFile root : classRoots) {
                    info.classOfLibraries.putValue((Object)root, (Object)library);
                }
            }
        }
        for (DirectoryIndexExcludePolicy directoryIndexExcludePolicy : (DirectoryIndexExcludePolicy[])Extensions.getExtensions(DirectoryIndexExcludePolicy.EP_NAME, (AreaInstance)project)) {
            Collections.addAll(info.excludedFromProject, directoryIndexExcludePolicy.getExcludeRootsForProject());
        }
        RootInfo rootInfo = info;
        if (rootInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "buildRootInfo"));
        }
        return rootInfo;
    }

    @NotNull
    private Map<VirtualFile, OrderEntry[]> getOrderEntries() {
        HashMap result = this.myOrderEntries;
        if (result != null) {
            HashMap hashMap = result;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getOrderEntries"));
            }
            return hashMap;
        }
        MultiMap libClassRootEntries = MultiMap.createSmart();
        MultiMap libSourceRootEntries = MultiMap.createSmart();
        MultiMap depEntries = MultiMap.createSmart();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
                if (orderEntry instanceof ModuleOrderEntry) {
                    Module depModule = ((ModuleOrderEntry)orderEntry).getModule();
                    if (depModule != null) {
                        VirtualFile[] importedClassRoots;
                        for (VirtualFile importedClassRoot : importedClassRoots = OrderEnumerator.orderEntries((Module)depModule).exportedOnly().recursively().classes().usingCache().getRoots()) {
                            depEntries.putValue((Object)importedClassRoot, (Object)orderEntry);
                        }
                    }
                    for (VirtualFile sourceRoot : orderEntry.getFiles(OrderRootType.SOURCES)) {
                        depEntries.putValue((Object)sourceRoot, (Object)orderEntry);
                    }
                    continue;
                }
                if (!(orderEntry instanceof LibraryOrSdkOrderEntry)) continue;
                LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
                for (VirtualFile sourceRoot : entry.getRootFiles(OrderRootType.SOURCES)) {
                    libSourceRootEntries.putValue((Object)sourceRoot, (Object)orderEntry);
                }
                for (VirtualFile classRoot : entry.getRootFiles(OrderRootType.CLASSES)) {
                    libClassRootEntries.putValue((Object)classRoot, (Object)orderEntry);
                }
            }
        }
        RootInfo rootInfo = this.buildRootInfo(this.myProject);
        result = ContainerUtil.newHashMap();
        Set<VirtualFile> allRoots = rootInfo.getAllRoots();
        Iterator<VirtualFile> i$ = allRoots.iterator();
        while (i$.hasNext()) {
            VirtualFile file;
            List<VirtualFile> hierarchy = RootIndex.getHierarchy(file = i$.next(), allRoots, rootInfo);
            result.put(file, hierarchy == null ? OrderEntry.EMPTY_ARRAY : RootIndex.calcOrderEntries(rootInfo, (MultiMap<VirtualFile, OrderEntry>)depEntries, (MultiMap<VirtualFile, OrderEntry>)libClassRootEntries, (MultiMap<VirtualFile, OrderEntry>)libSourceRootEntries, hierarchy));
        }
        this.myOrderEntries = result;
        HashMap hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getOrderEntries"));
        }
        return hashMap;
    }

    private static OrderEntry[] calcOrderEntries(@NotNull RootInfo info, @NotNull MultiMap<VirtualFile, OrderEntry> depEntries, @NotNull MultiMap<VirtualFile, OrderEntry> libClassRootEntries, @NotNull MultiMap<VirtualFile, OrderEntry> libSourceRootEntries, @NotNull List<VirtualFile> hierarchy) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/roots/impl/RootIndex", "calcOrderEntries"));
        }
        if (depEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "depEntries", "com/intellij/openapi/roots/impl/RootIndex", "calcOrderEntries"));
        }
        if (libClassRootEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libClassRootEntries", "com/intellij/openapi/roots/impl/RootIndex", "calcOrderEntries"));
        }
        if (libSourceRootEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libSourceRootEntries", "com/intellij/openapi/roots/impl/RootIndex", "calcOrderEntries"));
        }
        if (hierarchy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchy", "com/intellij/openapi/roots/impl/RootIndex", "calcOrderEntries"));
        }
        VirtualFile libraryClassRoot = info.findLibraryRootInfo(hierarchy, false);
        VirtualFile librarySourceRoot = info.findLibraryRootInfo(hierarchy, true);
        LinkedHashSet orderEntries = ContainerUtil.newLinkedHashSet();
        orderEntries.addAll(info.getLibraryOrderEntries(hierarchy, libraryClassRoot, librarySourceRoot, (MultiMap<VirtualFile, OrderEntry>)libClassRootEntries, (MultiMap<VirtualFile, OrderEntry>)libSourceRootEntries));
        for (VirtualFile root : hierarchy) {
            orderEntries.addAll(depEntries.get((Object)root));
        }
        VirtualFile moduleContentRoot = info.findModuleRootInfo(hierarchy);
        if (moduleContentRoot != null) {
            ContainerUtil.addIfNotNull((Collection)orderEntries, (Object)info.getModuleSourceEntry(hierarchy, moduleContentRoot, (MultiMap<VirtualFile, OrderEntry>)libClassRootEntries));
        }
        if (orderEntries.isEmpty()) {
            return null;
        }
        OrderEntry[] array = orderEntries.toArray(new OrderEntry[orderEntries.size()]);
        Arrays.sort(array, BY_OWNER_MODULE);
        return array;
    }

    public void checkConsistency() {
        for (VirtualFile file : this.myPackagePrefixRoots.values()) {
            assert (file.exists()) : file.getPath() + " does not exist";
        }
    }

    private int getRootTypeId(@NotNull JpsModuleSourceRootType<?> rootType) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/RootIndex", "getRootTypeId"));
        }
        if (this.myRootTypeId.containsKey(rootType)) {
            return this.myRootTypeId.get(rootType);
        }
        int id = this.myRootTypes.size();
        if (id > 127) {
            LOG.error("Too many different types of module source roots (" + id + ") registered: " + this.myRootTypes);
        }
        this.myRootTypes.add(rootType);
        this.myRootTypeId.put(rootType, id);
        return id;
    }

    @NotNull
    public DirectoryInfo getInfoForFile(@NotNull VirtualFile file) {
        VirtualFile dir;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/RootIndex", "getInfoForFile"));
        }
        if (!file.isValid()) {
            NonProjectDirectoryInfo nonProjectDirectoryInfo = NonProjectDirectoryInfo.INVALID;
            if (nonProjectDirectoryInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getInfoForFile"));
            }
            return nonProjectDirectoryInfo;
        }
        if (!file.isDirectory()) {
            DirectoryInfo info = this.myInfoCache.getCachedInfo(file);
            if (info != null) {
                DirectoryInfo directoryInfo = info;
                if (directoryInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getInfoForFile"));
                }
                return directoryInfo;
            }
            if (RootIndex.isIgnored(file)) {
                NonProjectDirectoryInfo nonProjectDirectoryInfo = NonProjectDirectoryInfo.IGNORED;
                if (nonProjectDirectoryInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getInfoForFile"));
                }
                return nonProjectDirectoryInfo;
            }
            dir = file.getParent();
        } else {
            dir = file;
        }
        int count = 0;
        for (VirtualFile root = dir; root != null; root = root.getParent()) {
            if (++count > 1000) {
                throw new IllegalStateException("Possible loop in tree, started at " + dir.getName());
            }
            DirectoryInfo info = this.myInfoCache.getCachedInfo(root);
            if (info != null) {
                if (!dir.equals(root)) {
                    this.cacheInfos(dir, root, info);
                }
                DirectoryInfo directoryInfo = info;
                if (directoryInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getInfoForFile"));
                }
                return directoryInfo;
            }
            if (!RootIndex.isIgnored(root)) continue;
            DirectoryInfo directoryInfo = this.cacheInfos(dir, root, NonProjectDirectoryInfo.IGNORED);
            if (directoryInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getInfoForFile"));
            }
            return directoryInfo;
        }
        DirectoryInfo directoryInfo = this.cacheInfos(dir, null, NonProjectDirectoryInfo.NOT_UNDER_PROJECT_ROOTS);
        if (directoryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getInfoForFile"));
        }
        return directoryInfo;
    }

    @NotNull
    private DirectoryInfo cacheInfos(VirtualFile dir, @Nullable VirtualFile stopAt, @NotNull DirectoryInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/roots/impl/RootIndex", "cacheInfos"));
        }
        while (dir != null) {
            this.myInfoCache.cacheInfo(dir, info);
            if (dir.equals(stopAt)) break;
            dir = dir.getParent();
        }
        DirectoryInfo directoryInfo = info;
        if (directoryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "cacheInfos"));
        }
        return directoryInfo;
    }

    @NotNull
    public Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/openapi/roots/impl/RootIndex", "getDirectoriesByPackageName"));
        }
        List result = this.myDirectoriesByPackageNameCache.get(packageName);
        if (result == null) {
            if (this.myNonExistentPackages.contains(packageName)) {
                Query query = EmptyQuery.getEmptyQuery();
                if (query == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getDirectoriesByPackageName"));
                }
                return query;
            }
            result = ContainerUtil.newSmartList();
            if (StringUtil.isNotEmpty((String)packageName) && !StringUtil.startsWithChar((CharSequence)packageName, (char)'.')) {
                int i = packageName.lastIndexOf(46);
                while (true) {
                    String shortName = packageName.substring(i + 1);
                    String parentPackage = i > 0 ? packageName.substring(0, i) : "";
                    for (VirtualFile parentDir : this.getDirectoriesByPackageName(parentPackage, true)) {
                        VirtualFile child = parentDir.findChild(shortName);
                        if (child == null || !child.isDirectory() || !this.getInfoForFile(child).isInProject() || !packageName.equals(this.getPackageName(child))) continue;
                        result.add(child);
                    }
                    if (i < 0) break;
                    i = packageName.lastIndexOf(46, i - 1);
                }
            }
            for (VirtualFile file : this.myPackagePrefixRoots.get((Object)packageName)) {
                if (!file.isDirectory()) continue;
                result.add(file);
            }
            if (!result.isEmpty()) {
                this.myDirectoriesByPackageNameCache.put(packageName, result);
            } else {
                this.myNonExistentPackages.add(packageName);
            }
        }
        if (!includeLibrarySources) {
            result = ContainerUtil.filter((Collection)result, (Condition)new Condition<VirtualFile>(){

                public boolean value(VirtualFile file) {
                    DirectoryInfo info = RootIndex.this.getInfoForFile(file);
                    return info.isInProject() && (!info.isInLibrarySource() || info.isInModuleSource() || info.hasLibraryClassRoot());
                }
            });
        }
        CollectionQuery collectionQuery = new CollectionQuery(result);
        if (collectionQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getDirectoriesByPackageName"));
        }
        return collectionQuery;
    }

    @Nullable
    public String getPackageName(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/roots/impl/RootIndex", "getPackageName"));
        }
        if (dir.isDirectory()) {
            if (RootIndex.isIgnored(dir)) {
                return null;
            }
            for (Map.Entry entry : this.myPackagePrefixRoots.entrySet()) {
                if (!((Collection)entry.getValue()).contains(dir)) continue;
                return (String)entry.getKey();
            }
            VirtualFile parent = dir.getParent();
            if (parent != null) {
                return RootIndex.getPackageNameForSubdir(this.getPackageName(parent), dir.getName());
            }
        }
        return null;
    }

    @Nullable
    protected static String getPackageNameForSubdir(String parentPackageName, @NotNull String subdirName) {
        if (subdirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subdirName", "com/intellij/openapi/roots/impl/RootIndex", "getPackageNameForSubdir"));
        }
        if (parentPackageName == null) {
            return null;
        }
        return parentPackageName.isEmpty() ? subdirName : parentPackageName + "." + subdirName;
    }

    @Nullable
    public JpsModuleSourceRootType<?> getSourceRootType(@NotNull DirectoryInfo directoryInfo) {
        if (directoryInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryInfo", "com/intellij/openapi/roots/impl/RootIndex", "getSourceRootType"));
        }
        return this.myRootTypes.get(directoryInfo.getSourceRootTypeId());
    }

    boolean resetOnEvents(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/roots/impl/RootIndex", "resetOnEvents"));
        }
        for (VFileEvent vFileEvent : events) {
            VirtualFile file = vFileEvent.getFile();
            if (file != null && !file.isDirectory()) continue;
            return true;
        }
        return false;
    }

    @Nullable(value="returns null only if dir is under ignored folder")
    private static List<VirtualFile> getHierarchy(VirtualFile dir, @NotNull Set<VirtualFile> allRoots, @NotNull RootInfo info) {
        if (allRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allRoots", "com/intellij/openapi/roots/impl/RootIndex", "getHierarchy"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/roots/impl/RootIndex", "getHierarchy"));
        }
        ArrayList hierarchy = ContainerUtil.newArrayList();
        boolean hasContentRoots = false;
        while (dir != null) {
            if (!(hasContentRoots |= info.contentRootOf.get(dir) != null) && RootIndex.isIgnored(dir)) {
                return null;
            }
            if (allRoots.contains(dir)) {
                hierarchy.add(dir);
            }
            dir = dir.getParent();
        }
        return hierarchy;
    }

    private static boolean isIgnored(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/roots/impl/RootIndex", "isIgnored"));
        }
        return FileTypeRegistry.getInstance().isFileIgnored(dir);
    }

    @NotNull
    private static Pair<DirectoryInfo, String> calcDirectoryInfo(@NotNull VirtualFile root, @NotNull List<VirtualFile> hierarchy, @NotNull RootInfo info) {
        VirtualFile nearestContentRoot;
        boolean inProject;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/roots/impl/RootIndex", "calcDirectoryInfo"));
        }
        if (hierarchy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchy", "com/intellij/openapi/roots/impl/RootIndex", "calcDirectoryInfo"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/roots/impl/RootIndex", "calcDirectoryInfo"));
        }
        VirtualFile moduleContentRoot = info.findModuleRootInfo(hierarchy);
        VirtualFile libraryClassRoot = info.findLibraryRootInfo(hierarchy, false);
        VirtualFile librarySourceRoot = info.findLibraryRootInfo(hierarchy, true);
        boolean bl = inProject = moduleContentRoot != null || libraryClassRoot != null || librarySourceRoot != null;
        if (inProject) {
            nearestContentRoot = moduleContentRoot;
        } else {
            nearestContentRoot = info.findNearestContentRootForExcluded(hierarchy);
            if (nearestContentRoot == null) {
                Pair pair = new Pair((Object)NonProjectDirectoryInfo.EXCLUDED, null);
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "calcDirectoryInfo"));
                }
                return pair;
            }
        }
        VirtualFile sourceRoot = info.findPackageRootInfo(hierarchy, moduleContentRoot, null, librarySourceRoot);
        VirtualFile moduleSourceRoot = info.findPackageRootInfo(hierarchy, moduleContentRoot, null, null);
        boolean inModuleSources = moduleSourceRoot != null;
        boolean inLibrarySource = librarySourceRoot != null;
        int typeId = moduleSourceRoot != null ? info.rootTypeId.get((Object)moduleSourceRoot) : 0;
        Module module = info.contentRootOf.get(nearestContentRoot);
        DirectoryInfoImpl directoryInfo = new DirectoryInfoImpl(root, module, nearestContentRoot, sourceRoot, libraryClassRoot, inModuleSources, inLibrarySource, !inProject, typeId);
        String packagePrefix = info.calcPackagePrefix(root, hierarchy, moduleContentRoot, libraryClassRoot, librarySourceRoot);
        Pair pair = Pair.create((Object)directoryInfo, (Object)packagePrefix);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "calcDirectoryInfo"));
        }
        return pair;
    }

    @NotNull
    public OrderEntry[] getOrderEntries(@NotNull DirectoryInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/roots/impl/RootIndex", "getOrderEntries"));
        }
        if (!(info instanceof DirectoryInfoImpl)) {
            if (OrderEntry.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getOrderEntries"));
            }
            return OrderEntry.EMPTY_ARRAY;
        }
        OrderEntry[] entries = this.getOrderEntries().get(((DirectoryInfoImpl)info).getRoot());
        OrderEntry[] orderEntryArray = entries == null ? OrderEntry.EMPTY_ARRAY : entries;
        if (orderEntryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getOrderEntries"));
        }
        return orderEntryArray;
    }

    public static interface InfoCache {
        @Nullable
        public DirectoryInfo getCachedInfo(@NotNull VirtualFile var1);

        public void cacheInfo(@NotNull VirtualFile var1, @NotNull DirectoryInfo var2);
    }

    private static class RootInfo {
        @NotNull
        final LinkedHashSet<VirtualFile> classAndSourceRoots = ContainerUtil.newLinkedHashSet();
        @NotNull
        final Set<VirtualFile> libraryOrSdkSources = ContainerUtil.newHashSet();
        @NotNull
        final Set<VirtualFile> libraryOrSdkClasses = ContainerUtil.newHashSet();
        @NotNull
        final Map<VirtualFile, Module> contentRootOf = ContainerUtil.newHashMap();
        @NotNull
        final MultiMap<VirtualFile, Module> sourceRootOf = MultiMap.createSet();
        @NotNull
        final TObjectIntHashMap<VirtualFile> rootTypeId = new TObjectIntHashMap();
        @NotNull
        final MultiMap<VirtualFile, Library> excludedFromLibraries = MultiMap.createSmart();
        @NotNull
        final MultiMap<VirtualFile, Library> classOfLibraries = MultiMap.createSmart();
        @NotNull
        final MultiMap<VirtualFile, Library> sourceOfLibraries = MultiMap.createSmart();
        @NotNull
        final Set<VirtualFile> excludedFromProject = ContainerUtil.newHashSet();
        @NotNull
        final Map<VirtualFile, Module> excludedFromModule = ContainerUtil.newHashMap();
        @NotNull
        final Map<VirtualFile, String> packagePrefix = ContainerUtil.newHashMap();

        private RootInfo() {
        }

        @NotNull
        Set<VirtualFile> getAllRoots() {
            LinkedHashSet result = ContainerUtil.newLinkedHashSet();
            result.addAll(this.classAndSourceRoots);
            result.addAll(this.contentRootOf.keySet());
            result.addAll(this.excludedFromLibraries.keySet());
            result.addAll(this.excludedFromModule.keySet());
            result.addAll(this.excludedFromProject);
            LinkedHashSet linkedHashSet = result;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "getAllRoots"));
            }
            return linkedHashSet;
        }

        @Nullable
        private VirtualFile findModuleRootInfo(@NotNull List<VirtualFile> hierarchy) {
            if (hierarchy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchy", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "findModuleRootInfo"));
            }
            for (VirtualFile root : hierarchy) {
                Module module = this.contentRootOf.get(root);
                Module excludedFrom = this.excludedFromModule.get(root);
                if (module != null && excludedFrom != module) {
                    return root;
                }
                if (excludedFrom == null && !this.excludedFromProject.contains(root)) continue;
                return null;
            }
            return null;
        }

        @Nullable
        private VirtualFile findNearestContentRootForExcluded(@NotNull List<VirtualFile> hierarchy) {
            if (hierarchy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchy", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "findNearestContentRootForExcluded"));
            }
            for (VirtualFile root : hierarchy) {
                if (!this.contentRootOf.containsKey(root)) continue;
                return root;
            }
            return null;
        }

        @Nullable
        private VirtualFile findLibraryRootInfo(@NotNull List<VirtualFile> hierarchy, boolean source) {
            if (hierarchy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchy", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "findLibraryRootInfo"));
            }
            HashSet librariesToIgnore = ContainerUtil.newHashSet();
            for (VirtualFile root : hierarchy) {
                librariesToIgnore.addAll(this.excludedFromLibraries.get((Object)root));
                if (source && this.libraryOrSdkSources.contains(root) && (!this.sourceOfLibraries.containsKey((Object)root) || !librariesToIgnore.containsAll(this.sourceOfLibraries.get((Object)root)))) {
                    return root;
                }
                if (source || !this.libraryOrSdkClasses.contains(root) || this.classOfLibraries.containsKey((Object)root) && librariesToIgnore.containsAll(this.classOfLibraries.get((Object)root))) continue;
                return root;
            }
            return null;
        }

        private String calcPackagePrefix(@NotNull VirtualFile root, @NotNull List<VirtualFile> hierarchy, VirtualFile moduleContentRoot, VirtualFile libraryClassRoot, VirtualFile librarySourceRoot) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "calcPackagePrefix"));
            }
            if (hierarchy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchy", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "calcPackagePrefix"));
            }
            VirtualFile packageRoot = this.findPackageRootInfo(hierarchy, moduleContentRoot, libraryClassRoot, librarySourceRoot);
            String prefix = this.packagePrefix.get(packageRoot);
            if (prefix != null && !root.equals(packageRoot)) {
                assert (packageRoot != null);
                String relative = VfsUtilCore.getRelativePath((VirtualFile)root, (VirtualFile)packageRoot, (char)'.');
                prefix = StringUtil.isEmpty((String)prefix) ? relative : prefix + '.' + relative;
            }
            return prefix;
        }

        @Nullable
        private VirtualFile findPackageRootInfo(@NotNull List<VirtualFile> hierarchy, VirtualFile moduleContentRoot, VirtualFile libraryClassRoot, VirtualFile librarySourceRoot) {
            if (hierarchy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchy", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "findPackageRootInfo"));
            }
            for (VirtualFile root : hierarchy) {
                if (moduleContentRoot != null && this.sourceRootOf.get((Object)root).contains(this.contentRootOf.get(moduleContentRoot)) && librarySourceRoot == null) {
                    return root;
                }
                if (root.equals(libraryClassRoot) || root.equals(librarySourceRoot)) {
                    return root;
                }
                if (!root.equals(moduleContentRoot) || this.sourceRootOf.containsKey((Object)root) || librarySourceRoot != null || libraryClassRoot != null) continue;
                return null;
            }
            return null;
        }

        @NotNull
        private LinkedHashSet<OrderEntry> getLibraryOrderEntries(@NotNull List<VirtualFile> hierarchy, @Nullable VirtualFile libraryClassRoot, @Nullable VirtualFile librarySourceRoot, @NotNull MultiMap<VirtualFile, OrderEntry> libClassRootEntries, @NotNull MultiMap<VirtualFile, OrderEntry> libSourceRootEntries) {
            if (hierarchy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchy", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "getLibraryOrderEntries"));
            }
            if (libClassRootEntries == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libClassRootEntries", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "getLibraryOrderEntries"));
            }
            if (libSourceRootEntries == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libSourceRootEntries", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "getLibraryOrderEntries"));
            }
            LinkedHashSet orderEntries = ContainerUtil.newLinkedHashSet();
            for (VirtualFile root : hierarchy) {
                if (root.equals(libraryClassRoot) && !this.sourceRootOf.containsKey((Object)root)) {
                    orderEntries.addAll(libClassRootEntries.get((Object)root));
                }
                if (root.equals(librarySourceRoot) && libraryClassRoot == null) {
                    orderEntries.addAll(libSourceRootEntries.get((Object)root));
                }
                if (!libClassRootEntries.containsKey((Object)root) && (!this.sourceRootOf.containsKey((Object)root) || librarySourceRoot != null)) continue;
                break;
            }
            LinkedHashSet linkedHashSet = orderEntries;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "getLibraryOrderEntries"));
            }
            return linkedHashSet;
        }

        @Nullable
        private ModuleSourceOrderEntry getModuleSourceEntry(@NotNull List<VirtualFile> hierarchy, @NotNull VirtualFile moduleContentRoot, @NotNull MultiMap<VirtualFile, OrderEntry> libClassRootEntries) {
            if (hierarchy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchy", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "getModuleSourceEntry"));
            }
            if (moduleContentRoot == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleContentRoot", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "getModuleSourceEntry"));
            }
            if (libClassRootEntries == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libClassRootEntries", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "getModuleSourceEntry"));
            }
            Module module = this.contentRootOf.get(moduleContentRoot);
            for (VirtualFile root : hierarchy) {
                if (this.sourceRootOf.get((Object)root).contains(module)) {
                    return (ModuleSourceOrderEntry)ContainerUtil.findInstance((Object[])ModuleRootManager.getInstance((Module)module).getOrderEntries(), ModuleSourceOrderEntry.class);
                }
                if (!libClassRootEntries.containsKey((Object)root)) continue;
                return null;
            }
            return null;
        }
    }
}

