/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LabeledJavaBlock
extends AbstractJavaBlock {
    public LabeledJavaBlock(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings) {
        super(node, wrap, alignment, indent, settings, javaSettings);
    }

    @Override
    protected List<Block> buildChildren() {
        ArrayList<Block> result = new ArrayList<Block>();
        Indent currentIndent = this.getLabelIndent();
        Wrap currentWrap = null;
        for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (FormatterUtil.containsWhiteSpacesOnly(child) || child.getTextLength() <= 0) continue;
            result.add(LabeledJavaBlock.createJavaBlock(child, this.mySettings, this.myJavaSettings, currentIndent, currentWrap, AlignmentStrategy.getNullStrategy()));
            if (child.getElementType() != JavaTokenType.COLON) continue;
            currentIndent = Indent.getNoneIndent();
            currentWrap = Wrap.createWrap((WrapType)WrapType.ALWAYS, (boolean)true);
        }
        return result;
    }

    private Indent getLabelIndent() {
        if (this.mySettings.getRootSettings().getIndentOptions((FileType)StdFileTypes.JAVA).LABEL_INDENT_ABSOLUTE) {
            return Indent.getAbsoluteLabelIndent();
        }
        return Indent.getLabelIndent();
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/LabeledJavaBlock", "getChildAttributes"));
        }
        return childAttributes;
    }
}

