/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ProjectTopics;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.idea.IdeaLogger;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.DocumentCommitThread;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.testFramework.CompositeException;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class LightPlatformTestCase
extends UsefulTestCase
implements DataProvider {
    @NonNls
    public static final String PROFILE = "Configurable";
    @NonNls
    private static final String LIGHT_PROJECT_MARK = "Light project: ";
    private static IdeaTestApplication ourApplication;
    protected static Project ourProject;
    private static Module ourModule;
    private static PsiManager ourPsiManager;
    private static boolean ourAssertionsInTestDetected;
    private static VirtualFile ourSourceRoot;
    private static TestCase ourTestCase;
    public static Thread ourTestThread;
    private static LightProjectDescriptor ourProjectDescriptor;
    private static boolean ourHaveShutdownHook;
    private final Map<String, InspectionToolWrapper> myAvailableInspectionTools = new THashMap();
    private ThreadTracker myThreadTracker;

    public static Project getProject() {
        return ourProject;
    }

    public static Module getModule() {
        return ourModule;
    }

    public static PsiManager getPsiManager() {
        if (ourPsiManager == null) {
            ourPsiManager = PsiManager.getInstance((Project)ourProject);
        }
        return ourPsiManager;
    }

    public static IdeaTestApplication initApplication() {
        ourApplication = IdeaTestApplication.getInstance(null);
        return ourApplication;
    }

    public static void disposeApplication() {
        if (ourApplication != null) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    Disposer.dispose((Disposable)ourApplication);
                }
            });
            ourApplication = null;
        }
    }

    public static IdeaTestApplication getApplication() {
        return ourApplication;
    }

    public static void reportTestExecutionStatistics() {
        System.out.println("----- TEST STATISTICS -----");
        UsefulTestCase.logSetupTeardownCosts();
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.appInstancesCreated' value='%d']", MockApplication.INSTANCES_CREATED));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.projectInstancesCreated' value='%d']", ProjectManagerImpl.TEST_PROJECTS_CREATED));
        long totalGcTime = 0L;
        for (GarbageCollectorMXBean mxBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            totalGcTime += mxBean.getCollectionTime();
        }
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.gcTimeMs' value='%d']", totalGcTime));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.classesLoaded' value='%d']", ManagementFactory.getClassLoadingMXBean().getTotalLoadedClassCount()));
    }

    protected void resetAllFields() {
        this.resetClassFields(((Object)((Object)this)).getClass());
    }

    private void resetClassFields(Class<?> aClass) {
        try {
            UsefulTestCase.clearDeclaredFields((Object)this, aClass);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (aClass == LightPlatformTestCase.class) {
            return;
        }
        this.resetClassFields(aClass.getSuperclass());
    }

    private static void cleanPersistedVFSContent() {
        ((PersistentFSImpl)PersistentFS.getInstance()).cleanPersistedContents();
    }

    public static boolean isLight(Project project) {
        String creationPlace = (String)project.getUserData(CREATION_PLACE);
        return creationPlace != null && StringUtil.startsWith((CharSequence)creationPlace, (CharSequence)LIGHT_PROJECT_MARK);
    }

    private static void initProject(final @NotNull LightProjectDescriptor descriptor) throws Exception {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/testFramework/LightPlatformTestCase", "initProject"));
        }
        ourProjectDescriptor = descriptor;
        final File projectFile = FileUtil.createTempFile((String)"light_temp_", (String)".ipr");
        new WriteCommandAction.Simple(null, new PsiFile[0]){

            protected void run() throws Throwable {
                if (ourProject != null) {
                    LightPlatformTestCase.closeAndDeleteProject();
                } else {
                    LightPlatformTestCase.cleanPersistedVFSContent();
                }
                LocalFileSystem.getInstance().refreshAndFindFileByIoFile(projectFile);
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                new Throwable(projectFile.getPath()).printStackTrace(new PrintStream(buffer));
                ourProject = PlatformTestCase.createProject(projectFile, LightPlatformTestCase.LIGHT_PROJECT_MARK + buffer.toString());
                UsefulTestCase.ourPathToKeep = projectFile.getPath();
                if (!ourHaveShutdownHook) {
                    ourHaveShutdownHook = true;
                    LightPlatformTestCase.registerShutdownHook();
                }
                ourPsiManager = null;
                ourModule = LightPlatformTestCase.createMainModule(descriptor.getModuleType());
                VirtualFile dummyRoot = VirtualFileManager.getInstance().findFileByUrl("temp:///");
                assert (dummyRoot != null);
                dummyRoot.refresh(false, false);
                try {
                    ourSourceRoot = dummyRoot.createChildDirectory((Object)this, "src");
                    this.cleanSourceRoot();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                FileBasedIndex.getInstance().registerIndexableSet(new IndexableFileSet(){

                    public boolean isInSet(@NotNull VirtualFile file) {
                        if (file == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/LightPlatformTestCase$2$1", "isInSet"));
                        }
                        return ourSourceRoot != null && file.getFileSystem() == ourSourceRoot.getFileSystem() && ourProject != null && ourProject.isOpen();
                    }

                    public void iterateIndexableFilesIn(@NotNull VirtualFile file, final @NotNull ContentIterator iterator) {
                        if (file == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/LightPlatformTestCase$2$1", "iterateIndexableFilesIn"));
                        }
                        if (iterator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/testFramework/LightPlatformTestCase$2$1", "iterateIndexableFilesIn"));
                        }
                        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                            public boolean visitFile(@NotNull VirtualFile file) {
                                if (file == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/LightPlatformTestCase$2$1$1", "visitFile"));
                                }
                                iterator.processFile(file);
                                return true;
                            }
                        });
                    }
                }, null);
                ModuleRootModificationUtil.updateModel((Module)ourModule, (Consumer)new Consumer<ModifiableRootModel>(){

                    public void consume(ModifiableRootModel model) {
                        if (descriptor.getSdk() != null) {
                            model.setSdk(descriptor.getSdk());
                        }
                        ContentEntry contentEntry = model.addContentEntry(ourSourceRoot);
                        contentEntry.addSourceFolder(ourSourceRoot, false);
                        descriptor.configureModule(ourModule, model, contentEntry);
                    }
                });
                MessageBusConnection connection = ourProject.getMessageBus().connect();
                connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

                    public void beforeRootsChange(ModuleRootEvent event) {
                    }
                });
                connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleAdapter(){

                    public void moduleAdded(Project project, Module module) {
                        TestCase.fail((String)"Adding modules is not permitted in LightIdeaTestCase.");
                    }
                });
                StartupManagerImpl startupManager = (StartupManagerImpl)StartupManager.getInstance((Project)ourProject);
                startupManager.runStartupActivities();
                startupManager.startCacheUpdate();
            }

            private void cleanSourceRoot() throws IOException {
                TempFileSystem tempFs = (TempFileSystem)ourSourceRoot.getFileSystem();
                for (VirtualFile child : ourSourceRoot.getChildren()) {
                    if (!tempFs.exists(child)) {
                        tempFs.createChildFile((Object)this, ourSourceRoot, child.getName());
                    }
                    child.delete((Object)this);
                }
            }
        }.execute().throwException();
        ((VirtualFilePointerManagerImpl)VirtualFilePointerManager.getInstance()).storePointers();
    }

    protected static Module createMainModule(final ModuleType moduleType) {
        return (Module)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Module>(){

            public Module compute() {
                return ModuleManager.getInstance((Project)ourProject).newModule("light_idea_test_case.iml", moduleType.getId());
            }
        });
    }

    public static VirtualFile getSourceRoot() {
        return ourSourceRoot;
    }

    @Override
    protected void setUp() throws Exception {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    LightPlatformTestCase.super.setUp();
                    LightPlatformTestCase.initApplication();
                    ApplicationInfoImpl.setInPerformanceTest(LightPlatformTestCase.this.isPerformanceTest());
                    ourApplication.setDataProvider(LightPlatformTestCase.this);
                    LightPlatformTestCase.doSetup(new SimpleLightProjectDescriptor(LightPlatformTestCase.this.getModuleType(), LightPlatformTestCase.this.getProjectJDK()), LightPlatformTestCase.this.configureLocalInspectionTools(), LightPlatformTestCase.this.myAvailableInspectionTools);
                    InjectedLanguageManagerImpl.pushInjectors(LightPlatformTestCase.getProject());
                    LightPlatformTestCase.this.storeSettings();
                    LightPlatformTestCase.this.myThreadTracker = new ThreadTracker();
                    ModuleRootManager.getInstance((Module)ourModule).orderEntries().getAllLibrariesAndSdkClassesRoots();
                    VirtualFilePointerManagerImpl filePointerManager = (VirtualFilePointerManagerImpl)VirtualFilePointerManager.getInstance();
                    filePointerManager.storePointers();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static void doSetup(@NotNull LightProjectDescriptor descriptor, @NotNull LocalInspectionTool[] localInspectionTools, final @NotNull Map<String, InspectionToolWrapper> availableInspectionTools) throws Exception {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/testFramework/LightPlatformTestCase", "doSetup"));
        }
        if (localInspectionTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localInspectionTools", "com/intellij/testFramework/LightPlatformTestCase", "doSetup"));
        }
        if (availableInspectionTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "availableInspectionTools", "com/intellij/testFramework/LightPlatformTestCase", "doSetup"));
        }
        LightPlatformTestCase.assertNull((String)("Previous test " + ourTestCase + " hasn't called tearDown(). Probably overridden without super call."), (Object)ourTestCase);
        IdeaLogger.ourErrorsOccurred = null;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (ourProject == null || ourProjectDescriptor == null || !ourProjectDescriptor.equals(descriptor)) {
            LightPlatformTestCase.initProject(descriptor);
        }
        ((ProjectImpl)ourProject).setTemporarilyDisposed(false);
        ProjectManagerEx projectManagerEx = ProjectManagerEx.getInstanceEx();
        projectManagerEx.openTestProject(ourProject);
        LightPlatformTestCase.clearUncommittedDocuments(LightPlatformTestCase.getProject());
        for (LocalInspectionTool tool : localInspectionTools) {
            LightPlatformTestCase.enableInspectionTool(availableInspectionTools, new LocalInspectionToolWrapper(tool));
        }
        InspectionProfileImpl profile = new InspectionProfileImpl(PROFILE){

            @Override
            @NotNull
            public InspectionToolWrapper[] getInspectionTools(PsiElement element) {
                Collection tools = availableInspectionTools.values();
                InspectionToolWrapper[] inspectionToolWrapperArray = tools.toArray(new InspectionToolWrapper[tools.size()]);
                if (inspectionToolWrapperArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformTestCase$5", "getInspectionTools"));
                }
                return inspectionToolWrapperArray;
            }

            @Override
            @NotNull
            public List<Tools> getAllEnabledInspectionTools(Project project) {
                ArrayList<Tools> result = new ArrayList<Tools>();
                for (InspectionToolWrapper toolWrapper : this.getInspectionTools(null)) {
                    result.add(new ToolsImpl(toolWrapper, toolWrapper.getDefaultLevel(), true));
                }
                ArrayList<Tools> arrayList = result;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformTestCase$5", "getAllEnabledInspectionTools"));
                }
                return arrayList;
            }

            @Override
            public boolean isToolEnabled(HighlightDisplayKey key, PsiElement element) {
                return key != null && availableInspectionTools.containsKey(key.toString());
            }

            @Override
            public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey key, PsiElement element) {
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/testFramework/LightPlatformTestCase$5", "getErrorLevel"));
                }
                InspectionToolWrapper toolWrapper = (InspectionToolWrapper)availableInspectionTools.get(key.toString());
                return toolWrapper == null ? HighlightDisplayLevel.WARNING : toolWrapper.getDefaultLevel();
            }

            @Override
            public InspectionToolWrapper getInspectionTool(@NotNull String shortName, @NotNull PsiElement element) {
                if (shortName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/testFramework/LightPlatformTestCase$5", "getInspectionTool"));
                }
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testFramework/LightPlatformTestCase$5", "getInspectionTool"));
                }
                return (InspectionToolWrapper)availableInspectionTools.get(shortName);
            }

            @Override
            public InspectionToolWrapper getToolById(@NotNull String id, @NotNull PsiElement element) {
                if (id == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/testFramework/LightPlatformTestCase$5", "getToolById"));
                }
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testFramework/LightPlatformTestCase$5", "getToolById"));
                }
                return (InspectionToolWrapper)availableInspectionTools.get(id);
            }
        };
        InspectionProfileManager inspectionProfileManager = InspectionProfileManager.getInstance();
        inspectionProfileManager.addProfile(profile);
        inspectionProfileManager.setRootProfile(profile.getName());
        InspectionProjectProfileManager.getInstance(LightPlatformTestCase.getProject()).updateProfile(profile);
        InspectionProjectProfileManager.getInstance(LightPlatformTestCase.getProject()).setProjectProfile(profile.getName());
        LightPlatformTestCase.assertFalse((boolean)LightPlatformTestCase.getPsiManager().isDisposed());
        Boolean passed = null;
        try {
            passed = StartupManagerEx.getInstanceEx(LightPlatformTestCase.getProject()).startupActivityPassed();
        }
        catch (Exception e) {
            // empty catch block
        }
        LightPlatformTestCase.assertTrue((String)("open: " + LightPlatformTestCase.getProject().isOpen() + "; disposed:" + LightPlatformTestCase.getProject().isDisposed() + "; startup passed:" + passed + "; all open projects: " + Arrays.asList(ProjectManager.getInstance().getOpenProjects())), (boolean)LightPlatformTestCase.getProject().isInitialized());
        CodeStyleSettingsManager.getInstance((Project)LightPlatformTestCase.getProject()).setTemporarySettings(new CodeStyleSettings());
        final FileDocumentManager manager = FileDocumentManager.getInstance();
        if (manager instanceof FileDocumentManagerImpl) {
            Document[] unsavedDocuments = manager.getUnsavedDocuments();
            manager.saveAllDocuments();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    ((FileDocumentManagerImpl)manager).dropAllUnsavedDocuments();
                }
            });
            LightPlatformTestCase.assertEmpty("There are unsaved documents", Arrays.asList(unsavedDocuments));
        }
        UIUtil.dispatchAllInvocationEvents();
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
    }

    protected void enableInspectionTools(Class<?> ... classes) {
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/testFramework/LightPlatformTestCase", "enableInspectionTools"));
        }
        InspectionProfileEntry[] tools = new InspectionProfileEntry[classes.length];
        ArrayList eps = ContainerUtil.newArrayList();
        ContainerUtil.addAll((Collection)eps, (Object[])Extensions.getExtensions((ExtensionPointName)LocalInspectionEP.LOCAL_INSPECTION));
        ContainerUtil.addAll((Collection)eps, (Object[])Extensions.getExtensions((ExtensionPointName)InspectionEP.GLOBAL_INSPECTION));
        for (int i = 0; i < classes.length; ++i) {
            InspectionEP ep2;
            block3: {
                for (InspectionEP ep2 : eps) {
                    if (!classes[i].getName().equals(ep2.implementationClass)) continue;
                    break block3;
                }
                throw new IllegalArgumentException("Unable to find extension point for " + classes[i].getName());
            }
            tools[i] = ep2.instantiateTool();
        }
        this.enableInspectionTools(tools);
    }

    protected void enableInspectionTools(InspectionProfileEntry ... tools) {
        if (tools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tools", "com/intellij/testFramework/LightPlatformTestCase", "enableInspectionTools"));
        }
        for (InspectionProfileEntry tool : tools) {
            this.enableInspectionTool(tool);
        }
    }

    protected void enableInspectionTool(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/testFramework/LightPlatformTestCase", "enableInspectionTool"));
        }
        LightPlatformTestCase.enableInspectionTool(this.myAvailableInspectionTools, toolWrapper);
    }

    protected void enableInspectionTool(@NotNull InspectionProfileEntry tool) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/testFramework/LightPlatformTestCase", "enableInspectionTool"));
        }
        InspectionToolWrapper toolWrapper = InspectionToolRegistrar.wrapTool(tool);
        LightPlatformTestCase.enableInspectionTool(this.myAvailableInspectionTools, toolWrapper);
    }

    public static void enableInspectionTool(@NotNull Map<String, InspectionToolWrapper> availableLocalTools, @NotNull InspectionToolWrapper toolWrapper) {
        if (availableLocalTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "availableLocalTools", "com/intellij/testFramework/LightPlatformTestCase", "enableInspectionTool"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/testFramework/LightPlatformTestCase", "enableInspectionTool"));
        }
        String shortName = toolWrapper.getShortName();
        HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
        if (key == null) {
            String id = toolWrapper instanceof LocalInspectionToolWrapper ? ((LocalInspectionTool)((LocalInspectionToolWrapper)toolWrapper).getTool()).getID() : toolWrapper.getShortName();
            HighlightDisplayKey.register((String)shortName, (String)toolWrapper.getDisplayName(), (String)id);
        }
        availableLocalTools.put(shortName, toolWrapper);
    }

    @NotNull
    protected LocalInspectionTool[] configureLocalInspectionTools() {
        if (LocalInspectionTool.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformTestCase", "configureLocalInspectionTools"));
        }
        return LocalInspectionTool.EMPTY_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        Project project = LightPlatformTestCase.getProject();
        CodeStyleSettingsManager.getInstance((Project)project).dropTemporarySettings();
        CompositeException damage = this.checkForSettingsDamage();
        VirtualFilePointerManagerImpl filePointerManager = (VirtualFilePointerManagerImpl)VirtualFilePointerManager.getInstance();
        LightPlatformTestCase.doTearDown(project, ourApplication, true);
        try {
            super.tearDown();
        }
        finally {
            this.myThreadTracker.checkLeak();
            InjectedLanguageManagerImpl.checkInjectorsAreDisposed(project);
            filePointerManager.assertPointersAreDisposed();
        }
        damage.throwIfNotEmpty();
    }

    public static void doTearDown(final @NotNull Project project, IdeaTestApplication application, boolean checkForEditors) throws Exception {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightPlatformTestCase", "doTearDown"));
        }
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
        DocumentCommitThread.getInstance().clearQueue();
        CodeStyleSettingsManager.getInstance((Project)project).dropTemporarySettings();
        LightPlatformTestCase.checkAllTimersAreDisposed();
        UsefulTestCase.doPostponedFormatting(project);
        LookupManager lookupManager = LookupManager.getInstance(project);
        if (lookupManager != null) {
            lookupManager.hideActiveLookup();
        }
        ((StartupManagerImpl)StartupManager.getInstance((Project)project)).prepareForNextTest();
        InspectionProfileManager.getInstance().deleteProfile(PROFILE);
        LightPlatformTestCase.assertNotNull((String)"Application components damaged", (Object)ProjectManager.getInstance());
        new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                EncodingManager encodingManager;
                if (ourSourceRoot != null) {
                    try {
                        VirtualFile[] children;
                        for (VirtualFile child : children = ourSourceRoot.getChildren()) {
                            child.delete((Object)this);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if ((encodingManager = EncodingManager.getInstance()) instanceof EncodingManagerImpl) {
                    ((EncodingManagerImpl)encodingManager).clearDocumentQueue();
                }
                FileDocumentManager manager = FileDocumentManager.getInstance();
                ApplicationManager.getApplication().runWriteAction(EmptyRunnable.getInstance());
                manager.saveAllDocuments();
                if (manager instanceof FileDocumentManagerImpl) {
                    ((FileDocumentManagerImpl)manager).dropAllUnsavedDocuments();
                }
            }
        }.execute().throwException();
        LightPlatformTestCase.assertFalse((boolean)PsiManager.getInstance((Project)project).isDisposed());
        if (!ourAssertionsInTestDetected && IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
        PsiDocumentManagerImpl documentManager = LightPlatformTestCase.clearUncommittedDocuments(project);
        ((HintManagerImpl)HintManager.getInstance()).cleanup();
        DocumentCommitThread.getInstance().clearQueue();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ((UndoManagerImpl)UndoManager.getGlobalInstance()).dropHistoryInTests();
                ((UndoManagerImpl)UndoManager.getInstance((Project)project)).dropHistoryInTests();
                UIUtil.dispatchAllInvocationEvents();
            }
        });
        TemplateDataLanguageMappings.getInstance(project).cleanupForNextTest();
        ProjectManagerEx.getInstanceEx().closeTestProject(project);
        application.setDataProvider(null);
        ourTestCase = null;
        ((PsiManagerImpl)PsiManager.getInstance((Project)project)).cleanupForNextTest();
        CompletionProgressIndicator.cleanupForNextTest();
        if (checkForEditors) {
            LightPlatformTestCase.checkEditorsReleased();
        }
        if (LightPlatformTestCase.isLight(project)) {
            ((ProjectImpl)project).setTemporarilyDisposed(true);
            documentManager.clearUncommittedDocuments();
        }
    }

    public static PsiDocumentManagerImpl clearUncommittedDocuments(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightPlatformTestCase", "clearUncommittedDocuments"));
        }
        PsiDocumentManagerImpl documentManager = (PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)project);
        documentManager.clearUncommittedDocuments();
        ProjectManagerImpl projectManager = (ProjectManagerImpl)ProjectManager.getInstance();
        if (projectManager.isDefaultProjectInitialized()) {
            Project defaultProject = projectManager.getDefaultProject();
            ((PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)defaultProject)).clearUncommittedDocuments();
        }
        return documentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkEditorsReleased() throws Exception {
        CompositeException result = new CompositeException(new Throwable[0]);
        Editor[] allEditors = EditorFactory.getInstance().getAllEditors();
        if (allEditors.length > 0) {
            for (Editor editor : allEditors) {
                try {
                    EditorFactoryImpl.throwNotReleasedError(editor);
                }
                catch (Throwable e) {
                    result.add(e);
                }
                finally {
                    EditorFactory.getInstance().releaseEditor(editor);
                }
            }
            try {
                ((EditorImpl)allEditors[0]).throwDisposalError("Unreleased editors: " + allEditors.length);
            }
            catch (Throwable e) {
                e.printStackTrace();
                result.add(e);
            }
        }
        if (!result.isEmpty()) {
            throw result;
        }
    }

    @Override
    public final void runBare() throws Throwable {
        if (!this.shouldRunTest()) {
            return;
        }
        final AtomicReference throwable = new AtomicReference();
        LightPlatformTestCase.replaceIdeEventQueueSafely();
        SwingUtilities.invokeAndWait(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ourTestThread = Thread.currentThread();
                    LightPlatformTestCase.this.startRunAndTear();
                }
                catch (Throwable e) {
                    throwable.set(e);
                }
                finally {
                    ourTestThread = null;
                    try {
                        Application application = ApplicationManager.getApplication();
                        if (application instanceof ApplicationEx) {
                            PlatformTestCase.cleanupApplicationCaches(ourProject);
                        }
                        LightPlatformTestCase.this.resetAllFields();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        if (throwable.get() != null) {
            throw (Throwable)throwable.get();
        }
        SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRunAndTear() throws Throwable {
        this.setUp();
        try {
            ourAssertionsInTestDetected = true;
            this.runTest();
            ourAssertionsInTestDetected = false;
        }
        finally {
            this.tearDown();
        }
    }

    public Object getData(String dataId) {
        return ourProject == null || ourProject.isDisposed() ? null : new TestDataProvider(ourProject).getData(dataId);
    }

    protected Sdk getProjectJDK() {
        return null;
    }

    protected ModuleType getModuleType() {
        return EmptyModuleType.getInstance();
    }

    protected static PsiFile createFile(@NonNls String fileName, @NonNls String text) throws IncorrectOperationException {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        return PsiFileFactory.getInstance((Project)LightPlatformTestCase.getProject()).createFileFromText(fileName, fileType, (CharSequence)text, LocalTimeCounter.currentTime(), true, false);
    }

    protected static PsiFile createLightFile(@NonNls String fileName, String text) throws IncorrectOperationException {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        return PsiFileFactory.getInstance((Project)LightPlatformTestCase.getProject()).createFileFromText(fileName, fileType, (CharSequence)text, LocalTimeCounter.currentTime(), false, false);
    }

    @Override
    protected String getTestName(boolean lowercaseFirstLetter) {
        String name = this.getName();
        LightPlatformTestCase.assertTrue((String)("Test name should start with 'test': " + name), (boolean)name.startsWith("test"));
        name = name.substring("test".length());
        if (!name.isEmpty() && lowercaseFirstLetter && !UsefulTestCase.isAllUppercaseName(name)) {
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    protected static void commitDocument(Document document) {
        PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject()).commitDocument(document);
    }

    protected static void commitAllDocuments() {
        PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject()).commitAllDocuments();
    }

    @Override
    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        if (CodeStyleSchemes.getInstance().getCurrentScheme() == null) {
            return new CodeStyleSettings();
        }
        return CodeStyleSettingsManager.getSettings((Project)LightPlatformTestCase.getProject());
    }

    protected static Document getDocument(PsiFile file) {
        return PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject()).getDocument(file);
    }

    public static synchronized void closeAndDeleteProject() {
        if (ourProject != null) {
            File ioFile;
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            ((ProjectImpl)ourProject).setTemporarilyDisposed(false);
            VirtualFile projectFile = ((ProjectEx)ourProject).getStateStore().getProjectFile();
            File file = ioFile = projectFile == null ? null : VfsUtilCore.virtualToIoFile((VirtualFile)projectFile);
            if (!ourProject.isDisposed()) {
                Disposer.dispose((Disposable)ourProject);
            }
            if (ioFile != null) {
                File dir = ioFile.getParentFile();
                if (dir.getName().startsWith("unitTest_")) {
                    FileUtil.delete((File)dir);
                } else {
                    FileUtil.delete((File)ioFile);
                }
            }
            ProjectManagerEx.getInstanceEx().closeTestProject(ourProject);
            ourProject = null;
            ourPathToKeep = null;
        }
    }

    private static void registerShutdownHook() {
        ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

            @Override
            public void run() {
                ShutDownTracker.invokeAndWait((boolean)true, (boolean)true, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                LightPlatformTestCase.closeAndDeleteProject();
                            }
                        });
                    }
                });
            }
        });
    }

    static {
        ourTestCase = null;
    }

    private static class SimpleLightProjectDescriptor
    implements LightProjectDescriptor {
        private final ModuleType myModuleType;
        private final Sdk mySdk;

        SimpleLightProjectDescriptor(ModuleType moduleType, Sdk sdk) {
            this.myModuleType = moduleType;
            this.mySdk = sdk;
        }

        @Override
        public ModuleType getModuleType() {
            return this.myModuleType;
        }

        @Override
        public Sdk getSdk() {
            return this.mySdk;
        }

        @Override
        public void configureModule(Module module, ModifiableRootModel model, ContentEntry contentEntry) {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleLightProjectDescriptor that = (SimpleLightProjectDescriptor)o;
            if (this.myModuleType != null ? !this.myModuleType.equals((Object)that.myModuleType) : that.myModuleType != null) {
                return false;
            }
            return this.areJdksEqual(that.getSdk());
        }

        public int hashCode() {
            return this.myModuleType != null ? this.myModuleType.hashCode() : 0;
        }

        private boolean areJdksEqual(Sdk newSdk) {
            if (this.mySdk == null || newSdk == null) {
                return this.mySdk == newSdk;
            }
            Object[] myUrls = this.mySdk.getRootProvider().getUrls(OrderRootType.CLASSES);
            Object[] newUrls = newSdk.getRootProvider().getUrls(OrderRootType.CLASSES);
            return ContainerUtil.newHashSet((Object[])myUrls).equals(ContainerUtil.newHashSet((Object[])newUrls));
        }
    }
}

