/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration.createTest;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.testIntegration.TestFramework;
import com.intellij.testIntegration.createTest.JavaTestGenerator;
import com.intellij.testIntegration.createTest.MissedTestsDialog;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class GenerateMissedTestsAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getText() {
        if ("Generate missed test methods" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/createTest/GenerateMissedTestsAction", "getText"));
        }
        return "Generate missed test methods";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/createTest/GenerateMissedTestsAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testIntegration/createTest/GenerateMissedTestsAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testIntegration/createTest/GenerateMissedTestsAction", "isAvailable"));
        }
        if (((TestFramework[])Extensions.getExtensions((ExtensionPointName)TestFramework.EXTENSION_NAME)).length == 0) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiMethod)) {
            return false;
        }
        if (!((PsiMethod)parent).hasModifierProperty("public") || ((PsiMethod)parent).hasModifierProperty("abstract")) {
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testIntegration/createTest/GenerateMissedTestsAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testIntegration/createTest/GenerateMissedTestsAction", "invoke"));
        }
        final PsiClass srcClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (srcClass == null) {
            return;
        }
        List<PsiElement> testClasses = TestFinderHelper.findTestsForClass((PsiElement)srcClass);
        if (testClasses.isEmpty()) {
            HintManager.getInstance().showErrorHint(editor, "No tests found.");
            return;
        }
        if (testClasses.size() == 1) {
            GenerateMissedTestsAction.generateMissedTests((PsiClass)testClasses.get(0), srcClass);
            return;
        }
        final JBList list = new JBList(testClasses);
        list.setCellRenderer((ListCellRenderer)new PsiClassListCellRenderer());
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setItemChoosenCallback(new Runnable(){

            @Override
            public void run() {
                GenerateMissedTestsAction.generateMissedTests((PsiClass)list.getSelectedValue(), srcClass);
            }
        }).setTitle("Choose Test").createPopup().showInBestPositionFor(editor);
    }

    private static void generateMissedTests(final PsiClass testClass, PsiClass srcClass) {
        TestFramework framework;
        if (testClass != null && (framework = TestFrameworks.detectFramework((PsiClass)testClass)) != null) {
            Project project = testClass.getProject();
            final Editor editor = CodeInsightUtil.positionCursor(project, testClass.getContainingFile(), testClass.getLBrace());
            final MissedTestsDialog dialog = new MissedTestsDialog(project, srcClass, testClass, framework);
            if (dialog.showAndGet()) {
                WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        JavaTestGenerator.addTestMethods(editor, testClass, framework, dialog.getSelectedMethods(), false, false);
                    }
                });
            }
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

