/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiJavaFile;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.classlayout.ClassNameDiffersFromFileNameInspectionBase;
import com.siyeh.ig.fixes.RenameFix;
import org.jetbrains.annotations.Nullable;

public class ClassNameDiffersFromFileNameInspection
extends ClassNameDiffersFromFileNameInspectionBase {
    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiClass[] classes;
        PsiJavaFile file = (PsiJavaFile)infos[0];
        String fileName = file.getName();
        int prefixIndex = fileName.indexOf(46);
        String filenameWithoutPrefix = fileName.substring(0, prefixIndex);
        for (PsiClass psiClass : classes = file.getClasses()) {
            String className = psiClass.getName();
            if (!filenameWithoutPrefix.equals(className)) continue;
            return null;
        }
        return new RenameFix(filenameWithoutPrefix);
    }
}

