/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.frame;

import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeVariablesGroup;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.VariableContext;

public final class CallFrameView
extends XStackFrame
implements VariableContext {
    private final SourceInfo sourceInfo;
    private final DebuggerViewSupport viewSupport;
    private final CallFrame callFrame;
    private final Script script;
    private final boolean inLibraryContent;
    private XDebuggerEvaluator evaluator;

    public CallFrameView(@NotNull CallFrame callFrame, @NotNull DebuggerViewSupport viewSupport, @Nullable Script script) {
        if (callFrame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callFrame", "org/jetbrains/debugger/frame/CallFrameView", "<init>"));
        }
        if (viewSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewSupport", "org/jetbrains/debugger/frame/CallFrameView", "<init>"));
        }
        this(callFrame, viewSupport.getSourceInfo(script, callFrame), viewSupport, script);
    }

    public CallFrameView(@NotNull CallFrame callFrame, @Nullable SourceInfo sourceInfo, @NotNull DebuggerViewSupport viewSupport, @Nullable Script script) {
        if (callFrame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callFrame", "org/jetbrains/debugger/frame/CallFrameView", "<init>"));
        }
        if (viewSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewSupport", "org/jetbrains/debugger/frame/CallFrameView", "<init>"));
        }
        this.sourceInfo = sourceInfo;
        this.viewSupport = viewSupport;
        this.callFrame = callFrame;
        this.script = script;
        this.inLibraryContent = sourceInfo != null && viewSupport.isInLibraryContent(sourceInfo, script);
    }

    @Nullable
    public Script getScript() {
        return this.script;
    }

    public Object getEqualityObject() {
        return this.callFrame.getEqualityObject();
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/debugger/frame/CallFrameView", "computeChildren"));
        }
        node.setAlreadySorted(true);
        ScopeVariablesGroup.createAndAddScopeList(node, this.callFrame.getVariableScopes(), this, this.callFrame);
    }

    @NotNull
    public CallFrame getCallFrame() {
        CallFrame callFrame = this.callFrame;
        if (callFrame == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/frame/CallFrameView", "getCallFrame"));
        }
        return callFrame;
    }

    @Override
    @NotNull
    public EvaluateContext getEvaluateContext() {
        EvaluateContext evaluateContext = this.callFrame.getEvaluateContext();
        if (evaluateContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/frame/CallFrameView", "getEvaluateContext"));
        }
        return evaluateContext;
    }

    @Override
    @Nullable
    public String getName() {
        return null;
    }

    @Override
    @Nullable
    public VariableContext getParent() {
        return null;
    }

    @Override
    public boolean watchableAsEvaluationExpression() {
        return true;
    }

    @Override
    @NotNull
    public DebuggerViewSupport getViewSupport() {
        DebuggerViewSupport debuggerViewSupport = this.viewSupport;
        if (debuggerViewSupport == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/frame/CallFrameView", "getViewSupport"));
        }
        return debuggerViewSupport;
    }

    @Override
    @NotNull
    public Promise<MemberFilter> getMemberFilter() {
        Promise<MemberFilter> promise = this.viewSupport.getMemberFilter(this);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/frame/CallFrameView", "getMemberFilter"));
        }
        return promise;
    }

    @NotNull
    public Promise<MemberFilter> getMemberFilter(@NotNull Scope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/debugger/frame/CallFrameView", "getMemberFilter"));
        }
        Promise<MemberFilter> promise = ScopeVariablesGroup.createVariableContext(scope, this, this.callFrame).getMemberFilter();
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/frame/CallFrameView", "getMemberFilter"));
        }
        return promise;
    }

    @Override
    @Nullable
    public Scope getScope() {
        return null;
    }

    public final XDebuggerEvaluator getEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = this.viewSupport.createFrameEvaluator(this);
        }
        return this.evaluator;
    }

    @Nullable
    public SourceInfo getSourcePosition() {
        return this.sourceInfo;
    }

    public final void customizePresentation(@NotNull ColoredTextContainer component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "org/jetbrains/debugger/frame/CallFrameView", "customizePresentation"));
        }
        if (this.sourceInfo == null) {
            String scriptName = this.script == null ? "unknown" : this.script.getUrl().trimParameters().toDecodedForm();
            int line = this.callFrame.getLine();
            component.append(line != -1 ? scriptName + ':' + line : scriptName, SimpleTextAttributes.ERROR_ATTRIBUTES);
            return;
        }
        String fileName = this.sourceInfo.getFile().getName();
        int line = this.sourceInfo.getLine() + 1;
        boolean isInLibraryContent = this.inLibraryContent;
        SimpleTextAttributes textAttributes = isInLibraryContent ? SimpleTextAttributes.GRAYED_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        String functionName = this.sourceInfo.getFunctionName();
        if (functionName == null || functionName.isEmpty() && this.callFrame.hasOnlyGlobalScope()) {
            component.append(fileName + ":" + line, textAttributes);
        } else {
            if (functionName.isEmpty()) {
                component.append("anonymous", isInLibraryContent ? SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES : SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
            } else {
                component.append(functionName, textAttributes);
            }
            component.append("(), " + fileName + ":" + line, textAttributes);
        }
        component.setIcon(AllIcons.Debugger.StackFrame);
    }
}

