/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.highlighting;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.header.HeaderNameMatch;
import org.jetbrains.lang.manifest.header.HeaderParserRepository;
import org.jetbrains.lang.manifest.psi.Header;

public class MisspelledHeaderInspection
extends LocalInspectionTool {
    private static final int MAX_SUGGESTIONS = 10;
    private HeaderParserRepository myRepository = HeaderParserRepository.getInstance();

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof Header) {
                    Header header = (Header)element;
                    Collection<HeaderNameMatch> matches = MisspelledHeaderInspection.this.myRepository.getMatches(header.getName());
                    if (!matches.isEmpty()) {
                        ArrayList fixes = ContainerUtil.newArrayListWithCapacity((int)10);
                        for (HeaderNameMatch match : matches) {
                            fixes.add(new HeaderNameSpellingQuickFix(header, match));
                            if (fixes.size() != 10) continue;
                            break;
                        }
                        holder.registerProblem((PsiElement)header.getNameElement(), ManifestBundle.message("inspection.header.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])fixes.toArray(new HeaderNameSpellingQuickFix[fixes.size()]));
                    }
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    private static class HeaderNameSpellingQuickFix
    implements LocalQuickFix {
        private final Header myHeader;
        private final String myNewName;

        private HeaderNameSpellingQuickFix(Header header, HeaderNameMatch match) {
            this.myHeader = header;
            this.myNewName = match.getHeaderName();
        }

        @NotNull
        public String getName() {
            String string = ManifestBundle.message("inspection.header.fix", this.myNewName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$HeaderNameSpellingQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = ManifestBundle.message("inspection.group", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$HeaderNameSpellingQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$HeaderNameSpellingQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$HeaderNameSpellingQuickFix", "applyFix"));
            }
            this.myHeader.setName(this.myNewName);
        }
    }
}

