/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal;

import com.google.common.collect.Lists;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.model.dsl.internal.ClosureBackedModelMutator;
import org.gradle.model.dsl.internal.transform.RuleMetadata;
import org.gradle.model.dsl.internal.transform.RulesBlock;
import org.gradle.model.dsl.internal.transform.SourceLocation;
import org.gradle.model.internal.core.ModelMutator;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.registry.ModelRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformedModelDslBacking {
    private static final Transformer<List<ModelReference<?>>, Closure<?>> INPUT_PATHS_EXTRACTOR = new Transformer<List<ModelReference<?>>, Closure<?>>(){

        public List<ModelReference<?>> transform(Closure<?> closure) {
            RuleMetadata ruleMetadata = TransformedModelDslBacking.getRuleMetadata(closure);
            String[] paths = ruleMetadata.inputPaths();
            ArrayList references = Lists.newArrayListWithCapacity((int)paths.length);
            for (int i = 0; i < paths.length; ++i) {
                String description = String.format("@ line %d", ruleMetadata.inputLineNumbers()[i]);
                references.add(ModelReference.untyped((ModelPath)ModelPath.path((String)paths[i]), (String)description));
            }
            return references;
        }
    };
    private static final Transformer<SourceLocation, Closure<?>> RULE_LOCATION_EXTRACTOR = new Transformer<SourceLocation, Closure<?>>(){

        public SourceLocation transform(Closure<?> closure) {
            RuleMetadata ruleMetadata = TransformedModelDslBacking.getRuleMetadata(closure);
            return new SourceLocation(ruleMetadata.scriptSourceDescription(), ruleMetadata.lineNumber(), ruleMetadata.columnNumber());
        }
    };
    private final ModelRegistry modelRegistry;
    private final Object thisObject;
    private final Object owner;
    private final Transformer<? extends List<ModelReference<?>>, ? super Closure<?>> inputPathsExtractor;
    private final Transformer<SourceLocation, ? super Closure<?>> ruleLocationExtractor;

    public TransformedModelDslBacking(ModelRegistry modelRegistry, Object thisObject, Object owner) {
        this(modelRegistry, thisObject, owner, INPUT_PATHS_EXTRACTOR, RULE_LOCATION_EXTRACTOR);
    }

    TransformedModelDslBacking(ModelRegistry modelRegistry, Object thisObject, Object owner, Transformer<? extends List<ModelReference<?>>, ? super Closure<?>> inputPathsExtractor, Transformer<SourceLocation, ? super Closure<?>> ruleLocationExtractor) {
        this.modelRegistry = modelRegistry;
        this.thisObject = thisObject;
        this.owner = owner;
        this.inputPathsExtractor = inputPathsExtractor;
        this.ruleLocationExtractor = ruleLocationExtractor;
    }

    public void configure(String modelPathString, Closure<?> configuration) {
        List references = (List)this.inputPathsExtractor.transform(configuration);
        SourceLocation sourceLocation = (SourceLocation)this.ruleLocationExtractor.transform(configuration);
        ModelPath modelPath = ModelPath.path((String)modelPathString);
        Closure reownered = configuration.rehydrate(null, this.owner, this.thisObject);
        this.modelRegistry.mutate((ModelMutator)new ClosureBackedModelMutator(reownered, references, modelPath, sourceLocation));
    }

    private static RuleMetadata getRuleMetadata(Closure<?> closure) {
        RuleMetadata ruleMetadata = closure.getClass().getAnnotation(RuleMetadata.class);
        if (ruleMetadata == null) {
            throw new IllegalStateException(String.format("Expected %s annotation to be used on the argument closure.", RuleMetadata.class.getName()));
        }
        return ruleMetadata;
    }

    public static boolean isTransformedBlock(Closure<?> closure) {
        Class<?> closureClass = closure.getClass();
        RulesBlock annotation = closureClass.getAnnotation(RulesBlock.class);
        return annotation != null;
    }
}

