/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.console.GroovyShellActionBase;

public class BuildAndRestartConsoleAction
extends AnAction
implements Disposable {
    private Module myModule;
    private Project myProject;
    private Executor myExecutor;
    private RunContentDescriptor myContentDescriptor;
    private GroovyShellActionBase myShellAction;

    public BuildAndRestartConsoleAction(@NotNull Module module, @NotNull Project project, @NotNull Executor executor, @NotNull RunContentDescriptor contentDescriptor, @NotNull GroovyShellActionBase action) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/console/BuildAndRestartConsoleAction", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/console/BuildAndRestartConsoleAction", "<init>"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/plugins/groovy/console/BuildAndRestartConsoleAction", "<init>"));
        }
        if (contentDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentDescriptor", "org/jetbrains/plugins/groovy/console/BuildAndRestartConsoleAction", "<init>"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/plugins/groovy/console/BuildAndRestartConsoleAction", "<init>"));
        }
        super("Restart", "Build module '" + module.getName() + "' and restart", AllIcons.Actions.Restart);
        this.myModule = module;
        this.myProject = project;
        this.myExecutor = executor;
        this.myContentDescriptor = contentDescriptor;
        this.myShellAction = action;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(this.isEnabled());
    }

    private boolean isEnabled() {
        if (this.myModule == null) {
            return false;
        }
        if (this.myModule.isDisposed()) {
            return false;
        }
        ProcessHandler processHandler = this.myContentDescriptor.getProcessHandler();
        if (processHandler == null) {
            return false;
        }
        return !processHandler.isProcessTerminated();
    }

    public void actionPerformed(AnActionEvent e) {
        BuildAndRestartConsoleAction.rerun(this.myModule, this.myProject, this.myContentDescriptor, this.myShellAction, this.myExecutor);
    }

    private static void rerun(final @NotNull Module module, @NotNull Project project, @NotNull RunContentDescriptor contentDescriptor, final @NotNull GroovyShellActionBase action, @NotNull Executor executor) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/console/BuildAndRestartConsoleAction", "rerun"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/console/BuildAndRestartConsoleAction", "rerun"));
        }
        if (contentDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentDescriptor", "org/jetbrains/plugins/groovy/console/BuildAndRestartConsoleAction", "rerun"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/plugins/groovy/console/BuildAndRestartConsoleAction", "rerun"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/plugins/groovy/console/BuildAndRestartConsoleAction", "rerun"));
        }
        ExecutionManager.getInstance((Project)project).getContentManager().removeRunContent(executor, contentDescriptor);
        if (contentDescriptor.getProcessHandler() != null && contentDescriptor.getProcessHandler().isProcessTerminated()) {
            CompilerManager.getInstance((Project)project).compile(module, new CompileStatusNotification(){

                public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                    if (!module.isDisposed()) {
                        action.doRunShell(module);
                    }
                }
            });
        }
    }

    public void dispose() {
        this.myModule = null;
        this.myShellAction = null;
        this.myProject = null;
        this.myExecutor = null;
        this.myContentDescriptor = null;
    }
}

