/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.ConflictState;
import org.jetbrains.idea.svn.ConflictedSvnChange;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.SvnChangedFile;
import org.jetbrains.idea.svn.SvnContentRevision;
import org.jetbrains.idea.svn.SvnLocallyDeletedChange;
import org.jetbrains.idea.svn.SvnStatusConvertor;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.AbstractShowPropertiesDiffAction;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.history.SimplePropertyRevision;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;

class SvnChangeProviderContext
implements StatusReceiver {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.idea.svn.SvnChangeProviderContext");
    @NotNull
    private final ChangelistBuilder myChangelistBuilder;
    @NotNull
    private final List<SvnChangedFile> myCopiedFiles;
    @NotNull
    private final List<SvnChangedFile> myDeletedFiles;
    @NotNull
    private final Map<String, Status> myTreeConflicted;
    @NotNull
    private final Map<FilePath, String> myCopyFromURLs;
    @NotNull
    private final SvnVcs myVcs;
    private final SvnBranchConfigurationManager myBranchConfigurationManager;
    @NotNull
    private final List<File> filesToRefresh;
    @Nullable
    private final ProgressIndicator myProgress;

    public SvnChangeProviderContext(@NotNull SvnVcs vcs, @NotNull ChangelistBuilder changelistBuilder, @Nullable ProgressIndicator progress) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/SvnChangeProviderContext", "<init>"));
        }
        if (changelistBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changelistBuilder", "org/jetbrains/idea/svn/SvnChangeProviderContext", "<init>"));
        }
        this.myCopiedFiles = ContainerUtil.newArrayList();
        this.myDeletedFiles = ContainerUtil.newArrayList();
        this.myTreeConflicted = ContainerUtil.newHashMap();
        this.myCopyFromURLs = ContainerUtil.newHashMap();
        this.filesToRefresh = ContainerUtil.newArrayList();
        this.myVcs = vcs;
        this.myChangelistBuilder = changelistBuilder;
        this.myProgress = progress;
        this.myBranchConfigurationManager = SvnBranchConfigurationManager.getInstance(this.myVcs.getProject());
    }

    @Override
    public void process(FilePath path, Status status) throws SVNException {
        if (status != null) {
            this.processStatusFirstPass(path, status);
        }
    }

    @Override
    public void processIgnored(VirtualFile vFile) {
        this.myChangelistBuilder.processIgnoredFile(vFile);
    }

    @Override
    public void processUnversioned(VirtualFile vFile) {
        this.myChangelistBuilder.processUnversionedFile(vFile);
    }

    @Override
    public void processCopyRoot(VirtualFile file, SVNURL url, WorkingCopyFormat format, SVNURL rootURL) {
    }

    @Override
    public void bewareRoot(VirtualFile vf, SVNURL url) {
    }

    @Override
    public void finish() {
        LocalFileSystem.getInstance().refreshIoFiles(this.filesToRefresh, true, false, null);
    }

    @NotNull
    public ChangelistBuilder getBuilder() {
        ChangelistBuilder changelistBuilder = this.myChangelistBuilder;
        if (changelistBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnChangeProviderContext", "getBuilder"));
        }
        return changelistBuilder;
    }

    public void reportTreeConflict(@NotNull Status status) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/idea/svn/SvnChangeProviderContext", "reportTreeConflict"));
        }
        this.myTreeConflicted.put(status.getFile().getAbsolutePath(), status);
    }

    @Nullable
    public Status getTreeConflictStatus(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/SvnChangeProviderContext", "getTreeConflictStatus"));
        }
        return this.myTreeConflicted.get(file.getAbsolutePath());
    }

    @NotNull
    public List<SvnChangedFile> getCopiedFiles() {
        List<SvnChangedFile> list = this.myCopiedFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnChangeProviderContext", "getCopiedFiles"));
        }
        return list;
    }

    @NotNull
    public List<SvnChangedFile> getDeletedFiles() {
        List<SvnChangedFile> list = this.myDeletedFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnChangeProviderContext", "getDeletedFiles"));
        }
        return list;
    }

    public boolean isDeleted(@NotNull FilePath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/SvnChangeProviderContext", "isDeleted"));
        }
        for (SvnChangedFile deletedFile : this.myDeletedFiles) {
            if (!Comparing.equal((Object)path, (Object)deletedFile.getFilePath())) continue;
            return true;
        }
        return false;
    }

    public void checkCanceled() {
        if (this.myProgress != null) {
            this.myProgress.checkCanceled();
        }
    }

    @Nullable
    public String getParentCopyFromURL(@NotNull FilePath filePath) {
        FilePath parent;
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "org/jetbrains/idea/svn/SvnChangeProviderContext", "getParentCopyFromURL"));
        }
        String result = null;
        for (parent = filePath; parent != null && !this.myCopyFromURLs.containsKey(parent); parent = parent.getParentPath()) {
        }
        if (parent != null) {
            String copyFromUrl = this.myCopyFromURLs.get(parent);
            result = parent == filePath ? copyFromUrl : SvnUtil.appendMultiParts(copyFromUrl, FileUtil.getRelativePath((File)parent.getIOFile(), (File)filePath.getIOFile()));
        }
        return result;
    }

    public void addCopiedFile(@NotNull FilePath filePath, @NotNull Status status, @NotNull String copyFromURL) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "org/jetbrains/idea/svn/SvnChangeProviderContext", "addCopiedFile"));
        }
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/idea/svn/SvnChangeProviderContext", "addCopiedFile"));
        }
        if (copyFromURL == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyFromURL", "org/jetbrains/idea/svn/SvnChangeProviderContext", "addCopiedFile"));
        }
        this.myCopiedFiles.add(new SvnChangedFile(filePath, status, copyFromURL));
        ContainerUtil.putIfNotNull((Object)filePath, (Object)status.getCopyFromURL(), this.myCopyFromURLs);
    }

    void processStatusFirstPass(@NotNull FilePath filePath, @NotNull Status status) throws SVNException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "org/jetbrains/idea/svn/SvnChangeProviderContext", "processStatusFirstPass"));
        }
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/idea/svn/SvnChangeProviderContext", "processStatusFirstPass"));
        }
        if (status.getRemoteLock() != null) {
            this.myChangelistBuilder.processLogicallyLockedFolder(filePath.getVirtualFile(), status.getRemoteLock().toLogicalLock(false));
        }
        if (status.getLocalLock() != null) {
            this.myChangelistBuilder.processLogicallyLockedFolder(filePath.getVirtualFile(), status.getLocalLock().toLogicalLock(true));
        }
        if (filePath.isDirectory() && status.isLocked()) {
            this.myChangelistBuilder.processLockedFolder(filePath.getVirtualFile());
        }
        if ((status.is(StatusType.STATUS_ADDED) || StatusType.STATUS_MODIFIED.equals((Object)status.getNodeStatus())) && status.getCopyFromURL() != null) {
            this.addCopiedFile(filePath, status, status.getCopyFromURL());
        } else if (status.is(StatusType.STATUS_DELETED)) {
            this.myDeletedFiles.add(new SvnChangedFile(filePath, status));
        } else {
            String parentCopyFromURL = this.getParentCopyFromURL(filePath);
            if (parentCopyFromURL != null) {
                this.addCopiedFile(filePath, status, parentCopyFromURL);
            } else {
                this.processStatus(filePath, status);
            }
        }
    }

    void processStatus(@NotNull FilePath filePath, @NotNull Status status) throws SVNException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "org/jetbrains/idea/svn/SvnChangeProviderContext", "processStatus"));
        }
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/idea/svn/SvnChangeProviderContext", "processStatus"));
        }
        WorkingCopyFormat format = this.myVcs.getWorkingCopyFormat(filePath.getIOFile());
        if (!WorkingCopyFormat.UNKNOWN.equals((Object)format) && format.less(WorkingCopyFormat.ONE_DOT_SEVEN)) {
            this.loadEntriesFile(filePath);
        }
        FileStatus fStatus = SvnStatusConvertor.convertStatus(status);
        StatusType statusType = status.getContentsStatus();
        if (status.is(StatusType.STATUS_UNVERSIONED, StatusType.UNKNOWN)) {
            VirtualFile file = filePath.getVirtualFile();
            if (file != null) {
                this.myChangelistBuilder.processUnversionedFile(file);
            }
        } else if (status.is(StatusType.STATUS_ADDED)) {
            this.processChangeInList(null, CurrentContentRevision.create((FilePath)filePath), fStatus, status);
        } else if (status.is(StatusType.STATUS_CONFLICTED, StatusType.STATUS_MODIFIED, StatusType.STATUS_REPLACED) || status.isProperty(StatusType.STATUS_MODIFIED, StatusType.STATUS_CONFLICTED)) {
            this.processChangeInList(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), CurrentContentRevision.create((FilePath)filePath), fStatus, status);
            this.checkSwitched(filePath, status, fStatus);
        } else if (status.is(StatusType.STATUS_DELETED)) {
            this.processChangeInList(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), null, fStatus, status);
        } else if (status.is(StatusType.STATUS_MISSING)) {
            this.myChangelistBuilder.processLocallyDeletedFile((LocallyDeletedChange)new SvnLocallyDeletedChange(filePath, this.getState(status)));
        } else if (status.is(StatusType.STATUS_IGNORED)) {
            if (filePath.getVirtualFile() == null) {
                filePath.hardRefresh();
            }
            if (filePath.getVirtualFile() == null) {
                LOG.error("No virtual file for ignored file: " + filePath.getPresentableUrl() + ", isNonLocal: " + filePath.isNonLocal());
            } else if (!this.myVcs.isWcRoot(filePath)) {
                this.myChangelistBuilder.processIgnoredFile(filePath.getVirtualFile());
            }
        } else if ((fStatus == FileStatus.NOT_CHANGED || fStatus == FileStatus.SWITCHED) && statusType != StatusType.STATUS_NONE) {
            VirtualFile file = filePath.getVirtualFile();
            if (file != null && FileDocumentManager.getInstance().isFileModified(file)) {
                this.processChangeInList(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), CurrentContentRevision.create((FilePath)filePath), FileStatus.MODIFIED, status);
            } else if (status.getTreeConflict() != null) {
                this.myChangelistBuilder.processChange(this.createChange(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), CurrentContentRevision.create((FilePath)filePath), FileStatus.MODIFIED, status), SvnVcs.getKey());
            }
            this.checkSwitched(filePath, status, fStatus);
        }
    }

    public void addModifiedNotSavedChange(@NotNull VirtualFile file) throws SVNException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/SvnChangeProviderContext", "addModifiedNotSavedChange"));
        }
        FilePathImpl filePath = new FilePathImpl(file);
        Info svnInfo = this.myVcs.getInfo(file);
        if (svnInfo != null) {
            Status svnStatus = new Status();
            svnStatus.setRevision(svnInfo.getRevision());
            svnStatus.setKind(NodeKind.from(filePath.isDirectory()));
            this.processChangeInList(SvnContentRevision.createBaseRevision(this.myVcs, (FilePath)filePath, svnInfo.getRevision()), CurrentContentRevision.create((FilePath)filePath), FileStatus.MODIFIED, svnStatus);
        }
    }

    private void processChangeInList(@Nullable ContentRevision beforeRevision, @Nullable ContentRevision afterRevision, @NotNull FileStatus fileStatus, @NotNull Status status) throws SVNException {
        if (fileStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileStatus", "org/jetbrains/idea/svn/SvnChangeProviderContext", "processChangeInList"));
        }
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/idea/svn/SvnChangeProviderContext", "processChangeInList"));
        }
        Change change = this.createChange(beforeRevision, afterRevision, fileStatus, status);
        this.myChangelistBuilder.processChangeInList(change, SvnUtil.getChangelistName(status), SvnVcs.getKey());
    }

    private void checkSwitched(@NotNull FilePath filePath, @NotNull Status status, @NotNull FileStatus convertedStatus) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "org/jetbrains/idea/svn/SvnChangeProviderContext", "checkSwitched"));
        }
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/idea/svn/SvnChangeProviderContext", "checkSwitched"));
        }
        if (convertedStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertedStatus", "org/jetbrains/idea/svn/SvnChangeProviderContext", "checkSwitched"));
        }
        if (status.isSwitched() || convertedStatus == FileStatus.SWITCHED) {
            VirtualFile virtualFile = filePath.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            String switchUrl = status.getURL().toString();
            VirtualFile vcsRoot = ProjectLevelVcsManager.getInstance((Project)this.myVcs.getProject()).getVcsRootFor(virtualFile);
            if (vcsRoot != null) {
                String baseUrl = this.myBranchConfigurationManager.get(vcsRoot).getBaseName(switchUrl);
                this.myChangelistBuilder.processSwitchedFile(virtualFile, baseUrl == null ? switchUrl : baseUrl, true);
            }
        }
    }

    private void loadEntriesFile(@NotNull FilePath filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "org/jetbrains/idea/svn/SvnChangeProviderContext", "loadEntriesFile"));
        }
        FilePath parentPath = filePath.getParentPath();
        if (parentPath == null) {
            return;
        }
        this.refreshDotSvnAndEntries(parentPath);
        if (filePath.isDirectory()) {
            this.refreshDotSvnAndEntries(filePath);
        }
    }

    private void refreshDotSvnAndEntries(@NotNull FilePath filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "org/jetbrains/idea/svn/SvnChangeProviderContext", "refreshDotSvnAndEntries"));
        }
        File svn = new File(filePath.getPath(), SvnUtil.SVN_ADMIN_DIR_NAME);
        this.filesToRefresh.add(svn);
        this.filesToRefresh.add(new File(svn, "entries"));
    }

    @NotNull
    Change createMovedChange(@NotNull ContentRevision before, @NotNull ContentRevision after, @Nullable Status copiedStatus, @NotNull Status deletedStatus) throws SVNException {
        if (before == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "before", "org/jetbrains/idea/svn/SvnChangeProviderContext", "createMovedChange"));
        }
        if (after == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "after", "org/jetbrains/idea/svn/SvnChangeProviderContext", "createMovedChange"));
        }
        if (deletedStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deletedStatus", "org/jetbrains/idea/svn/SvnChangeProviderContext", "createMovedChange"));
        }
        ConflictedSvnChange change = new ConflictedSvnChange(before, after, ConflictState.mergeState(this.getState(copiedStatus), this.getState(deletedStatus)), copiedStatus != null && copiedStatus.getTreeConflict() != null ? after.getFile() : before.getFile());
        change.setBeforeDescription(deletedStatus.getTreeConflict());
        if (copiedStatus != null) {
            change.setAfterDescription(copiedStatus.getTreeConflict());
            this.patchWithPropertyChange(change, copiedStatus, deletedStatus);
        }
        ConflictedSvnChange conflictedSvnChange = change;
        if (conflictedSvnChange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnChangeProviderContext", "createMovedChange"));
        }
        return conflictedSvnChange;
    }

    @NotNull
    private Change createChange(@Nullable ContentRevision before, @Nullable ContentRevision after, @NotNull FileStatus fStatus, @NotNull Status svnStatus) throws SVNException {
        if (fStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fStatus", "org/jetbrains/idea/svn/SvnChangeProviderContext", "createChange"));
        }
        if (svnStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "svnStatus", "org/jetbrains/idea/svn/SvnChangeProviderContext", "createChange"));
        }
        ConflictedSvnChange change = new ConflictedSvnChange(before, after, fStatus, this.getState(svnStatus), after == null ? before.getFile() : after.getFile());
        change.setIsPhantom(StatusType.STATUS_DELETED.equals((Object)svnStatus.getNodeStatus()) && !svnStatus.getRevision().isValid());
        change.setBeforeDescription(svnStatus.getTreeConflict());
        this.patchWithPropertyChange(change, svnStatus, null);
        ConflictedSvnChange conflictedSvnChange = change;
        if (conflictedSvnChange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnChangeProviderContext", "createChange"));
        }
        return conflictedSvnChange;
    }

    private void patchWithPropertyChange(@NotNull Change change, @NotNull Status svnStatus, @Nullable Status deletedStatus) throws SVNException {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "org/jetbrains/idea/svn/SvnChangeProviderContext", "patchWithPropertyChange"));
        }
        if (svnStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "svnStatus", "org/jetbrains/idea/svn/SvnChangeProviderContext", "patchWithPropertyChange"));
        }
        if (svnStatus.isProperty(StatusType.STATUS_CONFLICTED, StatusType.CHANGED, StatusType.STATUS_ADDED, StatusType.STATUS_DELETED, StatusType.STATUS_MODIFIED, StatusType.STATUS_REPLACED, StatusType.MERGED)) {
            change.addAdditionalLayerElement("Property", this.createPropertyChange(change, svnStatus, deletedStatus));
        }
    }

    @NotNull
    private Change createPropertyChange(@NotNull Change change, @NotNull Status svnStatus, @Nullable Status deletedStatus) throws SVNException {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "org/jetbrains/idea/svn/SvnChangeProviderContext", "createPropertyChange"));
        }
        if (svnStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "svnStatus", "org/jetbrains/idea/svn/SvnChangeProviderContext", "createPropertyChange"));
        }
        File ioFile = ChangesUtil.getFilePath((Change)change).getIOFile();
        File beforeFile = deletedStatus != null ? deletedStatus.getFile() : ioFile;
        ContentRevision beforeRevision = !svnStatus.isProperty(StatusType.STATUS_ADDED) || deletedStatus != null ? this.createPropertyRevision(change, beforeFile, true) : null;
        ContentRevision afterRevision = !svnStatus.isProperty(StatusType.STATUS_DELETED) ? this.createPropertyRevision(change, ioFile, false) : null;
        FileStatus status = deletedStatus != null ? FileStatus.MODIFIED : SvnStatusConvertor.convertPropertyStatus(svnStatus.getPropertiesStatus());
        Change change2 = new Change(beforeRevision, afterRevision, status);
        if (change2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnChangeProviderContext", "createPropertyChange"));
        }
        return change2;
    }

    @Nullable
    private ContentRevision createPropertyRevision(@NotNull Change change, @NotNull File file, boolean isBeforeRevision) throws SVNException {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "org/jetbrains/idea/svn/SvnChangeProviderContext", "createPropertyRevision"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/SvnChangeProviderContext", "createPropertyRevision"));
        }
        FilePath path = ChangesUtil.getFilePath((Change)change);
        ContentRevision contentRevision = isBeforeRevision ? change.getBeforeRevision() : change.getAfterRevision();
        SVNRevision revision = isBeforeRevision ? SVNRevision.BASE : SVNRevision.WORKING;
        return new SimplePropertyRevision(this.getProperties(file, revision), path, SvnChangeProviderContext.getRevisionNumber(contentRevision));
    }

    @Nullable
    private static String getRevisionNumber(@Nullable ContentRevision revision) {
        return revision != null ? revision.getRevisionNumber().asString() : null;
    }

    @NotNull
    private List<PropertyData> getProperties(@NotNull File file, @NotNull SVNRevision revision) throws SVNException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/SvnChangeProviderContext", "getProperties"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/jetbrains/idea/svn/SvnChangeProviderContext", "getProperties"));
        }
        List<PropertyData> list = AbstractShowPropertiesDiffAction.getPropertyList(this.myVcs, file, revision);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnChangeProviderContext", "getProperties"));
        }
        return list;
    }

    @NotNull
    private ConflictState getState(@Nullable Status svnStatus) {
        ConflictState result;
        ConflictState conflictState = result = svnStatus != null ? ConflictState.from(svnStatus) : ConflictState.none;
        if (result.isTree()) {
            this.reportTreeConflict(svnStatus);
        }
        ConflictState conflictState2 = result;
        if (conflictState2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnChangeProviderContext", "getState"));
        }
        return conflictState2;
    }
}

