/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.idea.svn.LimitedStringsList;
import org.jetbrains.idea.svn.SvnFileSystemListener;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

@State(name="SvnApplicationSettings", storages={@Storage(file="$APP_CONFIG$/other.xml")})
public class SvnApplicationSettings
implements PersistentStateComponent<ConfigurationBean> {
    private SvnFileSystemListener myVFSHandler;
    private int mySvnProjectCount;
    private LimitedStringsList myLimitedStringsList;
    private ConfigurationBean myConfigurationBean = new ConfigurationBean();
    private static final String LOADED_REVISIONS_DIR = "loadedRevisions";

    public static SvnApplicationSettings getInstance() {
        return (SvnApplicationSettings)ServiceManager.getService(SvnApplicationSettings.class);
    }

    public ConfigurationBean getState() {
        this.myConfigurationBean.myTypedURLs.clear();
        this.myConfigurationBean.myTypedURLs.addAll(this.getTypedList().getList());
        return this.myConfigurationBean;
    }

    public void loadState(ConfigurationBean object) {
        this.myConfigurationBean = object;
        this.getTypedList();
    }

    public void setCommandLinePath(String path) {
        this.myConfigurationBean.mySvnCommandLine = path;
    }

    public String getCommandLinePath() {
        return this.myConfigurationBean.mySvnCommandLine;
    }

    private LimitedStringsList getTypedList() {
        if (this.myLimitedStringsList == null) {
            this.checkFillTypedFromCheckout();
            this.myLimitedStringsList = new LimitedStringsList(this.myConfigurationBean.myTypedURLs);
        }
        return this.myLimitedStringsList;
    }

    private void checkFillTypedFromCheckout() {
        if (this.myConfigurationBean.myTypedURLs.isEmpty() && !this.myConfigurationBean.myCheckoutURLs.isEmpty()) {
            this.myConfigurationBean.myTypedURLs.addAll(this.myConfigurationBean.myCheckoutURLs);
        }
    }

    public void svnActivated() {
        if (this.myVFSHandler == null) {
            this.myVFSHandler = new SvnFileSystemListener();
        }
        ++this.mySvnProjectCount;
    }

    public void svnDeactivated() {
        --this.mySvnProjectCount;
        if (this.mySvnProjectCount == 0) {
            Disposer.dispose((Disposable)this.myVFSHandler);
            this.myVFSHandler = null;
        }
    }

    private static File getCommonPath() {
        File file = new File(PathManager.getSystemPath());
        file = new File(file, "plugins");
        file = new File(file, "svn4idea");
        file.mkdirs();
        return file;
    }

    public static File getCredentialsFile() {
        return new File(SvnApplicationSettings.getCommonPath(), "credentials.xml");
    }

    public static File getLoadedRevisionsDir(Project project) {
        File file = SvnApplicationSettings.getCommonPath();
        file = new File(file, LOADED_REVISIONS_DIR);
        file = new File(file, project.getLocationHash());
        file.mkdirs();
        return file;
    }

    public Collection<String> getCheckoutURLs() {
        return this.myConfigurationBean.myCheckoutURLs;
    }

    public void addCheckoutURL(String url) {
        if (this.myConfigurationBean.myCheckoutURLs.contains(url)) {
            return;
        }
        this.myConfigurationBean.myCheckoutURLs.add(0, url);
    }

    public void removeCheckoutURL(String url) {
        if (this.myConfigurationBean.myCheckoutURLs != null) {
            for (String oldUrl : this.myConfigurationBean.myCheckoutURLs) {
                try {
                    if (!url.equals(oldUrl) && !SVNURL.parseURIEncoded((String)url).equals((Object)SVNURL.parseURIEncoded((String)oldUrl))) continue;
                    this.myConfigurationBean.myCheckoutURLs.remove(oldUrl);
                    break;
                }
                catch (SVNException e) {
                }
            }
        }
    }

    public List<String> getTypedUrlsListCopy() {
        return new ArrayList<String>(this.getTypedList().getList());
    }

    public void addTypedUrl(String url) {
        this.getTypedList().add(url);
    }

    public static class ConfigurationBean {
        public List<String> myCheckoutURLs = new ArrayList<String>();
        public List<String> myTypedURLs = new ArrayList<String>();
        public String mySvnCommandLine = "svn";
    }
}

