/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AreaMap;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.mergeinfo.BranchInfo;
import org.jetbrains.idea.svn.mergeinfo.MergeChecker;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class OneShotMergeInfoHelper
implements MergeChecker {
    @NotNull
    private final MergeContext myMergeContext;
    @NotNull
    private final Map<Long, Collection<String>> myPartiallyMerged;
    @NotNull
    private final AreaMap<String, Map<String, SVNMergeRangeList>> myMergeInfoMap;
    @NotNull
    private final Object myMergeInfoLock;

    public OneShotMergeInfoHelper(@NotNull MergeContext mergeContext) {
        if (mergeContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeContext", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "<init>"));
        }
        this.myMergeContext = mergeContext;
        this.myPartiallyMerged = ContainerUtil.newHashMap();
        this.myMergeInfoLock = new Object();
        this.myMergeInfoMap = AreaMap.create((PairProcessor)new PairProcessor<String, String>(){

            public boolean process(String parentUrl, String childUrl) {
                if (".".equals(parentUrl)) {
                    return true;
                }
                return SVNPathUtil.isAncestor((String)SvnUtil.ensureStartSlash(parentUrl), (String)SvnUtil.ensureStartSlash(childUrl));
            }
        });
    }

    public void prepare() throws VcsException {
        Depth depth = Depth.allOrEmpty(this.myMergeContext.getVcs().getSvnConfiguration().isCheckNestedForQuickMerge());
        File file = this.myMergeContext.getWcInfo().getRootInfo().getIoFile();
        this.myMergeContext.getVcs().getFactory(file).createPropertyClient().getProperty(SvnTarget.fromFile((File)file), "svn:mergeinfo", SVNRevision.WORKING, depth, this.createPropertyHandler());
    }

    @Override
    @Nullable
    public Collection<String> getNotMergedPaths(long number) {
        return this.myPartiallyMerged.get(number);
    }

    @Override
    @NotNull
    public SvnMergeInfoCache.MergeCheckResult checkList(@NotNull SvnChangeList changeList) {
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "checkList"));
        }
        HashSet notMergedPaths = ContainerUtil.newHashSet();
        boolean hasMergedPaths = false;
        for (String path : changeList.getAffectedPaths()) {
            switch (this.checkPath(path, changeList.getNumber())) {
                case MERGED: {
                    hasMergedPaths = true;
                    break;
                }
                case NOT_MERGED: {
                    notMergedPaths.add(path);
                }
            }
        }
        if (hasMergedPaths && !notMergedPaths.isEmpty()) {
            this.myPartiallyMerged.put(changeList.getNumber(), notMergedPaths);
        }
        SvnMergeInfoCache.MergeCheckResult mergeCheckResult = notMergedPaths.isEmpty() ? (hasMergedPaths ? SvnMergeInfoCache.MergeCheckResult.MERGED : SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS) : SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
        if (mergeCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "checkList"));
        }
        return mergeCheckResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SvnMergeInfoCache.MergeCheckResult checkPath(@NotNull String repositoryRelativePath, long revisionNumber) {
        SvnMergeInfoCache.MergeCheckResult result;
        if (repositoryRelativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryRelativePath", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "checkPath"));
        }
        String sourceRelativePath = SVNPathUtil.getRelativePath((String)this.myMergeContext.getRepositoryRelativeSourcePath(), (String)SvnUtil.ensureStartSlash(repositoryRelativePath));
        if (sourceRelativePath == null) {
            result = SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS;
        } else {
            InfoProcessor processor = new InfoProcessor(sourceRelativePath, this.myMergeContext.getRepositoryRelativeSourcePath(), revisionNumber);
            Object object = this.myMergeInfoLock;
            synchronized (object) {
                this.myMergeInfoMap.getSimiliar((Object)OneShotMergeInfoHelper.toKey(sourceRelativePath), (PairProcessor)processor);
            }
            result = SvnMergeInfoCache.MergeCheckResult.getInstance(processor.isMerged());
        }
        SvnMergeInfoCache.MergeCheckResult mergeCheckResult = result;
        if (mergeCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "checkPath"));
        }
        return mergeCheckResult;
    }

    @NotNull
    private PropertyConsumer createPropertyHandler() {
        PropertyConsumer propertyConsumer = new PropertyConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleProperty(@NotNull File path, @NotNull PropertyData property) throws SVNException {
                Map<String, SVNMergeRangeList> mergeInfo;
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper$2", "handleProperty"));
                }
                if (property == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper$2", "handleProperty"));
                }
                String workingCopyRelativePath = OneShotMergeInfoHelper.this.getWorkingCopyRelativePath(path);
                try {
                    mergeInfo = BranchInfo.parseMergeInfo((PropertyValue)ObjectUtils.assertNotNull((Object)property.getValue()));
                }
                catch (SvnBindException e) {
                    throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.MERGE_INFO_PARSE_ERROR, (Throwable)((Object)e)), (Throwable)((Object)e));
                }
                Object object = OneShotMergeInfoHelper.this.myMergeInfoLock;
                synchronized (object) {
                    OneShotMergeInfoHelper.this.myMergeInfoMap.put((Object)OneShotMergeInfoHelper.toKey(workingCopyRelativePath), mergeInfo);
                }
            }

            @Override
            public void handleProperty(SVNURL url, PropertyData property) throws SVNException {
            }

            @Override
            public void handleProperty(long revision, PropertyData property) throws SVNException {
            }
        };
        if (propertyConsumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "createPropertyHandler"));
        }
        return propertyConsumer;
    }

    @NotNull
    private String getWorkingCopyRelativePath(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "getWorkingCopyRelativePath"));
        }
        String string = FileUtil.toSystemIndependentName((String)((String)ObjectUtils.assertNotNull((Object)FileUtil.getRelativePath((File)this.myMergeContext.getWcInfo().getRootInfo().getIoFile(), (File)file))));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "getWorkingCopyRelativePath"));
        }
        return string;
    }

    @NotNull
    private static String toKey(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "toKey"));
        }
        String string = SystemInfo.isFileSystemCaseSensitive ? path : path.toUpperCase();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "toKey"));
        }
        return string;
    }

    private static class InfoProcessor
    implements PairProcessor<String, Map<String, SVNMergeRangeList>> {
        @NotNull
        private final String myRepositoryRelativeSourcePath;
        private boolean myIsMerged;
        @NotNull
        private final String mySourceRelativePath;
        private final long myRevisionNumber;

        public InfoProcessor(@NotNull String sourceRelativePath, @NotNull String repositoryRelativeSourcePath, long revisionNumber) {
            if (sourceRelativePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRelativePath", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper$InfoProcessor", "<init>"));
            }
            if (repositoryRelativeSourcePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryRelativeSourcePath", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper$InfoProcessor", "<init>"));
            }
            this.mySourceRelativePath = sourceRelativePath;
            this.myRevisionNumber = revisionNumber;
            this.myRepositoryRelativeSourcePath = SvnUtil.ensureStartSlash(repositoryRelativeSourcePath);
        }

        public boolean isMerged() {
            return this.myIsMerged;
        }

        public boolean process(@NotNull String workingCopyRelativePath, @NotNull Map<String, SVNMergeRangeList> mergedPathsMap) {
            if (workingCopyRelativePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingCopyRelativePath", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper$InfoProcessor", "process"));
            }
            if (mergedPathsMap == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedPathsMap", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper$InfoProcessor", "process"));
            }
            boolean processed = false;
            final boolean isCurrentPath = workingCopyRelativePath.equals(this.mySourceRelativePath);
            if (mergedPathsMap.isEmpty()) {
                this.myIsMerged = false;
                processed = true;
            } else {
                String mergedPathAffectingSourcePath = (String)ContainerUtil.find(mergedPathsMap.keySet(), (Condition)new Condition<String>(){

                    public boolean value(String path) {
                        return SVNPathUtil.isAncestor((String)InfoProcessor.this.myRepositoryRelativeSourcePath, (String)SvnUtil.ensureStartSlash(path));
                    }
                });
                if (mergedPathAffectingSourcePath != null) {
                    SVNMergeRangeList mergeRangeList = mergedPathsMap.get(mergedPathAffectingSourcePath);
                    processed = true;
                    this.myIsMerged = ContainerUtil.or((Object[])mergeRangeList.getRanges(), (Condition)new Condition<SVNMergeRange>(){

                        public boolean value(@NotNull SVNMergeRange range) {
                            if (range == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper$InfoProcessor$2", "value"));
                            }
                            return BranchInfo.isInRange(range, InfoProcessor.this.myRevisionNumber) && (range.isInheritable() || isCurrentPath);
                        }
                    });
                }
            }
            return processed;
        }
    }
}

