/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.settings;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.settings.GradleProjectSettingsControlBuilder;
import org.jetbrains.plugins.gradle.service.settings.IdeaGradleProjectSettingsControlBuilder;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public abstract class GradleSettingsControlProvider {
    private static final ExtensionPointName<GradleSettingsControlProvider> EP_NAME = ExtensionPointName.create((String)"org.jetbrains.plugins.gradle.settingsControlProvider");

    public abstract String getPlatformPrefix();

    public abstract GradleProjectSettingsControlBuilder getProjectSettingsControlBuilder(@NotNull GradleProjectSettings var1);

    @NotNull
    public static GradleSettingsControlProvider get() {
        GradleSettingsControlProvider result = null;
        if (!PlatformUtils.isIntelliJ()) {
            String platformPrefix = PlatformUtils.getPlatformPrefix();
            for (GradleSettingsControlProvider provider : (GradleSettingsControlProvider[])EP_NAME.getExtensions()) {
                if (!StringUtil.equals((CharSequence)platformPrefix, (CharSequence)provider.getPlatformPrefix())) continue;
                assert (result == null) : "Multiple GradleSettingsControlProvider extensions found";
                result = provider;
            }
        }
        GradleSettingsControlProvider gradleSettingsControlProvider = (GradleSettingsControlProvider)ObjectUtils.notNull(result, (Object)new GradleSettingsControlProvider(){

            @Override
            public String getPlatformPrefix() {
                return null;
            }

            @Override
            public GradleProjectSettingsControlBuilder getProjectSettingsControlBuilder(@NotNull GradleProjectSettings initialSettings) {
                if (initialSettings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialSettings", "org/jetbrains/plugins/gradle/service/settings/GradleSettingsControlProvider$1", "getProjectSettingsControlBuilder"));
                }
                return new IdeaGradleProjectSettingsControlBuilder(initialSettings).dropUseBundledDistributionButton();
            }
        });
        if (gradleSettingsControlProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/settings/GradleSettingsControlProvider", "get"));
        }
        return gradleSettingsControlProvider;
    }
}

