/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.field;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduce.inplace.KeyboardComboSwitcher;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.introduceField.IntroduceFieldHandler;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrAbstractInplaceIntroducer;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrFinalListener;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrIntroduceFieldProcessor;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrIntroduceFieldSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GroovyInplaceFieldValidator;

public class GrInplaceFieldIntroducer
extends GrAbstractInplaceIntroducer<GrIntroduceFieldSettings> {
    private final EnumSet<GrIntroduceFieldSettings.Init> myApplicablePlaces;
    private GrInplaceIntroduceFieldPanel myPanel;
    private final GrFinalListener finalListener;
    private final String[] mySuggestedNames;
    private boolean myIsStatic;
    private final GrVariable myLocalVar;

    public GrInplaceFieldIntroducer(GrIntroduceContext context, OccurrencesChooser.ReplaceChoice choice) {
        super(IntroduceFieldHandler.REFACTORING_NAME, choice, context);
        this.finalListener = new GrFinalListener(this.myEditor);
        this.myLocalVar = GrIntroduceHandlerBase.resolveLocalVar(context);
        if (this.myLocalVar != null) {
            ArrayList result = ContainerUtil.newArrayList((Object[])new String[]{this.myLocalVar.getName()});
            GrExpression initializer = this.myLocalVar.getInitializerGroovy();
            if (initializer != null) {
                ContainerUtil.addAll((Collection)result, (Object[])GroovyNameSuggestionUtil.suggestVariableNames(initializer, new GroovyInplaceFieldValidator(this.getContext()), false));
            }
            this.mySuggestedNames = ArrayUtil.toStringArray((Collection)result);
        } else {
            this.mySuggestedNames = GroovyNameSuggestionUtil.suggestVariableNames(context.getExpression(), new GroovyInplaceFieldValidator(this.getContext()), false);
        }
        this.myApplicablePlaces = this.getApplicableInitPlaces();
    }

    @Nullable
    protected PsiElement checkLocalScope() {
        GrVariable variable = this.getVariable();
        if (variable instanceof PsiField) {
            return ((PsiField)this.getVariable()).getContainingClass();
        }
        PsiFile file = variable.getContainingFile();
        if (file instanceof GroovyFile) {
            return ((GroovyFile)file).getScriptClass();
        }
        return null;
    }

    @Override
    protected GrVariable runRefactoring(GrIntroduceContext context, GrIntroduceFieldSettings settings, boolean processUsages) {
        GrIntroduceFieldProcessor processor = new GrIntroduceFieldProcessor(context, settings);
        return processUsages ? processor.run() : processor.insertField((PsiClass)context.getScope()).getVariables()[0];
    }

    @Override
    @Nullable
    protected GrIntroduceFieldSettings getInitialSettingsForInplace(final @NotNull GrIntroduceContext context, final @NotNull OccurrencesChooser.ReplaceChoice choice, final String[] names) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrInplaceFieldIntroducer", "getInitialSettingsForInplace"));
        }
        if (choice == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "choice", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrInplaceFieldIntroducer", "getInitialSettingsForInplace"));
        }
        return new GrIntroduceFieldSettings(){

            @Override
            public boolean declareFinal() {
                return false;
            }

            @Override
            public GrIntroduceFieldSettings.Init initializeIn() {
                return GrIntroduceFieldSettings.Init.FIELD_DECLARATION;
            }

            @Override
            public String getVisibilityModifier() {
                return "private";
            }

            @Override
            public boolean isStatic() {
                boolean hasInstanceInScope = true;
                PsiClass clazz = (PsiClass)context.getScope();
                if (this.replaceAllOccurrences()) {
                    for (PsiElement occurrence : context.getOccurrences()) {
                        if (PsiUtil.hasEnclosingInstanceInScope(clazz, occurrence, false)) continue;
                        hasInstanceInScope = false;
                        break;
                    }
                } else if (context.getExpression() != null) {
                    hasInstanceInScope = PsiUtil.hasEnclosingInstanceInScope(clazz, context.getExpression(), false);
                } else if (context.getStringPart() != null) {
                    hasInstanceInScope = PsiUtil.hasEnclosingInstanceInScope(clazz, context.getStringPart().getLiteral(), false);
                }
                return !hasInstanceInScope;
            }

            @Override
            public boolean removeLocalVar() {
                return GrInplaceFieldIntroducer.this.myLocalVar != null;
            }

            @Override
            @Nullable
            public String getName() {
                return names[0];
            }

            @Override
            public boolean replaceAllOccurrences() {
                return context.getVar() != null || choice == OccurrencesChooser.ReplaceChoice.ALL;
            }

            @Override
            @Nullable
            public PsiType getSelectedType() {
                GrExpression expression = context.getExpression();
                GrVariable var = context.getVar();
                StringPartInfo stringPart = context.getStringPart();
                return var != null ? var.getDeclaredType() : (expression != null ? expression.getType() : (stringPart != null ? stringPart.getLiteral().getType() : null));
            }
        };
    }

    @Override
    protected GrIntroduceFieldSettings getSettings() {
        return new GrIntroduceFieldSettings(){

            @Override
            public boolean declareFinal() {
                return GrInplaceFieldIntroducer.this.myPanel.isFinal();
            }

            @Override
            public GrIntroduceFieldSettings.Init initializeIn() {
                return GrInplaceFieldIntroducer.this.myPanel.getInitPlace();
            }

            @Override
            public String getVisibilityModifier() {
                return "private";
            }

            @Override
            public boolean isStatic() {
                return GrInplaceFieldIntroducer.this.myIsStatic;
            }

            @Override
            public boolean removeLocalVar() {
                return GrInplaceFieldIntroducer.this.myLocalVar != null;
            }

            @Override
            @Nullable
            public String getName() {
                return GrInplaceFieldIntroducer.this.getInputName();
            }

            @Override
            public boolean replaceAllOccurrences() {
                return GrInplaceFieldIntroducer.this.isReplaceAllOccurrences();
            }

            @Override
            @Nullable
            public PsiType getSelectedType() {
                return GrInplaceFieldIntroducer.this.getSelectedType();
            }
        };
    }

    protected String getActionName() {
        return IntroduceFieldHandler.REFACTORING_NAME;
    }

    protected String[] suggestNames(boolean replaceAll, @Nullable GrVariable variable) {
        return this.mySuggestedNames;
    }

    protected void saveSettings(@NotNull GrVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrInplaceFieldIntroducer", "saveSettings"));
        }
    }

    @Override
    protected void restoreState(@NotNull GrVariable psiField) {
        if (psiField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiField", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrInplaceFieldIntroducer", "restoreState"));
        }
        this.myIsStatic = psiField.hasModifierProperty("static");
        super.restoreState(psiField);
    }

    @Nullable
    protected JComponent getComponent() {
        this.myPanel = new GrInplaceIntroduceFieldPanel();
        return this.myPanel.getRootPane();
    }

    private EnumSet<GrIntroduceFieldSettings.Init> getApplicableInitPlaces() {
        PsiElement anchor;
        PsiElement parent;
        PsiElement container;
        GrIntroduceContext context = this.getContext();
        PsiElement[] occurrences = this.getOccurrences();
        EnumSet<GrIntroduceFieldSettings.Init> result = EnumSet.noneOf(GrIntroduceFieldSettings.Init.class);
        if (context.getExpression() != null || context.getVar() != null && context.getVar().getInitializerGroovy() != null || context.getStringPart() != null) {
            result.add(GrIntroduceFieldSettings.Init.FIELD_DECLARATION);
        }
        if (!(context.getScope() instanceof GroovyScriptClass) && !(context.getScope() instanceof GroovyFileBase)) {
            result.add(GrIntroduceFieldSettings.Init.CONSTRUCTOR);
        }
        PsiElement scope = context.getScope();
        if (this.isReplaceAllOccurrences() && (container = GrIntroduceHandlerBase.getEnclosingContainer(parent = PsiTreeUtil.findCommonParent((PsiElement[])occurrences))) != null && (anchor = GrIntroduceHandlerBase.findAnchor(occurrences, container)) != null) {
            result.add(GrIntroduceFieldSettings.Init.CUR_METHOD);
        }
        if (scope instanceof GrTypeDefinition && TestFrameworks.getInstance().isTestClass((PsiClass)scope)) {
            result.add(GrIntroduceFieldSettings.Init.SETUP_METHOD);
        }
        return result;
    }

    public class GrInplaceIntroduceFieldPanel {
        private JPanel myRootPane;
        private JComboBox myInitCB;
        private NonFocusableCheckBox myDeclareFinalCB;
        private JComponent myPreview;

        public GrInplaceIntroduceFieldPanel() {
            this.$$$setupUI$$$();
            KeyboardComboSwitcher.setupActions((JComboBox)this.myInitCB, (Project)GrInplaceFieldIntroducer.this.myProject);
            for (GrIntroduceFieldSettings.Init place : GrInplaceFieldIntroducer.this.myApplicablePlaces) {
                this.myInitCB.addItem(place);
            }
            this.myDeclareFinalCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new WriteCommandAction(GrInplaceFieldIntroducer.this.myProject, GrInplaceFieldIntroducer.this.getCommandName(), GrInplaceFieldIntroducer.this.getCommandName(), new PsiFile[0]){

                        protected void run(Result result) throws Throwable {
                            PsiDocumentManager.getInstance((Project)GrInplaceFieldIntroducer.this.myProject).commitDocument(GrInplaceFieldIntroducer.this.myEditor.getDocument());
                            GrVariable variable = GrInplaceFieldIntroducer.this.getVariable();
                            if (variable != null) {
                                GrInplaceFieldIntroducer.this.finalListener.perform(GrInplaceIntroduceFieldPanel.this.myDeclareFinalCB.isSelected(), variable);
                            }
                        }
                    }.execute();
                }
            });
        }

        public JPanel getRootPane() {
            return this.myRootPane;
        }

        public GrIntroduceFieldSettings.Init getInitPlace() {
            return (GrIntroduceFieldSettings.Init)((Object)this.myInitCB.getSelectedItem());
        }

        public boolean isFinal() {
            return this.myDeclareFinalCB.isSelected();
        }

        private void createUIComponents() {
            this.myPreview = GrInplaceFieldIntroducer.this.getPreviewComponent();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            NonFocusableCheckBox nonFocusableCheckBox;
            JComboBox jComboBox;
            JPanel jPanel;
            this.createUIComponents();
            this.myRootPane = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
            JBLabel jBLabel = new JBLabel();
            jBLabel.setText("Initialize in:");
            jBLabel.setDisplayedMnemonic('I');
            jBLabel.setDisplayedMnemonicIndex(0);
            jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
            this.myInitCB = jComboBox = new JComboBox();
            jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
            this.myDeclareFinalCB = nonFocusableCheckBox = new NonFocusableCheckBox();
            nonFocusableCheckBox.setText("Declare final");
            nonFocusableCheckBox.setMnemonic('F');
            nonFocusableCheckBox.setDisplayedMnemonicIndex(8);
            nonFocusableCheckBox.setHorizontalAlignment(10);
            jPanel.add((Component)nonFocusableCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 3, null, null, null));
            JComponent jComponent = this.myPreview;
            jPanel.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
            jBLabel.setLabelFor(jComboBox);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myRootPane;
        }
    }
}

