/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixedValuesReferenceProvider
extends PsiReferenceProvider {
    private final String[] myValues;
    private final boolean mySoft;

    public FixedValuesReferenceProvider(@NotNull String[] values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "org/jetbrains/plugins/groovy/util/FixedValuesReferenceProvider", "<init>"));
        }
        this(values, false);
    }

    public FixedValuesReferenceProvider(@NotNull String[] values, boolean soft) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "org/jetbrains/plugins/groovy/util/FixedValuesReferenceProvider", "<init>"));
        }
        this.myValues = values;
        this.mySoft = soft;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/util/FixedValuesReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/util/FixedValuesReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase<PsiElement>(element, this.mySoft){

            @Nullable
            public PsiElement resolve() {
                return null;
            }

            @NotNull
            public Object[] getVariants() {
                Object[] objectArray = FixedValuesReferenceProvider.this.myValues;
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/FixedValuesReferenceProvider$1", "getVariants"));
                }
                return objectArray;
            }
        }};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/FixedValuesReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

