/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea;

import com.android.resources.ResourceType;
import com.android.tools.idea.model.ManifestInfo;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPsiUtils {
    @Nullable
    public static PsiFile getPsiFileSafely(final @NotNull Project project, final @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/AndroidPsiUtils", "getPsiFileSafely"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/AndroidPsiUtils", "getPsiFileSafely"));
        }
        return (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile>(){

            @Nullable
            public PsiFile compute() {
                return file.isValid() ? PsiManager.getInstance((Project)project).findFile(file) : null;
            }
        });
    }

    @Nullable
    public static Module getModuleSafely(final @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/AndroidPsiUtils", "getModuleSafely"));
        }
        return (Module)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module>(){

            @Nullable
            public Module compute() {
                return ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            }
        });
    }

    @Nullable
    public static Module getModuleSafely(final @NotNull Project project, final @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/AndroidPsiUtils", "getModuleSafely"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/AndroidPsiUtils", "getModuleSafely"));
        }
        return (Module)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module>(){

            @Nullable
            public Module compute() {
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                return psiFile == null ? null : ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
            }
        });
    }

    @Nullable
    public static XmlTag getRootTagSafely(final @NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/AndroidPsiUtils", "getRootTagSafely"));
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return file.getRootTag();
        }
        return (XmlTag)ApplicationManager.getApplication().runReadAction((Computable)new Computable<XmlTag>(){

            @Nullable
            public XmlTag compute() {
                return file.getRootTag();
            }
        });
    }

    @Nullable
    public static String getRootTagAttributeSafely(final @NotNull XmlFile file, final @NotNull String attribute, final @Nullable String namespace) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/AndroidPsiUtils", "getRootTagAttributeSafely"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/AndroidPsiUtils", "getRootTagAttributeSafely"));
        }
        Application application = ApplicationManager.getApplication();
        if (!application.isReadAccessAllowed()) {
            return (String)application.runReadAction((Computable)new Computable<String>(){

                @Nullable
                public String compute() {
                    return AndroidPsiUtils.getRootTagAttributeSafely(file, attribute, namespace);
                }
            });
        }
        XmlTag tag = file.getRootTag();
        if (tag != null) {
            XmlAttribute attr;
            XmlAttribute xmlAttribute = attr = namespace != null ? tag.getAttribute(attribute, namespace) : tag.getAttribute(attribute);
            if (attr != null) {
                return attr.getValue();
            }
        }
        return null;
    }

    @Nullable
    public static PsiDirectory getPsiDirectorySafely(final @NotNull Project project, final @NotNull VirtualFile dir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/AndroidPsiUtils", "getPsiDirectorySafely"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/android/tools/idea/AndroidPsiUtils", "getPsiDirectorySafely"));
        }
        return (PsiDirectory)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiDirectory>(){

            @Nullable
            public PsiDirectory compute() {
                return PsiManager.getInstance((Project)project).findDirectory(dir);
            }
        });
    }

    public static boolean isResourceReference(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/AndroidPsiUtils", "isResourceReference"));
        }
        return AndroidPsiUtils.getResourceReferenceType(element) != ResourceReferenceType.NONE;
    }

    @NotNull
    public static ResourceReferenceType getResourceReferenceType(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/AndroidPsiUtils", "getResourceReferenceType"));
        }
        if (element instanceof PsiReferenceExpression) {
            ResourceReferenceType resourceReferenceType = AndroidPsiUtils.getResourceReferenceType((PsiReferenceExpression)element);
            if (resourceReferenceType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/AndroidPsiUtils", "getResourceReferenceType"));
            }
            return resourceReferenceType;
        }
        if (element instanceof PsiIdentifier && element.getParent() instanceof PsiReferenceExpression) {
            ResourceReferenceType resourceReferenceType = AndroidPsiUtils.getResourceReferenceType((PsiReferenceExpression)element.getParent());
            if (resourceReferenceType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/AndroidPsiUtils", "getResourceReferenceType"));
            }
            return resourceReferenceType;
        }
        ResourceReferenceType resourceReferenceType = ResourceReferenceType.NONE;
        if (resourceReferenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/AndroidPsiUtils", "getResourceReferenceType"));
        }
        return resourceReferenceType;
    }

    @NotNull
    public static String getResourceName(@NotNull PsiElement element) {
        PsiReferenceExpression refExp;
        String name;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/AndroidPsiUtils", "getResourceName"));
        }
        assert (AndroidPsiUtils.isResourceReference(element));
        if (element instanceof PsiReferenceExpression && (name = (refExp = (PsiReferenceExpression)element).getReferenceName()) != null) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/AndroidPsiUtils", "getResourceName"));
            }
            return string;
        }
        String string = element.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/AndroidPsiUtils", "getResourceName"));
        }
        return string;
    }

    @NotNull
    public static ResourceReferenceType getResourceReferenceType(PsiReferenceExpression element) {
        PsiExpression exp = element.getQualifierExpression();
        if (!(exp instanceof PsiReferenceExpression)) {
            ResourceReferenceType resourceReferenceType = ResourceReferenceType.NONE;
            if (resourceReferenceType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/AndroidPsiUtils", "getResourceReferenceType"));
            }
            return resourceReferenceType;
        }
        if (!((exp = ((PsiReferenceExpression)exp).getQualifierExpression()) instanceof PsiReferenceExpression)) {
            ResourceReferenceType resourceReferenceType = ResourceReferenceType.NONE;
            if (resourceReferenceType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/AndroidPsiUtils", "getResourceReferenceType"));
            }
            return resourceReferenceType;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)exp;
        if ("R".equals(ref.getReferenceName())) {
            PsiExpression qualifierExpression = ref.getQualifierExpression();
            if (qualifierExpression instanceof PsiReferenceExpression && "android".equals(((PsiReferenceExpression)qualifierExpression).getReferenceName())) {
                ResourceReferenceType resourceReferenceType = ResourceReferenceType.FRAMEWORK;
                if (resourceReferenceType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/AndroidPsiUtils", "getResourceReferenceType"));
                }
                return resourceReferenceType;
            }
            ResourceReferenceType resourceReferenceType = ResourceReferenceType.APP;
            if (resourceReferenceType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/AndroidPsiUtils", "getResourceReferenceType"));
            }
            return resourceReferenceType;
        }
        ResourceReferenceType resourceReferenceType = ResourceReferenceType.NONE;
        if (resourceReferenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/AndroidPsiUtils", "getResourceReferenceType"));
        }
        return resourceReferenceType;
    }

    @Nullable
    public static ResourceType getResourceType(PsiElement resourceRefElement) {
        if (!AndroidPsiUtils.isResourceReference(resourceRefElement)) {
            return null;
        }
        PsiReferenceExpression exp = resourceRefElement instanceof PsiReferenceExpression ? (PsiReferenceExpression)resourceRefElement : (PsiReferenceExpression)resourceRefElement.getParent();
        PsiExpression qualifierExpression = exp.getQualifierExpression();
        if (qualifierExpression == null) {
            return null;
        }
        return ResourceType.getEnum((String)qualifierExpression.getLastChild().getText());
    }

    @Nullable
    public static String getDeclaredContextFqcn(@NotNull Module module, @NotNull XmlFile xmlFile) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/AndroidPsiUtils", "getDeclaredContextFqcn"));
        }
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/android/tools/idea/AndroidPsiUtils", "getDeclaredContextFqcn"));
        }
        String context = AndroidPsiUtils.getRootTagAttributeSafely(xmlFile, "context", "http://schemas.android.com/tools");
        if (context != null && !context.isEmpty()) {
            boolean startsWithDot;
            boolean bl = startsWithDot = context.charAt(0) == '.';
            if (startsWithDot || context.indexOf(46) == -1) {
                String pkg = ManifestInfo.get(module, false).getPackage();
                return startsWithDot ? pkg + context : pkg + '.' + context;
            }
        }
        return null;
    }

    @Nullable
    public static PsiClass getContextClass(@NotNull Module module, @NotNull XmlFile xmlFile) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/AndroidPsiUtils", "getContextClass"));
        }
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/android/tools/idea/AndroidPsiUtils", "getContextClass"));
        }
        String fqn = AndroidPsiUtils.getDeclaredContextFqcn(module, xmlFile);
        if (fqn != null) {
            Project project = module.getProject();
            return JavaPsiFacade.getInstance((Project)project).findClass(fqn, GlobalSearchScope.allScope((Project)project));
        }
        return null;
    }

    @Nullable
    public static String getQualifiedNameSafely(final @NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/android/tools/idea/AndroidPsiUtils", "getQualifiedNameSafely"));
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return psiClass.getQualifiedName();
        }
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            @Nullable
            public String compute() {
                return psiClass.getQualifiedName();
            }
        });
    }

    public static enum ResourceReferenceType {
        NONE,
        APP,
        FRAMEWORK;

    }
}

