/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.GradleTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaGradleProject
implements Serializable {
    @NotNull
    private final String myModuleName;
    @NotNull
    private final List<String> myTaskNames;
    @NotNull
    private final String myGradlePath;
    @Nullable
    private final File myBuildFile;

    public static IdeaGradleProject newIdeaGradleProject(@NotNull String moduleName, @NotNull GradleProject gradleProject, @Nullable File buildFile) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/IdeaGradleProject", "newIdeaGradleProject"));
        }
        if (gradleProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleProject", "com/android/tools/idea/gradle/IdeaGradleProject", "newIdeaGradleProject"));
        }
        ArrayList taskNames = Lists.newArrayList();
        DomainObjectSet tasks = gradleProject.getTasks();
        if (!tasks.isEmpty()) {
            for (GradleTask task : tasks) {
                String name = task.getName();
                if (Strings.isNullOrEmpty((String)name)) continue;
                taskNames.add(task.getProject().getPath() + ":" + task.getName());
            }
        }
        return new IdeaGradleProject(moduleName, taskNames, gradleProject.getPath(), buildFile);
    }

    public IdeaGradleProject(@NotNull String moduleName, @NotNull List<String> taskNames, @NotNull String gradlePath, @Nullable File buildFile) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/IdeaGradleProject", "<init>"));
        }
        if (taskNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskNames", "com/android/tools/idea/gradle/IdeaGradleProject", "<init>"));
        }
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/IdeaGradleProject", "<init>"));
        }
        this.myModuleName = moduleName;
        this.myTaskNames = taskNames;
        this.myGradlePath = gradlePath;
        this.myBuildFile = buildFile;
    }

    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaGradleProject", "getModuleName"));
        }
        return string;
    }

    @NotNull
    public String getGradlePath() {
        String string = this.myGradlePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaGradleProject", "getGradlePath"));
        }
        return string;
    }

    @NotNull
    public List<String> getTaskNames() {
        List<String> list = this.myTaskNames;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaGradleProject", "getTaskNames"));
        }
        return list;
    }

    @Nullable
    public VirtualFile getBuildFile() {
        return this.myBuildFile != null ? VfsUtil.findFileByIoFile((File)this.myBuildFile, (boolean)true) : null;
    }
}

