/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.tasks.ChangeListInfo;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.actions.BaseTaskAction;
import com.intellij.tasks.actions.CloseTaskDialog;
import com.intellij.tasks.impl.TaskManagerImpl;
import java.util.ArrayList;

public class CloseTaskAction
extends BaseTaskAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        assert (project != null);
        TaskManagerImpl taskManager = (TaskManagerImpl)TaskManager.getManager((Project)project);
        LocalTask task = taskManager.getActiveTask();
        CloseTaskDialog dialog = new CloseTaskDialog(project, task);
        if (dialog.showAndGet()) {
            CustomTaskState taskState = dialog.getCloseIssueState();
            if (taskState != null) {
                try {
                    TaskRepository repository = task.getRepository();
                    assert (repository != null);
                    repository.setTaskState((Task)task, taskState);
                    repository.setPreferredCloseTaskState(taskState);
                }
                catch (Exception e1) {
                    Messages.showErrorDialog((Project)project, (String)e1.getMessage(), (String)"Cannot Resolve Issue");
                }
            }
            if (dialog.isCommitChanges()) {
                ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
                for (ChangeListInfo info : task.getChangeLists()) {
                    LocalChangeList list = changeListManager.getChangeList(info.id);
                    if (list == null) continue;
                    changeListManager.commitChanges(list, new ArrayList(list.getChanges()));
                }
            }
            if (dialog.isMergeBranch()) {
                taskManager.mergeBranch(task);
            }
        }
    }

    @Override
    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project = CloseTaskAction.getProject(event);
        boolean enabled = project != null && !TaskManager.getManager((Project)project).getActiveTask().isDefault();
        presentation.setEnabled(enabled);
    }
}

