/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.collectors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.TextBuffer;
import org.jetbrains.java.decompiler.struct.StructContext;

public class ImportCollector {
    private static final String JAVA_LANG_PACKAGE = "java.lang";
    private Map<String, String> mapSimpleNames = new HashMap<String, String>();
    private Set<String> setNotImportedNames = new HashSet<String>();
    private String currentPackageSlash = "";
    private String currentPackagePoint = "";

    public ImportCollector(ClassesProcessor.ClassNode root) {
        String clname = root.classStruct.qualifiedName;
        int index = clname.lastIndexOf("/");
        if (index >= 0) {
            this.currentPackageSlash = clname.substring(0, index);
            this.currentPackagePoint = this.currentPackageSlash.replace('/', '.');
            this.currentPackageSlash = this.currentPackageSlash + "/";
        }
    }

    public String getShortName(String fullname) {
        return this.getShortName(fullname, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getShortName(String fullname, boolean imported) {
        StructContext context;
        boolean existsDefaultClass;
        ClassesProcessor clproc = DecompilerContext.getClassProcessor();
        ClassesProcessor.ClassNode node = clproc.getMapRootClasses().get(fullname.replace('.', '/'));
        String retname = null;
        if (node != null && node.classStruct.isOwn()) {
            retname = node.simpleName;
            while (node.parent != null && node.type == 1) {
                retname = node.parent.simpleName + "." + retname;
                node = node.parent;
            }
            if (node.type != 0) return retname;
            fullname = node.classStruct.qualifiedName;
            fullname = fullname.replace('/', '.');
        } else {
            fullname = fullname.replace('$', '.');
        }
        String nshort = fullname;
        String npackage = "";
        int lastpoint = fullname.lastIndexOf(".");
        if (lastpoint >= 0) {
            nshort = fullname.substring(lastpoint + 1);
            npackage = fullname.substring(0, lastpoint);
        }
        boolean bl = existsDefaultClass = (context = DecompilerContext.getStructContext()).getClass(this.currentPackageSlash + nshort) != null && !npackage.equals(this.currentPackagePoint) || context.getClass(nshort) != null && !this.currentPackagePoint.isEmpty();
        if (existsDefaultClass || this.mapSimpleNames.containsKey(nshort) && !npackage.equals(this.mapSimpleNames.get(nshort))) {
            return fullname;
        }
        if (this.mapSimpleNames.containsKey(nshort)) return retname == null ? nshort : retname;
        this.mapSimpleNames.put(nshort, npackage);
        if (imported) return retname == null ? nshort : retname;
        this.setNotImportedNames.add(nshort);
        return retname == null ? nshort : retname;
    }

    public int writeImports(TextBuffer buffer) {
        int importlines_written = 0;
        List<String> imports = this.packImports();
        for (String s : imports) {
            buffer.append("import ");
            buffer.append(s);
            buffer.append(";");
            buffer.appendLineSeparator();
            ++importlines_written;
        }
        return importlines_written;
    }

    private List<String> packImports() {
        ArrayList<Map.Entry<String, String>> lst = new ArrayList<Map.Entry<String, String>>(this.mapSimpleNames.entrySet());
        Collections.sort(lst, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> par0, Map.Entry<String, String> par1) {
                int res = par0.getValue().compareTo(par1.getValue());
                if (res == 0) {
                    res = par0.getKey().compareTo(par1.getKey());
                }
                return res;
            }
        });
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry entry : lst) {
            if (this.setNotImportedNames.contains(entry.getKey()) || JAVA_LANG_PACKAGE.equals(entry.getValue()) || ((String)entry.getValue()).isEmpty()) continue;
            res.add((String)entry.getValue() + "." + (String)entry.getKey());
        }
        return res;
    }
}

