/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UIBasedFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryContent
extends DiffContent {
    @NotNull
    private final Project myProject;
    @NotNull
    private final FileType myFileType;
    private final byte[] myBytes;
    private final Charset myCharset;
    private Document myDocument;
    private final String myFilePath;

    public BinaryContent(@NotNull Project project, byte[] bytes, @Nullable Charset charset, @NotNull FileType fileType, @Nullable String filePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/diff/BinaryContent", "<init>"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/diff/BinaryContent", "<init>"));
        }
        this.myDocument = null;
        this.myProject = project;
        this.myFileType = fileType;
        this.myBytes = bytes;
        this.myCharset = fileType.isBinary() ? null : charset;
        this.myFilePath = filePath;
    }

    public BinaryContent(byte[] bytes, Charset charset, @NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/diff/BinaryContent", "<init>"));
        }
        this(bytes, charset, fileType, null);
    }

    public BinaryContent(byte[] bytes, Charset charset, @NotNull FileType fileType, String filePath) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/diff/BinaryContent", "<init>"));
        }
        this(ProjectManager.getInstance().getDefaultProject(), bytes, charset, fileType, filePath);
    }

    @Override
    @Nullable
    public Document getDocument() {
        if (this.myDocument == null) {
            if (this.isBinary()) {
                return null;
            }
            String text = null;
            try {
                Charset charset = (Charset)ObjectUtils.notNull((Object)this.myCharset, (Object)EncodingProjectManager.getInstance(this.myProject).getDefaultCharset());
                text = CharsetToolkit.bytesToString((byte[])this.myBytes, (Charset)charset);
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
            if (text == null) {
                text = new String(this.myBytes);
            }
            text = LineTokenizer.correctLineSeparators(text);
            this.myDocument = EditorFactory.getInstance().createDocument(text);
            this.myDocument.setReadOnly(true);
        }
        return this.myDocument;
    }

    @Override
    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        VirtualFile file = this.findVirtualFile();
        return file == null ? null : new OpenFileDescriptor(this.myProject, file, offset);
    }

    @Nullable
    private VirtualFile findVirtualFile() {
        return LocalFileSystem.getInstance().findFileByIoFile(new File(this.myFilePath));
    }

    @Override
    @Nullable
    public VirtualFile getFile() {
        VirtualFile file;
        if (this.myFileType instanceof UIBasedFileType && (file = this.findVirtualFile()) != null) {
            LightVirtualFile lightFile = new LightVirtualFile(file, new String(this.myBytes), 1L);
            lightFile.setOriginalFile(file);
            return lightFile;
        }
        return null;
    }

    @Override
    @NotNull
    public FileType getContentType() {
        FileType fileType = this.myFileType;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/BinaryContent", "getContentType"));
        }
        return fileType;
    }

    @Override
    public byte[] getBytes() throws IOException {
        return this.myBytes;
    }

    @Override
    public boolean isBinary() {
        return this.myCharset == null;
    }
}

