/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.MultiRequestPositionManager;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerEx;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompoundPositionManager
extends PositionManagerEx
implements MultiRequestPositionManager {
    private static final Logger LOG = Logger.getInstance(CompoundPositionManager.class);
    private final ArrayList<PositionManager> myPositionManagers = new ArrayList();
    private Cache<Location, SourcePosition> mySourcePositionCache = new Cache();

    public CompoundPositionManager() {
    }

    public CompoundPositionManager(PositionManager manager) {
        this.appendPositionManager(manager);
    }

    public void appendPositionManager(PositionManager manager) {
        this.myPositionManagers.remove(manager);
        this.myPositionManagers.add(0, manager);
    }

    public SourcePosition getSourcePosition(Location location) {
        if (location == null) {
            return null;
        }
        SourcePosition res = this.mySourcePositionCache.get(location);
        if (res != null) {
            return res;
        }
        for (PositionManager positionManager : this.myPositionManagers) {
            try {
                res = positionManager.getSourcePosition(location);
                this.mySourcePositionCache.put(location, res);
                return res;
            }
            catch (NoDataException ignored) {
            }
            catch (VMDisconnectedException e) {
                throw e;
            }
            catch (InternalException ignored) {
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            catch (AssertionError e) {
                LOG.error((Throwable)((Object)e));
            }
        }
        return null;
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition classPosition) {
        if (classPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classPosition", "com/intellij/debugger/engine/CompoundPositionManager", "getAllClasses"));
        }
        for (PositionManager positionManager : this.myPositionManagers) {
            List list;
            try {
                list = positionManager.getAllClasses(classPosition);
            }
            catch (NoDataException ignored) {
                continue;
            }
            catch (VMDisconnectedException e) {
                throw e;
            }
            catch (InternalException ignored) {
                continue;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                continue;
            }
            catch (AssertionError e) {
                LOG.error((Throwable)((Object)e));
                continue;
            }
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/CompoundPositionManager", "getAllClasses"));
            }
            return list;
        }
        List<ReferenceType> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/CompoundPositionManager", "getAllClasses"));
        }
        return list;
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type, @NotNull SourcePosition position) {
        int line;
        LineNumbersMapping mapping;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/debugger/engine/CompoundPositionManager", "locationsOfLine"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/CompoundPositionManager", "locationsOfLine"));
        }
        VirtualFile file = position.getFile().getVirtualFile();
        if (file != null && (mapping = (LineNumbersMapping)file.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY)) != null && (line = mapping.sourceToBytecode(position.getLine() + 1)) > -1) {
            position = SourcePosition.createFromLine((PsiFile)position.getFile(), (int)(line - 1));
        }
        for (PositionManager positionManager : this.myPositionManagers) {
            List list;
            try {
                list = positionManager.locationsOfLine(type, position);
            }
            catch (NoDataException ignored) {
                continue;
            }
            catch (VMDisconnectedException e) {
                throw e;
            }
            catch (InternalException ignored) {
                continue;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                continue;
            }
            catch (AssertionError e) {
                LOG.error((Throwable)((Object)e));
                continue;
            }
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/CompoundPositionManager", "locationsOfLine"));
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/CompoundPositionManager", "locationsOfLine"));
        }
        return list;
    }

    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/debugger/engine/CompoundPositionManager", "createPrepareRequest"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/CompoundPositionManager", "createPrepareRequest"));
        }
        for (PositionManager positionManager : this.myPositionManagers) {
            try {
                return positionManager.createPrepareRequest(requestor, position);
            }
            catch (NoDataException ignored) {
            }
            catch (VMDisconnectedException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            catch (AssertionError e) {
                LOG.error((Throwable)((Object)e));
            }
        }
        return null;
    }

    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/debugger/engine/CompoundPositionManager", "createPrepareRequests"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/CompoundPositionManager", "createPrepareRequests"));
        }
        for (PositionManager positionManager : this.myPositionManagers) {
            List<ClassPrepareRequest> list;
            ClassPrepareRequest prepareRequest;
            block15: {
                block14: {
                    if (!(positionManager instanceof MultiRequestPositionManager)) break block14;
                    List list2 = ((MultiRequestPositionManager)positionManager).createPrepareRequests(requestor, position);
                    if (list2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/CompoundPositionManager", "createPrepareRequests"));
                    }
                    return list2;
                }
                prepareRequest = positionManager.createPrepareRequest(requestor, position);
                if (prepareRequest != null) break block15;
                List<ClassPrepareRequest> list3 = Collections.emptyList();
                if (list3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/CompoundPositionManager", "createPrepareRequests"));
                }
                return list3;
            }
            try {
                list = Collections.singletonList(prepareRequest);
            }
            catch (NoDataException ignored) {
                continue;
            }
            catch (VMDisconnectedException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                continue;
            }
            catch (AssertionError e) {
                LOG.error((Throwable)((Object)e));
                continue;
            }
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/CompoundPositionManager", "createPrepareRequests"));
            }
            return list;
        }
        List<ClassPrepareRequest> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/CompoundPositionManager", "createPrepareRequests"));
        }
        return list;
    }

    @Override
    @Nullable
    public XStackFrame createStackFrame(@NotNull StackFrameProxyImpl frame, @NotNull DebugProcessImpl debugProcess, @NotNull Location location) {
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/intellij/debugger/engine/CompoundPositionManager", "createStackFrame"));
        }
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/engine/CompoundPositionManager", "createStackFrame"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/debugger/engine/CompoundPositionManager", "createStackFrame"));
        }
        for (PositionManager positionManager : this.myPositionManagers) {
            if (!(positionManager instanceof PositionManagerEx)) continue;
            try {
                XStackFrame xStackFrame = ((PositionManagerEx)positionManager).createStackFrame(frame, debugProcess, location);
                if (xStackFrame == null) continue;
                return xStackFrame;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        return null;
    }

    @Override
    public ThreeState evaluateCondition(@NotNull EvaluationContext context, @NotNull StackFrameProxyImpl frame, @NotNull Location location, @NotNull String expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/debugger/engine/CompoundPositionManager", "evaluateCondition"));
        }
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/intellij/debugger/engine/CompoundPositionManager", "evaluateCondition"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/debugger/engine/CompoundPositionManager", "evaluateCondition"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/debugger/engine/CompoundPositionManager", "evaluateCondition"));
        }
        for (PositionManager positionManager : this.myPositionManagers) {
            if (!(positionManager instanceof PositionManagerEx)) continue;
            try {
                ThreeState result = ((PositionManagerEx)positionManager).evaluateCondition(context, frame, location, expression);
                if (result == ThreeState.UNSURE) continue;
                return result;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        return ThreeState.UNSURE;
    }

    private static class Cache<K, V> {
        private K myKey;
        private V myValue;

        private Cache() {
        }

        public V get(@NotNull K key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/debugger/engine/CompoundPositionManager$Cache", "get"));
            }
            if (key.equals(this.myKey)) {
                return this.myValue;
            }
            return null;
        }

        public void put(@NotNull K key, V value) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/debugger/engine/CompoundPositionManager$Cache", "put"));
            }
            this.myKey = key;
            this.myValue = value;
        }
    }
}

