/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions.impl;

import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SetEditorSettingsAction
extends ActionGroup
implements DumbAware {
    @NotNull
    private final TextDiffSettingsHolder.TextDiffSettings myTextSettings;
    @NotNull
    private final EditorSettingToggleAction[] myActions;

    @NotNull
    public abstract List<? extends Editor> getEditors();

    public SetEditorSettingsAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/actions/impl/SetEditorSettingsAction", "<init>"));
        }
        super("Editor Settings", null, AllIcons.General.SecondaryGroup);
        this.setPopup(true);
        this.myTextSettings = settings;
        this.myActions = new EditorSettingToggleAction[]{new EditorSettingToggleAction("EditorToggleShowWhitespaces"){

            @Override
            public boolean isSelected() {
                return SetEditorSettingsAction.this.myTextSettings.isShowWhitespaces();
            }

            @Override
            public void setSelected(boolean state) {
                SetEditorSettingsAction.this.myTextSettings.setShowWhiteSpaces(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/impl/SetEditorSettingsAction$1", "apply"));
                }
                if (editor.getSettings().isWhitespacesShown() != value) {
                    editor.getSettings().setWhitespacesShown(value);
                    editor.getComponent().repaint();
                }
            }
        }, new EditorSettingToggleAction("EditorToggleShowLineNumbers"){

            @Override
            public boolean isSelected() {
                return SetEditorSettingsAction.this.myTextSettings.isShowLineNumbers();
            }

            @Override
            public void setSelected(boolean state) {
                SetEditorSettingsAction.this.myTextSettings.setShowLineNumbers(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/impl/SetEditorSettingsAction$2", "apply"));
                }
                if (editor.getSettings().isLineNumbersShown() != value) {
                    editor.getSettings().setLineNumbersShown(value);
                    editor.getComponent().repaint();
                }
            }
        }, new EditorSettingToggleAction("EditorToggleShowIndentLines"){

            @Override
            public boolean isSelected() {
                return SetEditorSettingsAction.this.myTextSettings.isShowIndentLines();
            }

            @Override
            public void setSelected(boolean state) {
                SetEditorSettingsAction.this.myTextSettings.setShowIndentLines(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/impl/SetEditorSettingsAction$3", "apply"));
                }
                if (editor.getSettings().isIndentGuidesShown() != value) {
                    editor.getSettings().setIndentGuidesShown(value);
                    editor.getComponent().repaint();
                }
            }
        }, new EditorSettingToggleAction("EditorToggleUseSoftWraps"){

            @Override
            public boolean isSelected() {
                return SetEditorSettingsAction.this.myTextSettings.isUseSoftWraps();
            }

            @Override
            public void setSelected(boolean state) {
                SetEditorSettingsAction.this.myTextSettings.setUseSoftWraps(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/impl/SetEditorSettingsAction$4", "apply"));
                }
                if (editor.getSettings().isUseSoftWraps() != value) {
                    editor.getSettings().setUseSoftWraps(value);
                }
            }
        }};
    }

    public void applyDefaults() {
        for (Editor editor : this.getEditors()) {
            for (EditorSettingToggleAction action : this.myActions) {
                action.apply(editor, action.isSelected());
            }
        }
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (this.myActions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/impl/SetEditorSettingsAction", "getChildren"));
        }
        return this.myActions;
    }

    private abstract class EditorSettingToggleAction
    extends ToggleAction
    implements DumbAware {
        private EditorSettingToggleAction(String actionId) {
            if (actionId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/diff/actions/impl/SetEditorSettingsAction$EditorSettingToggleAction", "<init>"));
            }
            super(ActionsBundle.actionText((String)actionId), ActionsBundle.actionDescription((String)actionId), null);
        }

        public boolean isSelected(AnActionEvent e) {
            return this.isSelected();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            for (Editor editor : SetEditorSettingsAction.this.getEditors()) {
                this.setSelected(state);
                this.apply(editor, state);
            }
        }

        public abstract boolean isSelected();

        public abstract void setSelected(boolean var1);

        public abstract void apply(@NotNull Editor var1, boolean var2);
    }
}

