/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.fragments.DiffFragment;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangedBlock {
    private final int myStartOffset1;
    private final int myEndOffset1;
    private final int myStartOffset2;
    private final int myEndOffset2;
    private final int myLine1;
    private final int myLine2;
    @Nullable
    private final List<DiffFragment> myInnerFragments;

    public ChangedBlock(int startOffset1, int endOffset1, int startOffset2, int endOffset2, int line1, int line2, @Nullable List<DiffFragment> innerFragments) {
        this.myStartOffset1 = startOffset1;
        this.myEndOffset1 = endOffset1;
        this.myStartOffset2 = startOffset2;
        this.myEndOffset2 = endOffset2;
        this.myLine1 = line1;
        this.myLine2 = line2;
        this.myInnerFragments = innerFragments;
    }

    @NotNull
    public static ChangedBlock createInserted(int length, int lines) {
        ChangedBlock changedBlock = new ChangedBlock(0, 0, 0, length, 0, lines, null);
        if (changedBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/ChangedBlock", "createInserted"));
        }
        return changedBlock;
    }

    @NotNull
    public static ChangedBlock createDeleted(int length, int lines) {
        ChangedBlock changedBlock = new ChangedBlock(0, length, 0, 0, 0, lines, null);
        if (changedBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/ChangedBlock", "createDeleted"));
        }
        return changedBlock;
    }

    public int getStartOffset1() {
        return this.myStartOffset1;
    }

    public int getEndOffset1() {
        return this.myEndOffset1;
    }

    public int getStartOffset2() {
        return this.myStartOffset2;
    }

    public int getEndOffset2() {
        return this.myEndOffset2;
    }

    public int getLine1() {
        return this.myLine1;
    }

    public int getLine2() {
        return this.myLine2;
    }

    public boolean hasInsertion() {
        return this.myStartOffset2 != this.myEndOffset2;
    }

    public boolean hasDeletion() {
        return this.myStartOffset1 != this.myEndOffset1;
    }

    @Nullable
    public List<DiffFragment> getInnerFragments() {
        return this.myInnerFragments;
    }
}

