/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextDiffTypeFactory {
    private static final TextDiffTypeFactory ourInstance = new TextDiffTypeFactory();
    private final List<TextDiffType> myTypes = new ArrayList<TextDiffType>();
    private static final double MIDDLE_COLOR_FACTOR = 0.6;

    private TextDiffTypeFactory() {
    }

    @NotNull
    public synchronized TextDiffType createTextDiffType(@NonNls @NotNull TextAttributesKey key, @NotNull String name) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/util/TextDiffTypeFactory", "createTextDiffType"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/diff/util/TextDiffTypeFactory", "createTextDiffType"));
        }
        TextDiffTypeImpl type = new TextDiffTypeImpl(key, name);
        this.myTypes.add(type);
        TextDiffTypeImpl textDiffTypeImpl = type;
        if (textDiffTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory", "createTextDiffType"));
        }
        return textDiffTypeImpl;
    }

    public synchronized TextDiffType[] getAllDiffTypes() {
        return this.myTypes.toArray(new TextDiffType[this.myTypes.size()]);
    }

    public static TextDiffTypeFactory getInstance() {
        return ourInstance;
    }

    @NotNull
    private static Color getMiddleColor(@NotNull Color fg, @NotNull Color bg) {
        if (fg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fg", "com/intellij/diff/util/TextDiffTypeFactory", "getMiddleColor"));
        }
        if (bg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bg", "com/intellij/diff/util/TextDiffTypeFactory", "getMiddleColor"));
        }
        int red = TextDiffTypeFactory.avg(fg.getRed(), bg.getRed(), 0.6);
        int green = TextDiffTypeFactory.avg(fg.getGreen(), bg.getGreen(), 0.6);
        int blue = TextDiffTypeFactory.avg(fg.getBlue(), bg.getBlue(), 0.6);
        Color color = new Color(red, green, blue);
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory", "getMiddleColor"));
        }
        return color;
    }

    private static int avg(int fg, int bg, double factor) {
        return (int)((long)fg + Math.round(factor * (double)(bg - fg)));
    }

    private static class TextDiffTypeImpl
    implements TextDiffType {
        @NotNull
        private final TextAttributesKey myKey;
        @NotNull
        private final String myName;

        public TextDiffTypeImpl(@NotNull TextAttributesKey key, @NotNull String name) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "<init>"));
            }
            this.myKey = key;
            this.myName = name;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "getName"));
            }
            return string;
        }

        @NotNull
        public TextAttributes getAttributes(@Nullable Editor editor) {
            if (editor == null) {
                TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(this.myKey);
                if (textAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "getAttributes"));
                }
                return textAttributes;
            }
            TextAttributes textAttributes = editor.getColorsScheme().getAttributes(this.myKey);
            if (textAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "getAttributes"));
            }
            return textAttributes;
        }

        @Override
        @NotNull
        public Color getColor(@Nullable Editor editor) {
            Color color = this.getAttributes(editor).getBackgroundColor();
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "getColor"));
            }
            return color;
        }

        @Override
        @NotNull
        public Color getIgnoredColor(@Nullable Editor editor) {
            TextAttributes attributes = this.getAttributes(editor);
            Color color = attributes.getForegroundColor();
            if (color != null) {
                Color color2 = color;
                if (color2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "getIgnoredColor"));
                }
                return color2;
            }
            if (editor instanceof EditorEx) {
                Color fg = attributes.getBackgroundColor();
                Color bg = ((EditorEx)editor).getBackgroundColor();
                Color color3 = TextDiffTypeFactory.getMiddleColor(fg, bg);
                if (color3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "getIgnoredColor"));
                }
                return color3;
            }
            Color fg = attributes.getBackgroundColor();
            Color bg = EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
            Color color4 = TextDiffTypeFactory.getMiddleColor(fg, bg);
            if (color4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "getIgnoredColor"));
            }
            return color4;
        }

        @Override
        @NotNull
        public Color getMarkerColor(@Nullable Editor editor) {
            Color color = this.getAttributes(editor).getErrorStripeColor();
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "getMarkerColor"));
            }
            return color;
        }
    }
}

