/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push;

import com.intellij.CommonBundle;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.CommitLoader;
import com.intellij.dvcs.push.OutgoingResult;
import com.intellij.dvcs.push.PushSettings;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.Pusher;
import com.intellij.dvcs.push.RepositoryNodeListener;
import com.intellij.dvcs.push.VcsError;
import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.push.ui.CheckBoxModel;
import com.intellij.dvcs.push.ui.CommitNode;
import com.intellij.dvcs.push.ui.PushLog;
import com.intellij.dvcs.push.ui.RepositoryNode;
import com.intellij.dvcs.push.ui.RepositoryWithBranchPanel;
import com.intellij.dvcs.push.ui.SingleRepositoryNode;
import com.intellij.dvcs.push.ui.TextWithLinkNode;
import com.intellij.dvcs.push.ui.VcsLinkListener;
import com.intellij.dvcs.push.ui.VcsLinkedTextComponent;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PushController
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<? extends Repository> myPreselectedRepositories;
    @NotNull
    private final VcsRepositoryManager myGlobalRepositoryManager;
    @NotNull
    private final List<PushSupport<? extends Repository, ? extends PushSource, ? extends PushTarget>> myPushSupports;
    @NotNull
    private final PushLog myPushLog;
    @NotNull
    private final VcsPushDialog myDialog;
    @NotNull
    private final PushSettings myPushSettings;
    @NotNull
    private final Set<String> myExcludedRepositoryRoots;
    @Nullable
    private final Repository myCurrentlyOpenedRepository;
    private final boolean mySingleRepoProject;
    private static final int DEFAULT_CHILDREN_PRESENTATION_NUMBER = 20;
    private final ExecutorService myExecutorService;
    private final Map<RepositoryNode, MyRepoModel<?, ?, ?>> myView2Model;

    public PushController(@NotNull Project project, @NotNull VcsPushDialog dialog, @NotNull List<? extends Repository> preselectedRepositories, @Nullable Repository currentRepo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/push/PushController", "<init>"));
        }
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/dvcs/push/PushController", "<init>"));
        }
        if (preselectedRepositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preselectedRepositories", "com/intellij/dvcs/push/PushController", "<init>"));
        }
        this.myExecutorService = Executors.newSingleThreadExecutor();
        this.myView2Model = new TreeMap();
        this.myProject = project;
        this.myPushSettings = (PushSettings)ServiceManager.getService((Project)project, PushSettings.class);
        this.myGlobalRepositoryManager = (VcsRepositoryManager)((Object)ServiceManager.getService((Project)project, VcsRepositoryManager.class));
        this.myExcludedRepositoryRoots = ContainerUtil.newHashSet((Iterable)this.myPushSettings.getExcludedRepoRoots());
        this.myPreselectedRepositories = preselectedRepositories;
        this.myCurrentlyOpenedRepository = currentRepo;
        this.myPushSupports = this.getAffectedSupports(this.myProject);
        this.mySingleRepoProject = this.isSingleRepoProject();
        this.myDialog = dialog;
        CheckedTreeNode rootNode = new CheckedTreeNode(null);
        this.createTreeModel(rootNode);
        this.myPushLog = new PushLog(this.myProject, rootNode, this.isSyncStrategiesAllowed());
        this.myPushLog.getTree().addPropertyChangeListener("tree.edit.mode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean isEditMode = (Boolean)evt.getNewValue();
                if (isEditMode.booleanValue()) {
                    PushController.this.myDialog.disableOkActions();
                }
            }
        });
        this.startLoadingCommits();
        Disposer.register((Disposable)dialog.getDisposable(), (Disposable)this);
    }

    private boolean isSyncStrategiesAllowed() {
        return !this.mySingleRepoProject && ContainerUtil.and(this.getAffectedSupports(this.myProject), (Condition)new Condition<PushSupport<? extends Repository, ? extends PushSource, ? extends PushTarget>>(){

            public boolean value(PushSupport<? extends Repository, ? extends PushSource, ? extends PushTarget> support) {
                return support.mayChangeTargetsSync();
            }
        });
    }

    private boolean isSingleRepoProject() {
        return this.myGlobalRepositoryManager.getRepositories().size() == 1;
    }

    @NotNull
    private List<PushSupport<? extends Repository, ? extends PushSource, ? extends PushTarget>> getAffectedSupports(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/push/PushController", "getAffectedSupports"));
        }
        final Collection<Repository> repositories = this.myGlobalRepositoryManager.getRepositories();
        List list = ContainerUtil.filter((Object[])Extensions.getExtensions((ExtensionPointName)PushSupport.PUSH_SUPPORT_EP, (AreaInstance)project), (Condition)new Condition<PushSupport>(){

            public boolean value(final PushSupport support) {
                return ContainerUtil.exists((Iterable)repositories, (Condition)new Condition<Repository>(){

                    public boolean value(Repository repository) {
                        return support.getVcs().equals((Object)repository.getVcs());
                    }
                });
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "getAffectedSupports"));
        }
        return list;
    }

    public boolean isForcePushEnabled() {
        return ContainerUtil.exists(this.myView2Model.values(), (Condition)new Condition<MyRepoModel<?, ?, ?>>(){

            public boolean value(MyRepoModel<?, ?, ?> model) {
                return model.getSupport().isForcePushEnabled();
            }
        });
    }

    @Nullable
    public PushTarget getProhibitedTarget() {
        MyRepoModel model = (MyRepoModel)ContainerUtil.find(this.myView2Model.values(), (Condition)new Condition<MyRepoModel>(){

            public boolean value(MyRepoModel model) {
                Object target = model.getTarget();
                return model.isSelected() && target != null && !model.getSupport().isForcePushAllowed(model.getRepository(), target);
            }
        });
        return model != null ? (PushTarget)model.getTarget() : null;
    }

    private void startLoadingCommits() {
        LinkedHashMap priorityLoading = ContainerUtil.newLinkedHashMap();
        LinkedHashMap others = ContainerUtil.newLinkedHashMap();
        RepositoryNode nodeForCurrentEditor = this.findNodeByRepo(this.myCurrentlyOpenedRepository);
        for (Map.Entry<RepositoryNode, MyRepoModel<?, ?, ?>> entry : this.myView2Model.entrySet()) {
            MyRepoModel<?, ?, ?> model = entry.getValue();
            Object repository = model.getRepository();
            RepositoryNode repoNode = entry.getKey();
            if (this.preselectByUser((Repository)repository)) {
                priorityLoading.put(repoNode, model);
                continue;
            }
            if (!model.getSupport().shouldRequestIncomingChangesForNotCheckedRepositories() || repoNode.equals(nodeForCurrentEditor)) continue;
            others.put(repoNode, model);
        }
        if (nodeForCurrentEditor != null) {
            priorityLoading.put(nodeForCurrentEditor, this.myView2Model.get(nodeForCurrentEditor));
        }
        this.loadCommitsFromMap(priorityLoading);
        this.loadCommitsFromMap(others);
    }

    @Nullable
    private RepositoryNode findNodeByRepo(final @Nullable Repository repository) {
        if (repository == null) {
            return null;
        }
        Map.Entry entry = (Map.Entry)ContainerUtil.find(this.myView2Model.entrySet(), (Condition)new Condition<Map.Entry<RepositoryNode, MyRepoModel<?, ?, ?>>>(){

            public boolean value(Map.Entry<RepositoryNode, MyRepoModel<?, ?, ?>> entry) {
                MyRepoModel<?, ?, ?> model = entry.getValue();
                return model.getRepository().getRoot().equals(repository.getRoot());
            }
        });
        return entry != null ? (RepositoryNode)entry.getKey() : null;
    }

    private void loadCommitsFromMap(@NotNull Map<RepositoryNode, MyRepoModel> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/dvcs/push/PushController", "loadCommitsFromMap"));
        }
        for (Map.Entry<RepositoryNode, MyRepoModel> entry : items.entrySet()) {
            RepositoryNode node = entry.getKey();
            this.loadCommits(entry.getValue(), node, true);
        }
    }

    private void createTreeModel(@NotNull CheckedTreeNode rootNode) {
        if (rootNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootNode", "com/intellij/dvcs/push/PushController", "createTreeModel"));
        }
        for (Repository repository : DvcsUtil.sortRepositories(this.myGlobalRepositoryManager.getRepositories())) {
            this.createRepoNode(repository, rootNode);
        }
    }

    @Nullable
    private <R extends Repository, S extends PushSource, T extends PushTarget> PushSupport<R, S, T> getPushSupportByRepository(final @NotNull R repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/push/PushController", "getPushSupportByRepository"));
        }
        return (PushSupport)ContainerUtil.find(this.myPushSupports, (Condition)new Condition<PushSupport<? extends Repository, ? extends PushSource, ? extends PushTarget>>(){

            public boolean value(PushSupport<? extends Repository, ? extends PushSource, ? extends PushTarget> support) {
                return support.getVcs().equals((Object)repository.getVcs());
            }
        });
    }

    private <R extends Repository, S extends PushSource, T extends PushTarget> void createRepoNode(@NotNull R repository, @NotNull CheckedTreeNode rootNode) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/push/PushController", "createRepoNode"));
        }
        if (rootNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootNode", "com/intellij/dvcs/push/PushController", "createRepoNode"));
        }
        PushSupport<R, S, T> support = this.getPushSupportByRepository(repository);
        if (support == null) {
            return;
        }
        PushTarget target = support.getDefaultTarget(repository);
        String repoName = this.getDisplayedRepoName(repository);
        PushSource source = support.getSource(repository);
        final MyRepoModel<R, PushSource, PushTarget> model = new MyRepoModel<R, PushSource, PushTarget>(repository, support, this.mySingleRepoProject, source, target);
        if (target == null) {
            model.setError(VcsError.createEmptyTargetError((String)repoName));
        }
        PushTargetPanel pushTargetPanel = support.createTargetPanel(repository, target);
        final RepositoryWithBranchPanel repoPanel = new RepositoryWithBranchPanel(this.myProject, repoName, source.getPresentation(), pushTargetPanel);
        CheckBoxModel checkBoxModel = model.getCheckBoxModel();
        final RepositoryNode repoNode = this.mySingleRepoProject ? new SingleRepositoryNode(repoPanel, checkBoxModel) : new RepositoryNode(repoPanel, checkBoxModel, target != null);
        pushTargetPanel.setFireOnChangeAction(new Runnable(){

            @Override
            public void run() {
                repoPanel.fireOnChange();
                ((DefaultTreeModel)PushController.this.myPushLog.getTree().getModel()).nodeChanged((TreeNode)((Object)repoNode));
            }
        });
        this.myView2Model.put(repoNode, model);
        repoPanel.addRepoNodeListener(new RepositoryNodeListener<T>(){

            @Override
            public void onTargetChanged(T newTarget) {
                repoNode.setChecked(true);
                PushController.this.myExcludedRepositoryRoots.remove(model.getRepository().getRoot().getPath());
                if (!newTarget.equals(model.getTarget()) || model.hasError() || !model.hasCommitInfo()) {
                    model.setTarget(newTarget);
                    model.clearErrors();
                    PushController.this.loadCommits(model, repoNode, false);
                }
            }

            @Override
            public void onSelectionChanged(boolean isSelected) {
                PushController.this.myDialog.updateOkActions();
                if (isSelected) {
                    boolean forceLoad = PushController.this.myExcludedRepositoryRoots.remove(model.getRepository().getRoot().getPath());
                    if (!(model.hasCommitInfo() || !forceLoad && model.getSupport().shouldRequestIncomingChangesForNotCheckedRepositories())) {
                        PushController.this.loadCommits(model, repoNode, false);
                    }
                } else {
                    PushController.this.myExcludedRepositoryRoots.add(model.getRepository().getRoot().getPath());
                }
            }

            @Override
            public void onTargetInEditMode(@NotNull String currentValue) {
                if (currentValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentValue", "com/intellij/dvcs/push/PushController$9", "onTargetInEditMode"));
                }
                PushController.this.myPushLog.fireEditorUpdated(currentValue);
            }
        });
        rootNode.add((MutableTreeNode)((Object)repoNode));
    }

    @NotNull
    private String getDisplayedRepoName(@NotNull Repository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/push/PushController", "getDisplayedRepoName"));
        }
        String name = DvcsUtil.getShortRepositoryName(repository);
        int slash = name.lastIndexOf(File.separatorChar);
        if (slash < 0) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "getDisplayedRepoName"));
            }
            return string;
        }
        String candidate = name.substring(slash + 1);
        String string = !this.containedInOtherNames(repository, candidate) ? candidate : name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "getDisplayedRepoName"));
        }
        return string;
    }

    private boolean containedInOtherNames(final @NotNull Repository except, final String candidate) {
        if (except == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "except", "com/intellij/dvcs/push/PushController", "containedInOtherNames"));
        }
        return ContainerUtil.exists(this.myGlobalRepositoryManager.getRepositories(), (Condition)new Condition<Repository>(){

            public boolean value(Repository repository) {
                return !repository.equals(except) && repository.getRoot().getName().equals(candidate);
            }
        });
    }

    public boolean isPushAllowed(final boolean force) {
        JTree tree = this.myPushLog.getTree();
        return !tree.isEditing() && ContainerUtil.exists(this.myPushSupports, (Condition)new Condition<PushSupport<? extends Repository, ? extends PushSource, ? extends PushTarget>>(){

            public boolean value(PushSupport<? extends Repository, ? extends PushSource, ? extends PushTarget> support) {
                return PushController.this.isPushAllowed(support, force);
            }
        });
    }

    private boolean isPushAllowed(@NotNull PushSupport<?, ?, ?> pushSupport, boolean force) {
        if (pushSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pushSupport", "com/intellij/dvcs/push/PushController", "isPushAllowed"));
        }
        Collection<RepositoryNode> nodes = this.getNodesForSupport(pushSupport);
        if (this.hasSomethingToPush(nodes)) {
            return true;
        }
        if (this.hasCheckedNodesWithContent(nodes, force || this.myDialog.getAdditionalOptionValue(pushSupport) != null)) {
            return !pushSupport.getRepositoryManager().isSyncEnabled() || PushController.allNodesAreLoaded(nodes);
        }
        return false;
    }

    private boolean hasSomethingToPush(Collection<RepositoryNode> nodes) {
        return ContainerUtil.exists(nodes, (Condition)new Condition<RepositoryNode>(){

            public boolean value(@NotNull RepositoryNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dvcs/push/PushController$12", "value"));
                }
                Object target = ((MyRepoModel)PushController.this.myView2Model.get(node)).getTarget();
                return (node.isChecked() || node.isLoading()) && target != null && target.hasSomethingToPush();
            }
        });
    }

    private boolean hasCheckedNodesWithContent(@NotNull Collection<RepositoryNode> nodes, final boolean withRefs) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/dvcs/push/PushController", "hasCheckedNodesWithContent"));
        }
        return ContainerUtil.exists(nodes, (Condition)new Condition<RepositoryNode>(){

            public boolean value(@NotNull RepositoryNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dvcs/push/PushController$13", "value"));
                }
                return node.isChecked() && (withRefs || !((MyRepoModel)PushController.this.myView2Model.get(node)).getLoadedCommits().isEmpty());
            }
        });
    }

    @NotNull
    private Collection<RepositoryNode> getNodesForSupport(final PushSupport<?, ?, ?> support) {
        List list = ContainerUtil.mapNotNull(this.myView2Model.entrySet(), (Function)new Function<Map.Entry<RepositoryNode, MyRepoModel<?, ?, ?>>, RepositoryNode>(){

            public RepositoryNode fun(Map.Entry<RepositoryNode, MyRepoModel<?, ?, ?>> entry) {
                return support.equals(entry.getValue().getSupport()) ? entry.getKey() : null;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "getNodesForSupport"));
        }
        return list;
    }

    private static boolean allNodesAreLoaded(@NotNull Collection<RepositoryNode> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/dvcs/push/PushController", "allNodesAreLoaded"));
        }
        return !ContainerUtil.exists(nodes, (Condition)new Condition<RepositoryNode>(){

            public boolean value(@NotNull RepositoryNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dvcs/push/PushController$15", "value"));
                }
                return node.isLoading();
            }
        });
    }

    private <R extends Repository, S extends PushSource, T extends PushTarget> void loadCommits(final @NotNull MyRepoModel<R, S, T> model, final @NotNull RepositoryNode node, final boolean initial) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dvcs/push/PushController", "loadCommits"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dvcs/push/PushController", "loadCommits"));
        }
        node.cancelLoading();
        T target = model.getTarget();
        if (target == null) {
            node.stopLoading();
            return;
        }
        node.setEnabled(true);
        final PushSupport<R, S, T> support = model.getSupport();
        final AtomicReference result = new AtomicReference();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                Object repository = model.getRepository();
                OutgoingResult outgoing = support.getOutgoingCommitsProvider().getOutgoingCommits(repository, new PushSpec(model.getSource(), model.getTarget()), initial);
                result.compareAndSet(null, outgoing);
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        boolean shouldBeSelected;
                        OutgoingResult outgoing = (OutgoingResult)result.get();
                        List errors = outgoing.getErrors();
                        if (!errors.isEmpty()) {
                            shouldBeSelected = false;
                            model.setLoadedCommits(ContainerUtil.emptyList());
                            PushController.this.myPushLog.setChildren((DefaultMutableTreeNode)((Object)node), ContainerUtil.map((Collection)errors, (Function)new Function<VcsError, DefaultMutableTreeNode>(){

                                public DefaultMutableTreeNode fun(final VcsError error) {
                                    VcsLinkedTextComponent errorLinkText = new VcsLinkedTextComponent(error.getText(), new VcsLinkListener(){

                                        @Override
                                        public void hyperlinkActivated(@NotNull DefaultMutableTreeNode sourceNode, @NotNull MouseEvent event) {
                                            if (sourceNode == null) {
                                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNode", "com/intellij/dvcs/push/PushController$16$1$1$1", "hyperlinkActivated"));
                                            }
                                            if (event == null) {
                                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/dvcs/push/PushController$16$1$1$1", "hyperlinkActivated"));
                                            }
                                            error.handleError(new CommitLoader(){

                                                public void reloadCommits() {
                                                    PushController.this.loadCommits(model, node, false);
                                                }
                                            });
                                        }
                                    });
                                    return new TextWithLinkNode(errorLinkText);
                                }
                            }));
                        } else {
                            List commits = outgoing.getCommits();
                            model.setLoadedCommits(commits);
                            shouldBeSelected = PushController.this.shouldSelect(model);
                            PushController.this.myPushLog.setChildren((DefaultMutableTreeNode)((Object)node), PushController.this.getPresentationForCommits(PushController.this.myProject, model.getLoadedCommits(), model.getNumberOfShownCommits()));
                            if (!commits.isEmpty()) {
                                PushController.this.myPushLog.selectIfNothingSelected((TreeNode)((Object)node));
                            }
                        }
                        node.stopLoading();
                        if (shouldBeSelected) {
                            node.setChecked(true);
                        }
                        PushController.this.myDialog.updateOkActions();
                    }
                });
            }
        };
        node.startLoading(this.myPushLog.getTree(), this.myExecutorService.submit(task, result), initial);
    }

    private boolean shouldSelect(@NotNull MyRepoModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dvcs/push/PushController", "shouldSelect"));
        }
        if (this.mySingleRepoProject) {
            return true;
        }
        Object repository = model.getRepository();
        return PushController.hasCommitsToPush(model) && (this.preselectByUser((Repository)repository) || this.notExcludedByUser((Repository)repository));
    }

    private boolean notExcludedByUser(@NotNull Repository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/push/PushController", "notExcludedByUser"));
        }
        return !this.myExcludedRepositoryRoots.contains(repository.getRoot().getPath());
    }

    private boolean preselectByUser(@NotNull Repository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/push/PushController", "preselectByUser"));
        }
        return this.myPreselectedRepositories.contains(repository);
    }

    private static boolean hasCommitsToPush(@NotNull MyRepoModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dvcs/push/PushController", "hasCommitsToPush"));
        }
        Object target = model.getTarget();
        assert (target != null);
        return !model.getLoadedCommits().isEmpty() || target.hasSomethingToPush();
    }

    public PushLog getPushPanelLog() {
        return this.myPushLog;
    }

    public void push(final boolean force) {
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, "Pushing...", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/push/PushController$17", "run"));
                }
                PushController.this.myPushSettings.saveExcludedRepoRoots(PushController.this.myExcludedRepositoryRoots);
                for (PushSupport support : PushController.this.myPushSupports) {
                    PushController.this.doPush(support, force);
                }
            }
        };
        task.queue();
    }

    private <R extends Repository, S extends PushSource, T extends PushTarget> void doPush(@NotNull PushSupport<R, S, T> support, boolean force) {
        if (support == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "com/intellij/dvcs/push/PushController", "doPush"));
        }
        VcsPushOptionValue options = this.myDialog.getAdditionalOptionValue(support);
        Pusher pusher = support.getPusher();
        Map<R, PushSpec<S, T>> specs = this.collectPushSpecsForVcs(support);
        if (!specs.isEmpty()) {
            pusher.push(specs, options, force);
        }
    }

    @NotNull
    private <R extends Repository, S extends PushSource, T extends PushTarget> Map<R, PushSpec<S, T>> collectPushSpecsForVcs(@NotNull PushSupport<R, S, T> pushSupport) {
        if (pushSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pushSupport", "com/intellij/dvcs/push/PushController", "collectPushSpecsForVcs"));
        }
        HashMap pushSpecs = ContainerUtil.newHashMap();
        Collection<MyRepoModel<?, ?, ?>> repositoriesInformation = this.getSelectedRepoNode();
        for (MyRepoModel<?, ?, ?> repoModel : repositoriesInformation) {
            Object target;
            if (!pushSupport.equals(repoModel.getSupport()) || (target = repoModel.getTarget()) == null) continue;
            pushSpecs.put(repoModel.getRepository(), new PushSpec(repoModel.getSource(), target));
        }
        HashMap hashMap = pushSpecs;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "collectPushSpecsForVcs"));
        }
        return hashMap;
    }

    private Collection<MyRepoModel<?, ?, ?>> getSelectedRepoNode() {
        if (this.mySingleRepoProject) {
            return this.myView2Model.values();
        }
        return ContainerUtil.filter(this.myView2Model.values(), (Condition)new Condition<MyRepoModel<?, ?, ?>>(){

            public boolean value(MyRepoModel<?, ?, ?> model) {
                return model.isSelected();
            }
        });
    }

    public void dispose() {
        this.myExecutorService.shutdownNow();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "getProject"));
        }
        return project;
    }

    private void addMoreCommits(RepositoryNode repositoryNode) {
        MyRepoModel<?, ?, ?> repoModel = this.myView2Model.get(repositoryNode);
        repoModel.increaseShownCommits();
        this.myPushLog.setChildren((DefaultMutableTreeNode)((Object)repositoryNode), this.getPresentationForCommits(this.myProject, repoModel.getLoadedCommits(), repoModel.getNumberOfShownCommits()));
    }

    @NotNull
    private List<DefaultMutableTreeNode> getPresentationForCommits(final @NotNull Project project, @NotNull List<? extends VcsFullCommitDetails> commits, int commitsNum) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/push/PushController", "getPresentationForCommits"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/dvcs/push/PushController", "getPresentationForCommits"));
        }
        Function<VcsFullCommitDetails, DefaultMutableTreeNode> commitToNode = new Function<VcsFullCommitDetails, DefaultMutableTreeNode>(){

            public DefaultMutableTreeNode fun(VcsFullCommitDetails commit) {
                return new CommitNode(project, commit);
            }
        };
        ArrayList<DefaultMutableTreeNode> childrenToShown = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < commits.size(); ++i) {
            if (i >= commitsNum) {
                VcsLinkedTextComponent moreCommitsLink = new VcsLinkedTextComponent("<a href='loadMore'>...</a>", new VcsLinkListener(){

                    @Override
                    public void hyperlinkActivated(@NotNull DefaultMutableTreeNode sourceNode, @NotNull MouseEvent event) {
                        if (sourceNode == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNode", "com/intellij/dvcs/push/PushController$20", "hyperlinkActivated"));
                        }
                        if (event == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/dvcs/push/PushController$20", "hyperlinkActivated"));
                        }
                        TreeNode parent = sourceNode.getParent();
                        if (parent instanceof RepositoryNode) {
                            PushController.this.addMoreCommits((RepositoryNode)((Object)parent));
                        }
                    }
                });
                childrenToShown.add(new TextWithLinkNode(moreCommitsLink));
                break;
            }
            childrenToShown.add((DefaultMutableTreeNode)commitToNode.fun((Object)commits.get(i)));
        }
        ArrayList<DefaultMutableTreeNode> arrayList = childrenToShown;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "getPresentationForCommits"));
        }
        return arrayList;
    }

    @NotNull
    public Map<PushSupport, VcsPushOptionsPanel> createAdditionalPanels() {
        LinkedHashMap result = ContainerUtil.newLinkedHashMap();
        for (PushSupport<? extends Repository, ? extends PushSource, ? extends PushTarget> support : this.myPushSupports) {
            ContainerUtil.putIfNotNull(support, (Object)support.createOptionsPanel(), (Map)result);
        }
        LinkedHashMap linkedHashMap = result;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "createAdditionalPanels"));
        }
        return linkedHashMap;
    }

    public boolean ensureForcePushIsNeeded() {
        Collection<MyRepoModel<?, ?, ?>> selectedNodes = this.getSelectedRepoNode();
        MyRepoModel selectedModel = (MyRepoModel)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(selectedNodes));
        PushSupport activePushSupport = selectedModel.getSupport();
        PushTarget commonTarget = PushController.getCommonTarget(selectedNodes);
        if (commonTarget != null && activePushSupport.isSilentForcePushAllowed(commonTarget)) {
            return true;
        }
        return Messages.showOkCancelDialog((Project)this.myProject, (String)XmlStringUtil.wrapInHtml((CharSequence)DvcsBundle.message("push.force.confirmation.text", commonTarget != null ? " to <b>" + commonTarget.getPresentation() + "</b>" : "")), (String)"Force Push", (String)"&Force Push", (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon(), (DialogWrapper.DoNotAskOption)(commonTarget != null ? new MyDoNotAskOptionForPush(activePushSupport, commonTarget) : null)) == 0;
    }

    @Nullable
    private static PushTarget getCommonTarget(@NotNull Collection<MyRepoModel<?, ?, ?>> selectedNodes) {
        if (selectedNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedNodes", "com/intellij/dvcs/push/PushController", "getCommonTarget"));
        }
        Object commonTarget = ((MyRepoModel)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(selectedNodes))).getTarget();
        return commonTarget != null && !ContainerUtil.exists(selectedNodes, (Condition)new Condition<MyRepoModel<?, ?, ?>>((PushTarget)commonTarget){
            final /* synthetic */ PushTarget val$commonTarget;
            {
                this.val$commonTarget = pushTarget;
            }

            public boolean value(MyRepoModel model) {
                return !this.val$commonTarget.equals(model.getTarget());
            }
        }) ? (PushTarget)commonTarget : null;
    }

    private static class MyDoNotAskOptionForPush
    implements DialogWrapper.DoNotAskOption {
        @NotNull
        private final PushSupport myActivePushSupport;
        @NotNull
        private final PushTarget myCommonTarget;

        public MyDoNotAskOptionForPush(@NotNull PushSupport support, @NotNull PushTarget target) {
            if (support == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "com/intellij/dvcs/push/PushController$MyDoNotAskOptionForPush", "<init>"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/dvcs/push/PushController$MyDoNotAskOptionForPush", "<init>"));
            }
            this.myActivePushSupport = support;
            this.myCommonTarget = target;
        }

        public boolean isToBeShown() {
            return true;
        }

        public void setToBeShown(boolean toBeShown, int exitCode) {
            if (!toBeShown && exitCode == 0) {
                this.myActivePushSupport.saveSilentForcePushTarget(this.myCommonTarget);
            }
        }

        public boolean canBeHidden() {
            return true;
        }

        public boolean shouldSaveOptionsOnCancel() {
            return false;
        }

        @NotNull
        public String getDoNotShowMessage() {
            if ("Don't warn about this target" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController$MyDoNotAskOptionForPush", "getDoNotShowMessage"));
            }
            return "Don't warn about this target";
        }
    }

    private static class MyRepoModel<Repo extends Repository, S extends PushSource, T extends PushTarget> {
        @NotNull
        private final Repo myRepository;
        @NotNull
        private final PushSupport<Repo, S, T> mySupport;
        @NotNull
        private final S mySource;
        @Nullable
        private T myTarget;
        @Nullable
        VcsError myTargetError;
        int myNumberOfShownCommits;
        @NotNull
        List<? extends VcsFullCommitDetails> myLoadedCommits;
        @NotNull
        private final CheckBoxModel myCheckBoxModel;

        public MyRepoModel(@NotNull Repo repository, @NotNull PushSupport<Repo, S, T> supportForRepo, boolean isSelected, @NotNull S source, @Nullable T target) {
            if (repository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/push/PushController$MyRepoModel", "<init>"));
            }
            if (supportForRepo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supportForRepo", "com/intellij/dvcs/push/PushController$MyRepoModel", "<init>"));
            }
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/dvcs/push/PushController$MyRepoModel", "<init>"));
            }
            this.myLoadedCommits = Collections.emptyList();
            this.myRepository = repository;
            this.mySupport = supportForRepo;
            this.myCheckBoxModel = new CheckBoxModel(isSelected);
            this.mySource = source;
            this.myTarget = target;
            this.myNumberOfShownCommits = 20;
        }

        @NotNull
        public Repo getRepository() {
            Repo Repo = this.myRepository;
            if (Repo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController$MyRepoModel", "getRepository"));
            }
            return Repo;
        }

        @NotNull
        public PushSupport<Repo, S, T> getSupport() {
            PushSupport<Repo, S, T> pushSupport = this.mySupport;
            if (pushSupport == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController$MyRepoModel", "getSupport"));
            }
            return pushSupport;
        }

        @NotNull
        public S getSource() {
            S s = this.mySource;
            if (s == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController$MyRepoModel", "getSource"));
            }
            return s;
        }

        @Nullable
        public T getTarget() {
            return this.myTarget;
        }

        public void setTarget(@Nullable T target) {
            this.myTarget = target;
        }

        public boolean isSelected() {
            return this.myCheckBoxModel.isChecked();
        }

        public void setError(@Nullable VcsError error) {
            this.myTargetError = error;
        }

        public void clearErrors() {
            this.myTargetError = null;
        }

        public boolean hasError() {
            return this.myTargetError != null;
        }

        public int getNumberOfShownCommits() {
            return this.myNumberOfShownCommits;
        }

        public void increaseShownCommits() {
            this.myNumberOfShownCommits *= 2;
        }

        @NotNull
        public List<? extends VcsFullCommitDetails> getLoadedCommits() {
            List<? extends VcsFullCommitDetails> list = this.myLoadedCommits;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController$MyRepoModel", "getLoadedCommits"));
            }
            return list;
        }

        public void setLoadedCommits(@NotNull List<? extends VcsFullCommitDetails> loadedCommits) {
            if (loadedCommits == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loadedCommits", "com/intellij/dvcs/push/PushController$MyRepoModel", "setLoadedCommits"));
            }
            this.myLoadedCommits = loadedCommits;
        }

        public boolean hasCommitInfo() {
            return this.myTargetError != null || !this.myLoadedCommits.isEmpty();
        }

        @NotNull
        public CheckBoxModel getCheckBoxModel() {
            CheckBoxModel checkBoxModel = this.myCheckBoxModel;
            if (checkBoxModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController$MyRepoModel", "getCheckBoxModel"));
            }
            return checkBoxModel;
        }
    }
}

