/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.OutgoingResult;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.ui.CheckBoxModel;
import com.intellij.dvcs.push.ui.EditableTreeNode;
import com.intellij.dvcs.push.ui.LoadingIcon;
import com.intellij.dvcs.push.ui.PushLogTreeUtil;
import com.intellij.dvcs.push.ui.RepositoryWithBranchPanel;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepositoryNode
extends CheckedTreeNode
implements EditableTreeNode,
Comparable<RepositoryNode> {
    private static final int PROGRESS_DELAY = 100;
    private static final int START_DELAY = 500;
    @NotNull
    private final LoadingIcon myLoadingIcon;
    @NotNull
    protected final AtomicBoolean myLoading;
    @NotNull
    private final CheckBoxModel myCheckBoxModel;
    @NotNull
    private final RepositoryWithBranchPanel myRepositoryPanel;
    @Nullable
    private Future<AtomicReference<OutgoingResult>> myFuture;
    private final int myCheckBoxHGap;
    private final int myCheckBoxVGap;

    public RepositoryNode(@NotNull RepositoryWithBranchPanel repositoryPanel, @NotNull CheckBoxModel model, boolean enabled) {
        if (repositoryPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryPanel", "com/intellij/dvcs/push/ui/RepositoryNode", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dvcs/push/ui/RepositoryNode", "<init>"));
        }
        super((Object)repositoryPanel);
        this.myLoading = new AtomicBoolean();
        this.myCheckBoxModel = model;
        this.setChecked(false);
        this.setEnabled(enabled);
        this.myRepositoryPanel = repositoryPanel;
        this.myLoadingIcon = this.myRepositoryPanel.getLoadingIcon();
        this.myCheckBoxHGap = this.myRepositoryPanel.getLoadingIconAndCheckBoxGapH();
        this.myCheckBoxVGap = this.myRepositoryPanel.getLoadingIconAndCheckBoxGapV();
    }

    public boolean isChecked() {
        return this.myCheckBoxModel.isChecked();
    }

    public void setChecked(boolean checked) {
        this.myCheckBoxModel.setChecked(checked);
    }

    public boolean isCheckboxVisible() {
        return !this.myLoading.get();
    }

    @Override
    public void render(@NotNull ColoredTreeCellRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/dvcs/push/ui/RepositoryNode", "render"));
        }
        this.render(renderer, null);
    }

    public void render(@NotNull ColoredTreeCellRenderer renderer, @Nullable String syncEditingText) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/dvcs/push/ui/RepositoryNode", "render"));
        }
        int repoFixedWidth = 120;
        int borderHOffset = this.myRepositoryPanel.getHBorderOffset((SimpleColoredComponent)renderer);
        if (this.myLoading.get()) {
            renderer.setIcon((Icon)((Object)this.myLoadingIcon));
            renderer.setIconOnTheRight(false);
            int checkBoxWidth = this.myRepositoryPanel.getCheckBoxWidth();
            repoFixedWidth += checkBoxWidth;
            if (this.myCheckBoxHGap > 0) {
                renderer.append("");
                renderer.appendTextPadding(checkBoxWidth + renderer.getIconTextGap() + borderHOffset);
            }
        } else if (this.myCheckBoxHGap <= 0) {
            renderer.append("");
            renderer.appendTextPadding(this.myRepositoryPanel.calculateRendererShiftH((SimpleColoredComponent)renderer));
        }
        SimpleTextAttributes repositoryDetailsTextAttributes = PushLogTreeUtil.addTransparencyIfNeeded(SimpleTextAttributes.REGULAR_ATTRIBUTES, this.isChecked());
        renderer.append(this.getRepoName(renderer, repoFixedWidth), repositoryDetailsTextAttributes);
        renderer.appendTextPadding(repoFixedWidth);
        renderer.append(this.myRepositoryPanel.getSourceName(), repositoryDetailsTextAttributes);
        renderer.append(this.myRepositoryPanel.getArrow(), repositoryDetailsTextAttributes);
        PushTargetPanel pushTargetPanel = this.myRepositoryPanel.getTargetPanel();
        pushTargetPanel.render(renderer, renderer.getTree().isPathSelected(TreeUtil.getPathFromRoot((TreeNode)((Object)this))), this.isChecked(), syncEditingText);
        int maxSize = Math.max(this.myRepositoryPanel.getCheckBoxHeight(), this.myLoadingIcon.getIconHeight());
        int rendererHeight = renderer.getPreferredSize().height;
        if (maxSize > rendererHeight && (this.myCheckBoxVGap > 0 && this.isLoading() || this.myCheckBoxVGap < 0 && !this.isLoading())) {
            int vShift = maxSize - rendererHeight;
            renderer.setBorder((Border)new EmptyBorder((vShift + 1) / 2, 0, vShift / 2, 0));
        }
    }

    @NotNull
    private String getRepoName(@NotNull ColoredTreeCellRenderer renderer, int maxWidth) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/dvcs/push/ui/RepositoryNode", "getRepoName"));
        }
        String name = this.myRepositoryPanel.getRepositoryName();
        String string = GraphicsUtil.stringWidth((String)name, (Font)renderer.getFont()) > maxWidth - 10 ? name + "  " : name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/RepositoryNode", "getRepoName"));
        }
        return string;
    }

    public Object getUserObject() {
        return this.myRepositoryPanel;
    }

    @Override
    public void fireOnChange() {
        this.myRepositoryPanel.fireOnChange();
    }

    @Override
    public void fireOnCancel() {
        this.myRepositoryPanel.fireOnCancel();
    }

    @Override
    public void fireOnSelectionChange(boolean isSelected) {
        this.myRepositoryPanel.fireOnSelectionChange(isSelected);
    }

    @Override
    public void cancelLoading() {
        if (this.myFuture != null && !this.myFuture.isDone()) {
            this.myFuture.cancel(true);
        }
    }

    @Override
    public void startLoading(final @NotNull JTree tree, @NotNull Future<AtomicReference<OutgoingResult>> future, boolean initial) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/dvcs/push/ui/RepositoryNode", "startLoading"));
        }
        if (future == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "future", "com/intellij/dvcs/push/ui/RepositoryNode", "startLoading"));
        }
        this.myFuture = future;
        Timer t = new Timer(initial ? 500 : 100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RepositoryNode.this.myFuture.isDone()) {
                    RepositoryNode.this.myLoading.set(true);
                    RepositoryNode.this.myLoadingIcon.setObserver(tree, (TreeNode)((Object)RepositoryNode.this));
                    tree.repaint();
                }
            }
        });
        t.setRepeats(false);
        t.start();
    }

    @Override
    public boolean isEditableNow() {
        return this.myRepositoryPanel.isEditable();
    }

    @Override
    public int compareTo(@NotNull RepositoryNode repositoryNode) {
        if (repositoryNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryNode", "com/intellij/dvcs/push/ui/RepositoryNode", "compareTo"));
        }
        String name = this.myRepositoryPanel.getRepositoryName();
        RepositoryWithBranchPanel panel = (RepositoryWithBranchPanel)((Object)repositoryNode.getUserObject());
        return name.compareTo(panel.getRepositoryName());
    }

    public void stopLoading() {
        this.myLoading.set(false);
        this.myLoadingIcon.setImageObserver(null);
    }

    public boolean isLoading() {
        return this.myLoading.get();
    }
}

