/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.TestProxyFilterProvider;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.testframework.ui.TestsOutputConsolePrinter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestProxyPrinterProvider {
    private final TestProxyFilterProvider myFilterProvider;
    private BaseTestsOutputConsoleView myTestOutputConsoleView;

    public TestProxyPrinterProvider(@NotNull BaseTestsOutputConsoleView testsOutputConsoleView, @NotNull TestProxyFilterProvider filterProvider) {
        if (testsOutputConsoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testsOutputConsoleView", "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider", "<init>"));
        }
        if (filterProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterProvider", "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider", "<init>"));
        }
        this.myTestOutputConsoleView = testsOutputConsoleView;
        this.myFilterProvider = filterProvider;
    }

    @Nullable
    public Printer getPrinterByType(@NotNull String nodeType, @NotNull String nodeName, @Nullable String nodeArguments) {
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider", "getPrinterByType"));
        }
        if (nodeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeName", "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider", "getPrinterByType"));
        }
        Filter filter = this.myFilterProvider.getFilter(nodeType, nodeName, nodeArguments);
        if (filter != null) {
            return new HyperlinkPrinter(this.myTestOutputConsoleView, HyperlinkPrinter.ERROR_CONTENT_TYPE, filter);
        }
        return null;
    }

    private static class HyperlinkPrinter
    extends TestsOutputConsolePrinter {
        public static final Condition<ConsoleViewContentType> ERROR_CONTENT_TYPE = new Condition<ConsoleViewContentType>(){

            public boolean value(ConsoleViewContentType contentType) {
                return ConsoleViewContentType.ERROR_OUTPUT == contentType;
            }
        };
        private static final String NL = "\n";
        private final Condition<ConsoleViewContentType> myContentTypeCondition;
        private final Filter myFilter;

        public HyperlinkPrinter(@NotNull BaseTestsOutputConsoleView testsOutputConsoleView, @NotNull Condition<ConsoleViewContentType> contentTypeCondition, @NotNull Filter filter) {
            if (testsOutputConsoleView == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testsOutputConsoleView", "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider$HyperlinkPrinter", "<init>"));
            }
            if (contentTypeCondition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentTypeCondition", "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider$HyperlinkPrinter", "<init>"));
            }
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider$HyperlinkPrinter", "<init>"));
            }
            super(testsOutputConsoleView, testsOutputConsoleView.getProperties(), null);
            this.myContentTypeCondition = contentTypeCondition;
            this.myFilter = filter;
        }

        @Override
        public void print(String text, ConsoleViewContentType contentType) {
            if (contentType == null || !this.myContentTypeCondition.value((Object)contentType)) {
                this.defaultPrint(text, contentType);
                return;
            }
            text = StringUtil.replace((String)text, (String)"\r\n", (String)NL, (boolean)false);
            StringTokenizer tokenizer = new StringTokenizer(text, NL, true);
            while (tokenizer.hasMoreTokens()) {
                String line = tokenizer.nextToken();
                if (NL.equals(line)) {
                    this.defaultPrint(line, contentType);
                    continue;
                }
                this.printLine(line, contentType);
            }
        }

        private void defaultPrint(String text, ConsoleViewContentType contentType) {
            super.print(text, contentType);
        }

        private void printLine(@NotNull String line, @NotNull ConsoleViewContentType contentType) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider$HyperlinkPrinter", "printLine"));
            }
            if (contentType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider$HyperlinkPrinter", "printLine"));
            }
            Filter.Result result = null;
            try {
                result = this.myFilter.applyFilter(line, line.length());
            }
            catch (Throwable t) {
                throw new RuntimeException("Error while applying " + this.myFilter + " to '" + line + "'", t);
            }
            if (result != null) {
                this.defaultPrint(line.substring(0, result.getHighlightStartOffset()), contentType);
                String linkText = line.substring(result.getHighlightStartOffset(), result.getHighlightEndOffset());
                this.printHyperlink(linkText, result.getHyperlinkInfo());
                this.defaultPrint(line.substring(result.getHighlightEndOffset()), contentType);
            } else {
                this.defaultPrint(line, contentType);
            }
        }
    }
}

