/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.find.EditorSearchComponent;
import com.intellij.find.editorHeaderActions.EditorHeaderAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import java.util.Collections;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class RestorePreviousSettingsAction
extends EditorHeaderAction
implements DumbAware {
    private final JTextComponent myTextField;
    private static final KeyboardShortcut SHORTCUT = new KeyboardShortcut(KeyStroke.getKeyStroke(10, 0), null);

    public RestorePreviousSettingsAction(EditorSearchComponent editorSearchComponent, JTextComponent textField) {
        super(editorSearchComponent);
        this.myTextField = textField;
        this.registerShortcutsForComponent(Collections.singletonList(SHORTCUT), textField);
    }

    public void actionPerformed(AnActionEvent e) {
        this.getEditorSearchComponent().restoreFindModel();
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(this.myTextField.getText().isEmpty());
    }

    public static String getAd() {
        return "Use " + KeymapUtil.getShortcutText((Shortcut)SHORTCUT) + " to restore previous find/replace settings";
    }
}

